package com.mysema.query.collections.dml;

import java.util.Collection;

import com.mysema.query.collections.ColQuery;
import com.mysema.query.collections.impl.ColQueryImpl;
import com.mysema.query.collections.impl.EvaluatorFactory;
import com.mysema.query.dml.DeleteClause;
import com.mysema.query.types.expr.EBoolean;
import com.mysema.query.types.path.Path;

/**
 * @author tiwe
 *
 * @param <T>
 */
public class ColDeleteClause<T> implements DeleteClause<ColDeleteClause<T>>{

    private final ColQuery query;
    
    private final Path<T> expr;
    
    private final Collection<? extends T> col;
    
    public ColDeleteClause(EvaluatorFactory ef, Path<T> expr, Collection<? extends T> col){
        this.query = new ColQueryImpl(ef).from(expr, col);
        this.expr = expr;
        this.col = col;
    }
    
    @Override
    public long execute() {
        int rv = 0;
        for (T match : query.list(expr.asExpr())){
            col.remove(match);
            rv++;
        }
        return rv;
    }

    @Override
    public ColDeleteClause<T> where(EBoolean... o) {
        query.where(o);
        return this;
    }

}
