/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.codegen;

import com.google.common.primitives.Primitives;
import com.mysema.codegen.model.ClassType;
import com.mysema.codegen.model.SimpleType;
import com.mysema.codegen.model.TypeCategory;
import com.mysema.codegen.model.TypeExtends;
import com.mysema.codegen.model.TypeSuper;
import com.mysema.codegen.model.Types;
import com.mysema.query.codegen.EntityType;
import com.mysema.util.ReflectionUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class TypeFactory {
    private static final com.mysema.codegen.model.Type[] TYPES_0 = new com.mysema.codegen.model.Type[0];
    private static final com.mysema.codegen.model.Type[] TYPES_1 = new com.mysema.codegen.model.Type[]{Types.OBJECT};
    private static final com.mysema.codegen.model.Type[] TYPES_2 = new com.mysema.codegen.model.Type[]{Types.OBJECT, Types.OBJECT};
    private final Map<List<Type>, com.mysema.codegen.model.Type> cache = new HashMap<List<Type>, com.mysema.codegen.model.Type>();
    private final Collection<Class<? extends Annotation>> entityAnnotations;
    private final Set<Class<?>> embeddableTypes = new HashSet();
    private boolean unknownAsEntity = false;

    public TypeFactory(Class<?> ... entityAnnotations) {
        this(Arrays.asList(entityAnnotations));
    }

    public TypeFactory(List<Class<? extends Annotation>> entityAnnotations) {
        this.entityAnnotations = entityAnnotations;
    }

    public EntityType createEntityType(Class<?> cl) {
        return (EntityType)this.create(true, cl, cl);
    }

    public com.mysema.codegen.model.Type create(Class<?> cl) {
        return this.create(this.isEntityClass(cl), cl, cl);
    }

    public com.mysema.codegen.model.Type create(Class<?> cl, Type genericType) {
        return this.create(this.isEntityClass(cl), cl, genericType);
    }

    public com.mysema.codegen.model.Type create(boolean entity, Class<?> cl, Type genericType) {
        List<Type> key = Arrays.asList(cl, genericType);
        if (this.cache.containsKey(key)) {
            Object value = this.cache.get(key);
            if (entity && !(value instanceof EntityType)) {
                value = new EntityType((com.mysema.codegen.model.Type)value);
                this.cache.put(key, (com.mysema.codegen.model.Type)value);
            }
            return value;
        }
        if (cl.isPrimitive()) {
            cl = Primitives.wrap(cl);
        }
        com.mysema.codegen.model.Type[] parameters = this.getParameters(cl, genericType);
        Object value = cl.isArray() ? this.create(cl.getComponentType()).asArrayType() : (cl.isEnum() ? new ClassType(TypeCategory.ENUM, cl, new com.mysema.codegen.model.Type[0]) : (Map.class.isAssignableFrom(cl) ? new SimpleType((com.mysema.codegen.model.Type)Types.MAP, new com.mysema.codegen.model.Type[]{parameters[0], parameters[1]}) : (List.class.isAssignableFrom(cl) ? new SimpleType((com.mysema.codegen.model.Type)Types.LIST, new com.mysema.codegen.model.Type[]{parameters[0]}) : (Set.class.isAssignableFrom(cl) ? new SimpleType((com.mysema.codegen.model.Type)Types.SET, new com.mysema.codegen.model.Type[]{parameters[0]}) : (Collection.class.isAssignableFrom(cl) ? new SimpleType((com.mysema.codegen.model.Type)Types.COLLECTION, new com.mysema.codegen.model.Type[]{parameters[0]}) : (Number.class.isAssignableFrom(cl) && Comparable.class.isAssignableFrom(cl) ? new ClassType(TypeCategory.NUMERIC, cl, parameters) : this.createOther(cl, entity, parameters)))))));
        if (genericType instanceof TypeVariable) {
            TypeVariable tv = (TypeVariable)genericType;
            value = tv.getBounds().length == 1 && tv.getBounds()[0].equals(Object.class) ? new TypeSuper(tv.getName(), value) : new TypeExtends(tv.getName(), value);
        }
        if (entity) {
            value = new EntityType((com.mysema.codegen.model.Type)value);
        }
        this.cache.put(key, (com.mysema.codegen.model.Type)value);
        return value;
    }

    private com.mysema.codegen.model.Type createOther(Class<?> cl, boolean entity, com.mysema.codegen.model.Type[] parameters) {
        TypeCategory typeCategory = TypeCategory.get((String)cl.getName());
        if (!typeCategory.isSubCategoryOf(TypeCategory.COMPARABLE) && Comparable.class.isAssignableFrom(cl) && !cl.equals(Comparable.class)) {
            typeCategory = TypeCategory.COMPARABLE;
        } else if (this.embeddableTypes.contains(cl)) {
            typeCategory = TypeCategory.CUSTOM;
        } else if (typeCategory == TypeCategory.SIMPLE && entity) {
            typeCategory = TypeCategory.ENTITY;
        } else if (this.unknownAsEntity && typeCategory == TypeCategory.SIMPLE && !cl.getName().startsWith("java")) {
            typeCategory = TypeCategory.CUSTOM;
        }
        ClassType value = new ClassType(typeCategory, cl, parameters);
        return value;
    }

    private com.mysema.codegen.model.Type[] getParameters(Class<?> cl, Type genericType) {
        int parameterCount = ReflectionUtils.getTypeParameterCount((Type)genericType);
        if (parameterCount > 0) {
            boolean collectionOrMap = Collection.class.isAssignableFrom(cl) || Map.class.isAssignableFrom(cl);
            return this.getGenericParameters(cl, genericType, collectionOrMap, parameterCount);
        }
        if (Collection.class.isAssignableFrom(cl)) {
            return TYPES_1;
        }
        if (Map.class.isAssignableFrom(cl)) {
            return TYPES_2;
        }
        if (cl.getTypeParameters().length > 0) {
            return this.getTypeParameters(cl);
        }
        return TYPES_0;
    }

    private com.mysema.codegen.model.Type[] getGenericParameters(Class<?> cl, Type genericType, boolean collectionOrMap, int parameterCount) {
        com.mysema.codegen.model.Type[] types = new com.mysema.codegen.model.Type[parameterCount];
        for (int i = 0; i < types.length; ++i) {
            types[i] = this.getGenericParameter(cl, genericType, collectionOrMap, i);
        }
        return types;
    }

    private com.mysema.codegen.model.Type getGenericParameter(Class<?> cl, Type genericType, boolean collectionOrMap, int i) {
        Type parameter = ((ParameterizedType)genericType).getActualTypeArguments()[i];
        if (parameter instanceof TypeVariable && ((TypeVariable)parameter).getBounds()[0].equals(Object.class)) {
            return collectionOrMap ? Types.OBJECT : null;
        }
        if (parameter instanceof WildcardType && ((WildcardType)parameter).getUpperBounds()[0].equals(Object.class) && ((WildcardType)parameter).getLowerBounds().length == 0) {
            com.mysema.codegen.model.Type rv = this.getTypeParameter(cl, i);
            return collectionOrMap && rv == null ? Types.OBJECT : rv;
        }
        com.mysema.codegen.model.Type rv = this.create(ReflectionUtils.getTypeParameter((Type)genericType, (int)i), parameter);
        if (parameter instanceof WildcardType) {
            rv = new TypeExtends(rv);
        }
        return rv;
    }

    private com.mysema.codegen.model.Type[] getTypeParameters(Class<?> cl) {
        com.mysema.codegen.model.Type[] types = new com.mysema.codegen.model.Type[cl.getTypeParameters().length];
        for (int i = 0; i < types.length; ++i) {
            types[i] = this.getTypeParameter(cl, i);
        }
        return types;
    }

    private com.mysema.codegen.model.Type getTypeParameter(Class<?> cl, int i) {
        TypeVariable<Class<?>> typeVariable = cl.getTypeParameters()[i];
        Type firstBound = typeVariable.getBounds()[0];
        if (firstBound.equals(Object.class)) {
            return null;
        }
        if (firstBound.equals(cl)) {
            return new ClassType(cl, new com.mysema.codegen.model.Type[0]);
        }
        if (firstBound instanceof Class) {
            return this.create((Class)typeVariable.getBounds()[0], typeVariable);
        }
        if (firstBound instanceof ParameterizedType) {
            ParameterizedType parameterized = (ParameterizedType)firstBound;
            Class rawType = (Class)parameterized.getRawType();
            if (rawType.equals(cl)) {
                return new TypeExtends(typeVariable.getName(), (com.mysema.codegen.model.Type)new ClassType(cl, new com.mysema.codegen.model.Type[0]));
            }
            return new TypeExtends(this.create(rawType, rawType));
        }
        throw new IllegalStateException(typeVariable.getBounds()[0].getClass().toString());
    }

    private boolean isEntityClass(Class<?> cl) {
        for (Class<? extends Annotation> clazz : this.entityAnnotations) {
            if (cl.getAnnotation(clazz) == null) continue;
            return true;
        }
        return this.embeddableTypes.contains(cl);
    }

    public void setUnknownAsEntity(boolean unknownAsEntity) {
        this.unknownAsEntity = unknownAsEntity;
    }

    public void addEmbeddableType(Class<?> cl) {
        this.embeddableTypes.add(cl);
    }
}

