/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.apt.jpa;

import com.google.common.collect.ImmutableList;
import com.mysema.query.annotations.PropertyType;
import com.mysema.query.annotations.QueryEntities;
import com.mysema.query.annotations.QueryTransient;
import com.mysema.query.annotations.QueryType;
import com.mysema.query.apt.AbstractQuerydslProcessor;
import com.mysema.query.apt.DefaultConfiguration;
import com.mysema.query.apt.QueryTypeImpl;
import com.mysema.query.apt.TypeUtils;
import com.mysema.query.apt.VisitorConfig;
import com.mysema.query.codegen.Keywords;
import com.mysema.util.Annotations;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Embedded;
import javax.persistence.EmbeddedId;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.MapKeyEnumerated;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.Temporal;
import javax.persistence.Transient;
import javax.persistence.Version;

public class JPAConfiguration
extends DefaultConfiguration {
    private final List<Class<? extends Annotation>> annotations = this.getAnnotations();
    private final Types types = AbstractQuerydslProcessor.TYPES;

    public JPAConfiguration(RoundEnvironment roundEnv, Map<String, String> options, Class<? extends Annotation> entityAnn, Class<? extends Annotation> superTypeAnn, Class<? extends Annotation> embeddableAnn, Class<? extends Annotation> embeddedAnn, Class<? extends Annotation> skipAnn) {
        super(roundEnv, options, Keywords.JPA, QueryEntities.class, entityAnn, superTypeAnn, embeddableAnn, embeddedAnn, skipAnn);
        this.setStrictMode(true);
    }

    protected List<Class<? extends Annotation>> getAnnotations() {
        return ImmutableList.of(Access.class, Basic.class, Column.class, ElementCollection.class, Embedded.class, EmbeddedId.class, Enumerated.class, GeneratedValue.class, Id.class, JoinColumn.class, ManyToOne.class, ManyToMany.class, (Object[])new Class[]{MapKeyEnumerated.class, OneToOne.class, OneToMany.class, PrimaryKeyJoinColumn.class, QueryType.class, QueryTransient.class, Temporal.class, Transient.class, Version.class});
    }

    @Override
    public VisitorConfig getConfig(TypeElement e, List<? extends Element> elements) {
        Access access = e.getAnnotation(Access.class);
        if (access != null) {
            if (access.value() == AccessType.FIELD) {
                return VisitorConfig.FIELDS_ONLY;
            }
            return VisitorConfig.METHODS_ONLY;
        }
        boolean fields = false;
        boolean methods = false;
        for (Element element : elements) {
            if (!this.hasRelevantAnnotation(element)) continue;
            fields |= element.getKind().equals((Object)ElementKind.FIELD);
            methods |= element.getKind().equals((Object)ElementKind.METHOD);
        }
        return VisitorConfig.get(fields, methods);
    }

    @Override
    public TypeMirror getRealType(ExecutableElement method) {
        return this.getRealElementType(method);
    }

    @Override
    public TypeMirror getRealType(VariableElement field) {
        return this.getRealElementType(field);
    }

    private TypeMirror getRealElementType(Element element) {
        AnnotationMirror mirror = TypeUtils.getAnnotationMirrorOfType(element, ManyToOne.class);
        if (mirror == null) {
            mirror = TypeUtils.getAnnotationMirrorOfType(element, OneToOne.class);
        }
        if (mirror != null) {
            return TypeUtils.getAnnotationValueAsTypeMirror(mirror, "targetEntity");
        }
        mirror = TypeUtils.getAnnotationMirrorOfType(element, OneToMany.class);
        if (mirror == null) {
            mirror = TypeUtils.getAnnotationMirrorOfType(element, ManyToMany.class);
        }
        if (mirror != null) {
            TypeMirror typeArg = TypeUtils.getAnnotationValueAsTypeMirror(mirror, "targetEntity");
            TypeMirror erasure = this.types.erasure(element.asType());
            TypeElement typeElement = (TypeElement)this.types.asElement(erasure);
            if (typeElement != null && typeArg != null) {
                if (typeElement.getTypeParameters().size() == 1) {
                    return this.types.getDeclaredType(typeElement, typeArg);
                }
                if (typeElement.getTypeParameters().size() == 2 && element.asType() instanceof DeclaredType) {
                    TypeMirror first = ((DeclaredType)element.asType()).getTypeArguments().get(0);
                    return this.types.getDeclaredType(typeElement, first, typeArg);
                }
            }
        }
        return null;
    }

    @Override
    public void inspect(Element element, Annotations annotations) {
        Temporal temporal = element.getAnnotation(Temporal.class);
        if (temporal != null && element.getAnnotation(ElementCollection.class) == null) {
            PropertyType propertyType = null;
            switch (temporal.value()) {
                case DATE: {
                    propertyType = PropertyType.DATE;
                    break;
                }
                case TIME: {
                    propertyType = PropertyType.TIME;
                    break;
                }
                case TIMESTAMP: {
                    propertyType = PropertyType.DATETIME;
                }
            }
            annotations.addAnnotation((Annotation)((Object)new QueryTypeImpl(propertyType)));
        }
    }

    private boolean hasRelevantAnnotation(Element element) {
        for (Class<? extends Annotation> annotation : this.annotations) {
            if (element.getAnnotation(annotation) == null) continue;
            return true;
        }
        return false;
    }
}

