/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.apt.jdo;

import com.mysema.query.apt.APTException;
import com.mysema.query.apt.DefaultConfiguration;
import com.mysema.query.apt.Processor;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;

@SupportedAnnotationTypes(value={"com.mysema.query.annotations.*", "javax.jdo.annotations.*"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_6)
public class JDOAnnotationProcessor
extends AbstractProcessor {
    private static final Set<String> KEYWORDS = new HashSet<String>(Arrays.asList("AS", "ASC", "ASCENDING", "AVG", "BY", "COUNT", "DESC", "DESCENDING", "DISTINCT", "EXCLUDE", "FROM", "GROUP", "HAVING", "INTO", "MAX", "MIN", "ORDER", "PARAMETERS", "RANGE", "SELECT", "SUBCLASSES", "SUM", "UNIQUE", "VARIABLES", "WHERE"));
    private Class<? extends Annotation> entity;
    private Class<? extends Annotation> embeddable;
    private Class<? extends Annotation> skip;

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        try {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "Running " + this.getClass().getSimpleName());
            this.entity = Class.forName("javax.jdo.annotations.PersistenceCapable");
            this.embeddable = Class.forName("javax.jdo.annotations.EmbeddedOnly");
            this.skip = Class.forName("javax.jdo.annotations.NotPersistent");
            DefaultConfiguration configuration = new DefaultConfiguration(roundEnv, this.processingEnv.getOptions(), KEYWORDS, null, this.entity, null, this.embeddable, null, this.skip);
            configuration.setUseGetters(false);
            Processor processor = new Processor(this.processingEnv, roundEnv, configuration);
            processor.process();
            return true;
        }
        catch (ClassNotFoundException e) {
            throw new APTException(e.getMessage(), e);
        }
    }
}

