/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.apt;

import com.mysema.commons.lang.Assert;
import com.mysema.query.annotations.QueryExtensions;
import com.mysema.query.annotations.QueryMethod;
import com.mysema.query.annotations.QueryProjection;
import com.mysema.query.annotations.QuerydslVariables;
import com.mysema.query.apt.APTTypeFactory;
import com.mysema.query.apt.Configuration;
import com.mysema.query.apt.ElementHandler;
import com.mysema.query.codegen.EntityType;
import com.mysema.query.codegen.Method;
import com.mysema.query.codegen.Serializer;
import com.mysema.query.codegen.SerializerConfig;
import com.mysema.query.codegen.Supertype;
import com.mysema.query.codegen.Type;
import com.mysema.query.codegen.TypeFactory;
import com.mysema.query.codegen.TypeMappings;
import com.mysema.util.CodeWriter;
import com.mysema.util.JavaWriter;
import java.io.IOException;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Processor {
    private static final Logger logger = LoggerFactory.getLogger(Processor.class);
    private final Map<String, EntityType> actualSupertypes = new HashMap<String, EntityType>();
    private final Map<String, EntityType> allSupertypes = new HashMap<String, EntityType>();
    private final Configuration configuration;
    private final Map<String, EntityType> dtos = new HashMap<String, EntityType>();
    private final ElementHandler elementHandler;
    private final Map<String, EntityType> embeddables = new HashMap<String, EntityType>();
    private final Map<String, EntityType> entityTypes = new HashMap<String, EntityType>();
    private final ProcessingEnvironment env;
    private final Map<String, EntityType> extensionTypes = new HashMap<String, EntityType>();
    private final RoundEnvironment roundEnv;
    private final APTTypeFactory typeModelFactory;

    public Processor(ProcessingEnvironment env, RoundEnvironment roundEnv, Configuration configuration) {
        this.env = (ProcessingEnvironment)Assert.notNull((Object)env);
        this.roundEnv = (RoundEnvironment)Assert.notNull((Object)roundEnv);
        this.configuration = (Configuration)Assert.notNull((Object)configuration);
        ArrayList<Class<? extends Annotation>> anns = new ArrayList<Class<? extends Annotation>>();
        anns.add(configuration.getEntityAnn());
        if (configuration.getSuperTypeAnn() != null) {
            anns.add(configuration.getSuperTypeAnn());
        }
        if (configuration.getEmbeddableAnn() != null) {
            anns.add(configuration.getEmbeddableAnn());
        }
        TypeFactory factory = new TypeFactory(anns);
        this.typeModelFactory = new APTTypeFactory(env, configuration, factory, anns);
        this.elementHandler = new ElementHandler(configuration, this.typeModelFactory);
    }

    private void addSupertypeFields(EntityType model, Map<String, EntityType> superTypes) {
        ArrayDeque<Supertype> stypeStack = new ArrayDeque<Supertype>();
        stypeStack.addAll(model.getSuperTypes());
        while (!stypeStack.isEmpty()) {
            Supertype sdecl = (Supertype)stypeStack.pop();
            EntityType entityType = superTypes.get(sdecl.getType().getFullName());
            if (entityType == null) continue;
            sdecl.setEntityType(entityType);
            model.include(sdecl);
            for (Supertype type : sdecl.getEntityType().getSuperTypes()) {
                stypeStack.push(type);
            }
        }
    }

    private void handleExtensionType(TypeMirror type, Element element) {
        EntityType entityModel = this.typeModelFactory.createEntityType(type);
        HashSet<Method> queryMethods = new HashSet<Method>();
        for (ExecutableElement executableElement : ElementFilter.methodsIn(element.getEnclosedElements())) {
            if (executableElement.getAnnotation(QueryMethod.class) == null) continue;
            this.elementHandler.handleQueryMethod(entityModel, executableElement, queryMethods);
        }
        for (Method method : queryMethods) {
            entityModel.addMethod(method);
        }
        this.extensionTypes.put(entityModel.getFullName(), entityModel);
    }

    public void process() {
        this.processCustomTypes();
        this.processExtensions();
        if (this.configuration.getSuperTypeAnn() != null) {
            this.processSupertypes();
        }
        this.processEntities();
        if (this.configuration.getEmbeddableAnn() != null) {
            this.processEmbeddables();
        }
        this.processDTOs();
        for (String string : this.entityTypes.keySet()) {
            this.extensionTypes.remove(string);
        }
        this.serialize(this.configuration.getSupertypeSerializer(), this.actualSupertypes);
        this.serialize(this.configuration.getEntitySerializer(), this.entityTypes);
        this.serialize(this.configuration.getEmbeddableSerializer(), this.extensionTypes);
        this.serialize(this.configuration.getEmbeddableSerializer(), this.embeddables);
        this.serialize(this.configuration.getDTOSerializer(), this.dtos);
        for (Element element : this.roundEnv.getElementsAnnotatedWith(QuerydslVariables.class)) {
            if (!(element instanceof PackageElement)) continue;
            QuerydslVariables vars = element.getAnnotation(QuerydslVariables.class);
            PackageElement packageElement = (PackageElement)element;
            ArrayList<EntityType> models = new ArrayList<EntityType>();
            for (EntityType model : this.entityTypes.values()) {
                if (!model.getPackageName().equals(packageElement.getQualifiedName().toString())) continue;
                models.add(model);
            }
            this.serializeVariableList(packageElement.getQualifiedName().toString(), vars, models);
        }
    }

    private void process(Class<? extends Annotation> annotation, Map<String, EntityType> types) {
        ArrayDeque<Type> superTypes = new ArrayDeque<Type>();
        for (Element element : this.roundEnv.getElementsAnnotatedWith(annotation)) {
            if (this.configuration.getEmbeddableAnn() != null && element.getAnnotation(this.configuration.getEmbeddableAnn()) != null) continue;
            EntityType model = this.elementHandler.handleNormalType((TypeElement)element);
            types.put(model.getFullName(), model);
            if (model.getSuperType() == null) continue;
            superTypes.push(model.getSuperType().getType());
        }
        while (!superTypes.isEmpty()) {
            Type superType = (Type)superTypes.pop();
            if (types.containsKey(superType.getFullName()) || this.allSupertypes.containsKey(superType.getFullName())) continue;
            TypeElement typeElement = this.env.getElementUtils().getTypeElement(superType.getFullName());
            EntityType entityType = this.elementHandler.handleNormalType(typeElement);
            if (entityType.getSuperType() != null) {
                superTypes.push(entityType.getSuperType().getType());
            }
            types.put(superType.getFullName(), entityType);
        }
        this.allSupertypes.putAll(types);
        for (EntityType entityType : types.values()) {
            this.addSupertypeFields(entityType, this.allSupertypes);
        }
    }

    private void processCustomTypes() {
        for (Element element : this.roundEnv.getElementsAnnotatedWith(QueryMethod.class)) {
            Element element2 = element.getEnclosingElement();
            if (element2.getAnnotation(QueryExtensions.class) != null || element2.getAnnotation(this.configuration.getEntityAnn()) != null || this.configuration.getSuperTypeAnn() != null && element2.getAnnotation(this.configuration.getSuperTypeAnn()) != null || this.configuration.getEmbeddableAnn() != null && element2.getAnnotation(this.configuration.getEmbeddableAnn()) != null) continue;
            this.handleExtensionType(element2.asType(), element2);
        }
    }

    private void processDTOs() {
        HashSet<Element> visitedDTOTypes = new HashSet<Element>();
        for (Element element : this.roundEnv.getElementsAnnotatedWith(QueryProjection.class)) {
            Element parent = element.getEnclosingElement();
            if (parent.getAnnotation(this.configuration.getEntityAnn()) != null || parent.getAnnotation(this.configuration.getEmbeddableAnn()) != null || visitedDTOTypes.contains(parent)) continue;
            EntityType model = this.elementHandler.handleProjectionType((TypeElement)parent);
            this.dtos.put(model.getFullName(), model);
            visitedDTOTypes.add(parent);
        }
    }

    private void processEmbeddables() {
        for (Element element : this.roundEnv.getElementsAnnotatedWith(this.configuration.getEmbeddableAnn())) {
            EntityType model = this.elementHandler.handleNormalType((TypeElement)element);
            this.embeddables.put(model.getFullName(), model);
        }
        this.allSupertypes.putAll(this.embeddables);
        for (EntityType entityType : this.embeddables.values()) {
            this.addSupertypeFields(entityType, this.allSupertypes);
        }
    }

    private void processEntities() {
        this.process(this.configuration.getEntityAnn(), this.entityTypes);
    }

    private void processExtensions() {
        for (Element element : this.roundEnv.getElementsAnnotatedWith(QueryExtensions.class)) {
            for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
                if (!annotationMirror.getAnnotationType().asElement().getSimpleName().toString().equals(QueryExtensions.class.getSimpleName())) continue;
                for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
                    if (!entry.getKey().getSimpleName().toString().equals("value")) continue;
                    TypeMirror type = (TypeMirror)entry.getValue().getValue();
                    this.handleExtensionType(type, element);
                }
            }
        }
    }

    private void processSupertypes() {
        this.process(this.configuration.getSuperTypeAnn(), this.actualSupertypes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serialize(Serializer serializer, Map<String, EntityType> models) {
        Messager msg = this.env.getMessager();
        for (EntityType model : models.values()) {
            msg.printMessage(Diagnostic.Kind.NOTE, model.getFullName() + " is processed");
            try {
                String packageName = model.getPackageName();
                String localName = this.configuration.getTypeMappings().getPathType((Type)model, model, true);
                String className = packageName + "." + localName;
                if (this.env.getElementUtils().getTypeElement(className) == null) {
                    JavaFileObject fileObject = this.env.getFiler().createSourceFile(className, new Element[0]);
                    Writer writer = fileObject.openWriter();
                    try {
                        SerializerConfig serializerConfig = this.configuration.getSerializerConfig(model);
                        serializer.serialize(model, serializerConfig, (CodeWriter)new JavaWriter((Appendable)writer));
                        continue;
                    }
                    finally {
                        if (writer != null) {
                            writer.close();
                        }
                        continue;
                    }
                }
                msg.printMessage(Diagnostic.Kind.NOTE, className + " already available");
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
                msg.printMessage(Diagnostic.Kind.ERROR, e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serializeVariableList(String packageName, QuerydslVariables vars, List<EntityType> models) {
        String className = packageName + "." + vars.value();
        TypeMappings typeMappings = this.configuration.getTypeMappings();
        try {
            JavaFileObject fileObject = this.env.getFiler().createSourceFile(className, new Element[0]);
            Writer w = fileObject.openWriter();
            try {
                JavaWriter writer = new JavaWriter((Appendable)w);
                writer.packageDecl(packageName);
                writer.nl();
                if (vars.asInterface()) {
                    writer.beginInterface(vars.value(), new String[0]);
                } else {
                    writer.beginClass(vars.value(), null, new String[0]);
                }
                for (EntityType model : models) {
                    String queryType = typeMappings.getPathType((Type)model, model, true);
                    String simpleName = model.getUncapSimpleName();
                    writer.publicStaticFinal(queryType, simpleName, "new " + queryType + "(\"" + simpleName + "\")");
                }
                writer.end();
            }
            finally {
                w.close();
            }
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            this.env.getMessager().printMessage(Diagnostic.Kind.ERROR, e.getMessage());
        }
    }
}

