/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.apt;

import com.mysema.query.apt.Configuration;
import com.mysema.query.apt.TypeArgumentsException;
import com.mysema.query.codegen.EntityType;
import com.mysema.query.codegen.SimpleType;
import com.mysema.query.codegen.Supertype;
import com.mysema.query.codegen.Type;
import com.mysema.query.codegen.TypeCategory;
import com.mysema.query.codegen.TypeExtends;
import com.mysema.query.codegen.TypeFactory;
import com.mysema.query.codegen.TypeSuper;
import com.mysema.query.codegen.Types;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.NullType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;

public final class APTTypeFactory {
    private final Map<List<String>, Type> cache = new HashMap<List<String>, Type>();
    private final Configuration configuration;
    private final Type defaultValue;
    private final List<Class<? extends Annotation>> entityAnnotations;
    private final Map<List<String>, EntityType> entityTypeCache = new HashMap<List<String>, EntityType>();
    private final ProcessingEnvironment env;
    private final TypeFactory factory;
    private final TypeElement numberType;
    private final TypeElement comparableType;

    @Nullable
    private static Class<?> safeClassForName(String name) {
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public APTTypeFactory(ProcessingEnvironment env, Configuration configuration, TypeFactory factory, List<Class<? extends Annotation>> annotations) {
        this.env = env;
        this.configuration = configuration;
        this.factory = factory;
        this.defaultValue = factory.create(Object.class);
        this.entityAnnotations = annotations;
        this.numberType = env.getElementUtils().getTypeElement(Number.class.getName());
        this.comparableType = env.getElementUtils().getTypeElement(Comparable.class.getName());
    }

    private Type create(TypeElement typeElement, TypeCategory category, List<? extends TypeMirror> typeArgs) {
        String name = typeElement.getQualifiedName().toString();
        String simpleName = typeElement.getSimpleName().toString();
        String packageName = this.env.getElementUtils().getPackageOf(typeElement).getQualifiedName().toString();
        Type[] params = new Type[typeArgs.size()];
        for (int i = 0; i < params.length; ++i) {
            params[i] = this.create(typeArgs.get(i));
        }
        return new SimpleType(category, name, packageName, simpleName, typeElement.getModifiers().contains((Object)Modifier.FINAL), params);
    }

    @Nullable
    public Type create(TypeMirror type) {
        List<String> key = this.createKey(type, true);
        if (this.entityTypeCache.containsKey(key)) {
            return (Type)this.entityTypeCache.get(key);
        }
        if (this.cache.containsKey(key)) {
            return this.cache.get(key);
        }
        this.cache.put(key, null);
        Type typeModel = this.handle(type);
        if (typeModel != null && typeModel.getCategory() == TypeCategory.ENTITY) {
            EntityType entityType = this.createEntityType(type);
            this.cache.put(key, (Type)entityType);
            return entityType;
        }
        this.cache.put(key, typeModel);
        return typeModel;
    }

    private Type createClassType(DeclaredType t, TypeElement typeElement) {
        for (Class<? extends Annotation> entityAnn : this.entityAnnotations) {
            if (typeElement.getAnnotation(entityAnn) == null) continue;
            return this.create(typeElement, TypeCategory.ENTITY, t.getTypeArguments());
        }
        String name = typeElement.getQualifiedName().toString();
        TypeCategory typeCategory = TypeCategory.get((String)name);
        if (typeCategory != TypeCategory.NUMERIC && this.isAssignable(typeElement, this.comparableType) && this.isSubType(typeElement, this.numberType)) {
            typeCategory = TypeCategory.NUMERIC;
        } else if (!typeCategory.isSubCategoryOf(TypeCategory.COMPARABLE) && this.isAssignable(typeElement, this.comparableType)) {
            typeCategory = TypeCategory.COMPARABLE;
        }
        return this.create(typeElement, typeCategory, t.getTypeArguments());
    }

    @Nullable
    public EntityType createEntityType(TypeMirror type) {
        List<String> key = this.createKey(type, true);
        if (this.entityTypeCache.containsKey(key)) {
            return this.entityTypeCache.get(key);
        }
        this.entityTypeCache.put(key, null);
        Type value = this.handle(type);
        if (value != null) {
            EntityType entityModel = new EntityType(this.configuration.getNamePrefix(), value);
            this.entityTypeCache.put(key, entityModel);
            for (Type superType : this.getSupertypes(type, value)) {
                entityModel.addSupertype(new Supertype(superType));
            }
            return entityModel;
        }
        return null;
    }

    private Type createEnumType(DeclaredType t, TypeElement typeElement) {
        for (Class<? extends Annotation> entityAnn : this.entityAnnotations) {
            if (typeElement.getAnnotation(entityAnn) == null) continue;
            return this.create(typeElement, TypeCategory.ENTITY, t.getTypeArguments());
        }
        return this.create(typeElement, TypeCategory.SIMPLE, t.getTypeArguments());
    }

    private Type createInterfaceType(DeclaredType t, TypeElement typeElement) {
        for (Class<? extends Annotation> entityAnn : this.entityAnnotations) {
            if (typeElement.getAnnotation(entityAnn) == null) continue;
            return this.create(typeElement, TypeCategory.ENTITY, t.getTypeArguments());
        }
        String name = typeElement.getQualifiedName().toString();
        String simpleName = typeElement.getSimpleName().toString();
        Iterator<? extends TypeMirror> i = t.getTypeArguments().iterator();
        Class<?> cl = APTTypeFactory.safeClassForName(name);
        if (cl == null) {
            return this.create(typeElement, TypeCategory.get((String)name), t.getTypeArguments());
        }
        if (Map.class.isAssignableFrom(cl)) {
            return this.createMapType(simpleName, i);
        }
        if (List.class.isAssignableFrom(cl)) {
            return this.createListType(simpleName, i);
        }
        if (Set.class.isAssignableFrom(cl)) {
            return this.createSetType(simpleName, i);
        }
        if (Collection.class.isAssignableFrom(cl)) {
            return this.createCollectionType(simpleName, i);
        }
        return this.create(typeElement, TypeCategory.get((String)name), t.getTypeArguments());
    }

    private Type createCollectionType(String simpleName, Iterator<? extends TypeMirror> i) {
        if (!i.hasNext()) {
            throw new TypeArgumentsException(simpleName);
        }
        return this.factory.createCollectionType(this.create(i.next()));
    }

    private Type createSetType(String simpleName, Iterator<? extends TypeMirror> i) {
        if (!i.hasNext()) {
            throw new TypeArgumentsException(simpleName);
        }
        return this.factory.createSetType(this.create(i.next()));
    }

    private Type createListType(String simpleName, Iterator<? extends TypeMirror> i) {
        if (!i.hasNext()) {
            throw new TypeArgumentsException(simpleName);
        }
        return this.factory.createListType(this.create(i.next()));
    }

    private Type createMapType(String simpleName, Iterator<? extends TypeMirror> i) {
        if (!i.hasNext()) {
            throw new TypeArgumentsException(simpleName);
        }
        return this.factory.createMapType(this.create(i.next()), this.create(i.next()));
    }

    private List<String> createKey(TypeMirror type, boolean deep) {
        ArrayList<String> key = new ArrayList<String>();
        String name = ((Object)type).toString();
        if (name.contains("<")) {
            name = name.substring(0, name.indexOf(60));
        }
        key.add(name);
        if (type.getKind() == TypeKind.TYPEVAR) {
            TypeVariable t = (TypeVariable)type;
            if (t.getUpperBound() != null) {
                key.addAll(this.createKey(t.getUpperBound(), false));
            }
            if (t.getLowerBound() != null) {
                key.addAll(this.createKey(t.getLowerBound(), false));
            }
        } else if (type.getKind() == TypeKind.WILDCARD) {
            WildcardType t = (WildcardType)type;
            if (t.getExtendsBound() != null) {
                key.addAll(this.createKey(t.getExtendsBound(), false));
            }
            if (t.getSuperBound() != null) {
                key.addAll(this.createKey(t.getSuperBound(), false));
            }
        } else if (type.getKind() == TypeKind.DECLARED) {
            DeclaredType t = (DeclaredType)type;
            for (TypeMirror typeMirror : t.getTypeArguments()) {
                if (deep) {
                    key.addAll(this.createKey(typeMirror, false));
                    continue;
                }
                key.add(((Object)typeMirror).toString());
            }
        }
        return key;
    }

    private Set<Type> getSupertypes(TypeMirror type, Type value) {
        Set<Type> superTypes = Collections.emptySet();
        if ((type = this.normalize(type)).getKind() == TypeKind.DECLARED) {
            DeclaredType declaredType = (DeclaredType)type;
            TypeElement e = (TypeElement)declaredType.asElement();
            if (e.getKind() == ElementKind.CLASS) {
                TypeMirror supertype;
                Type type2;
                if (e.getSuperclass().getKind() != TypeKind.NONE && !(type2 = this.create(supertype = this.normalize(e.getSuperclass()))).getFullName().startsWith("java")) {
                    superTypes = Collections.singleton(this.create(supertype));
                }
            } else {
                superTypes = new HashSet(e.getInterfaces().size());
                for (TypeMirror typeMirror : e.getInterfaces()) {
                    Type iface = this.create(typeMirror);
                    if (iface.getFullName().startsWith("java")) continue;
                    superTypes.add(iface);
                }
            }
        } else {
            throw new IllegalArgumentException("Unsupported type kind " + (Object)((Object)type.getKind()));
        }
        return superTypes;
    }

    private TypeMirror normalize(TypeMirror type) {
        WildcardType wildcard;
        if (type.getKind() == TypeKind.TYPEVAR) {
            TypeVariable typeVar = (TypeVariable)type;
            if (typeVar.getUpperBound() != null) {
                return typeVar.getUpperBound();
            }
        } else if (type.getKind() == TypeKind.WILDCARD && (wildcard = (WildcardType)type).getExtendsBound() != null) {
            return wildcard.getExtendsBound();
        }
        return type;
    }

    @Nullable
    private Type handle(TypeMirror type) {
        if (type instanceof DeclaredType) {
            DeclaredType t = (DeclaredType)type;
            if (t.asElement() instanceof TypeElement) {
                TypeElement typeElement = (TypeElement)t.asElement();
                switch (typeElement.getKind()) {
                    case ENUM: {
                        return this.createEnumType(t, typeElement);
                    }
                    case CLASS: {
                        return this.createClassType(t, typeElement);
                    }
                    case INTERFACE: {
                        return this.createInterfaceType(t, typeElement);
                    }
                }
                throw new IllegalArgumentException("Illegal type " + typeElement);
            }
            throw new IllegalArgumentException("Unsupported element type " + t.asElement());
        }
        if (type instanceof TypeVariable) {
            TypeVariable t = (TypeVariable)type;
            String varName = t.toString();
            if (t.getUpperBound() != null) {
                return new TypeExtends(varName, this.handle(t.getUpperBound()));
            }
            if (t.getLowerBound() != null && !(t.getLowerBound() instanceof NullType)) {
                return new TypeSuper(varName, this.handle(t.getLowerBound()));
            }
            return null;
        }
        if (type instanceof WildcardType) {
            WildcardType t = (WildcardType)type;
            if (t.getExtendsBound() != null) {
                return new TypeExtends(this.handle(t.getExtendsBound()));
            }
            if (t.getSuperBound() != null) {
                return new TypeSuper(this.handle(t.getSuperBound()));
            }
            return null;
        }
        if (type instanceof ArrayType) {
            ArrayType t = (ArrayType)type;
            return this.create(t.getComponentType()).asArrayType();
        }
        if (type instanceof PrimitiveType) {
            PrimitiveType t = (PrimitiveType)type;
            switch (t.getKind()) {
                case BOOLEAN: {
                    return Types.BOOLEAN;
                }
                case BYTE: {
                    return Types.BYTE;
                }
                case CHAR: {
                    return Types.CHAR;
                }
                case DOUBLE: {
                    return Types.DOUBLE;
                }
                case FLOAT: {
                    return Types.FLOAT;
                }
                case INT: {
                    return Types.INT;
                }
                case LONG: {
                    return Types.LONG;
                }
                case SHORT: {
                    return Types.SHORT;
                }
            }
            throw new IllegalArgumentException("Unsupported type " + (Object)((Object)t.getKind()));
        }
        if (type instanceof NoType) {
            return this.defaultValue;
        }
        return null;
    }

    private boolean isAssignable(TypeElement type1, TypeElement type2) {
        TypeMirror t1 = type1.asType();
        TypeMirror t2 = this.env.getTypeUtils().erasure(type2.asType());
        return this.env.getTypeUtils().isAssignable(t1, t2);
    }

    private boolean isSubType(TypeElement type1, TypeElement type2) {
        return this.env.getTypeUtils().isSubtype(type1.asType(), type2.asType());
    }
}

