/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.apt;

import com.mysema.query.apt.APTModelFactory;
import com.mysema.query.apt.Configuration;
import com.mysema.query.codegen.ClassModel;
import com.mysema.query.codegen.ConstructorModel;
import com.mysema.query.codegen.ParameterModel;
import com.mysema.query.codegen.TypeModel;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.SimpleElementVisitor6;
import net.jcip.annotations.Immutable;

@Immutable
public final class DTOElementVisitor
extends SimpleElementVisitor6<ClassModel, Void> {
    private final ProcessingEnvironment env;
    private final String namePrefix;
    private final APTModelFactory typeFactory;
    private final Configuration configuration;

    DTOElementVisitor(ProcessingEnvironment env, Configuration configuration, String namePrefix, APTModelFactory typeFactory) {
        this.env = env;
        this.configuration = configuration;
        this.namePrefix = namePrefix;
        this.typeFactory = typeFactory;
    }

    @Override
    public ClassModel visitType(TypeElement e, Void p) {
        Elements elementUtils = this.env.getElementUtils();
        TypeModel c = this.typeFactory.create(e.asType(), elementUtils);
        ClassModel classModel = new ClassModel(this.namePrefix, null, c.getPackageName(), c.getName(), c.getSimpleName());
        List<? extends Element> elements = e.getEnclosedElements();
        for (ExecutableElement constructor : ElementFilter.constructorsIn(elements)) {
            if (!this.configuration.isValidConstructor(constructor)) continue;
            ArrayList<ParameterModel> parameters = new ArrayList<ParameterModel>(constructor.getParameters().size());
            for (VariableElement variableElement : constructor.getParameters()) {
                TypeModel varType = this.typeFactory.create(variableElement.asType(), elementUtils);
                parameters.add(new ParameterModel(variableElement.getSimpleName().toString(), varType.getName()));
            }
            classModel.addConstructor(new ConstructorModel(parameters));
        }
        return classModel;
    }
}

