/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.apt;

import com.mysema.commons.lang.Assert;
import com.mysema.query.apt.VisitorConfig;
import java.lang.annotation.Annotation;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;

public class Configuration {
    protected final Class<? extends Annotation> entityAnn;
    protected final Class<? extends Annotation> superTypeAnn;
    protected final Class<? extends Annotation> embeddableAnn;
    protected final Class<? extends Annotation> dtoAnn;
    protected final Class<? extends Annotation> skipAnn;
    private boolean useFields = true;
    private boolean useGetters = true;

    public Configuration(Class<? extends Annotation> entityAnn, Class<? extends Annotation> superTypeAnn, Class<? extends Annotation> embeddableAnn, Class<? extends Annotation> dtoAnn, Class<? extends Annotation> skipAnn) {
        this.entityAnn = (Class)Assert.notNull(entityAnn);
        this.superTypeAnn = superTypeAnn;
        this.embeddableAnn = embeddableAnn;
        this.dtoAnn = dtoAnn;
        this.skipAnn = skipAnn;
    }

    public VisitorConfig getConfig(TypeElement e, List<? extends Element> elements) {
        return VisitorConfig.ALL;
    }

    public boolean isValidConstructor(ExecutableElement constructor) {
        return constructor.getModifiers().contains((Object)Modifier.PUBLIC);
    }

    public boolean isValidField(VariableElement field) {
        return this.useFields && field.getAnnotation(this.skipAnn) == null && !field.getModifiers().contains((Object)Modifier.TRANSIENT) && !field.getModifiers().contains((Object)Modifier.STATIC);
    }

    public boolean isValidGetter(ExecutableElement getter) {
        return this.useGetters && getter.getAnnotation(this.skipAnn) == null && !getter.getModifiers().contains((Object)Modifier.STATIC);
    }

    public Class<? extends Annotation> getEntityAnn() {
        return this.entityAnn;
    }

    public Class<? extends Annotation> getSuperTypeAnn() {
        return this.superTypeAnn;
    }

    public Class<? extends Annotation> getEmbeddableAnn() {
        return this.embeddableAnn;
    }

    public Class<? extends Annotation> getDtoAnn() {
        return this.dtoAnn;
    }

    public Class<? extends Annotation> getSkipAnn() {
        return this.skipAnn;
    }

    public boolean isUseFields() {
        return this.useFields;
    }

    public boolean isUseGetters() {
        return this.useGetters;
    }

    public void setUseGetters(boolean b) {
        this.useGetters = b;
    }

    public void setUseFields(boolean b) {
        this.useFields = b;
    }
}

