/*
 * Decompiled with CFR 0.152.
 */
package com.meg7.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.util.AttributeSet;
import com.meg7.widget.BaseImageView;
import com.meg7.widget.CircleImageView;
import com.meg7.widget.R;
import com.meg7.widget.RectangleImageView;
import com.meg7.widget.SvgImageView;

public class CustomShapeImageView
extends BaseImageView {
    private int mShape = 1;
    private int mSvgRawResourceId;

    public CustomShapeImageView(Context context) {
        super(context);
    }

    public CustomShapeImageView(Context context, int resourceId, int shape, int svgRawResourceId) {
        this(context);
        this.setImageResource(resourceId);
        this.mShape = shape;
        this.mSvgRawResourceId = svgRawResourceId;
    }

    public CustomShapeImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.sharedConstructor(context, attrs);
    }

    public CustomShapeImageView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.sharedConstructor(context, attrs);
    }

    private void sharedConstructor(Context context, AttributeSet attrs) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.CustomShapeImageView);
        this.mShape = a.getInt(R.styleable.CustomShapeImageView_shape, 1);
        this.mSvgRawResourceId = a.getResourceId(R.styleable.CustomShapeImageView_svg_raw_resource, 0);
        a.recycle();
    }

    @Override
    public Bitmap getBitmap() {
        switch (this.mShape) {
            case 1: {
                return CircleImageView.getBitmap(this.getWidth(), this.getHeight());
            }
            case 2: {
                return RectangleImageView.getBitmap(this.getWidth(), this.getHeight());
            }
            case 3: {
                return SvgImageView.getBitmap(this.mContext, this.getWidth(), this.getHeight(), this.mSvgRawResourceId);
            }
        }
        return null;
    }

    public static class Shape {
        public static final int CIRCLE = 1;
        public static final int RECTANGLE = 2;
        public static final int SVG = 3;
    }
}

