/*
 * Decompiled with CFR 0.152.
 */
package com.meg7.widget;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Xfermode;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.util.Log;
import android.widget.ImageView;
import java.lang.ref.WeakReference;

public abstract class BaseImageView
extends ImageView {
    private static final String TAG = BaseImageView.class.getSimpleName();
    protected Context mContext;
    private static final Xfermode sXfermode = new PorterDuffXfermode(PorterDuff.Mode.DST_IN);
    private Bitmap mMaskBitmap;
    private Paint mPaint;
    private WeakReference<Bitmap> mWeakBitmap;

    public BaseImageView(Context context) {
        super(context);
        this.sharedConstructor(context);
    }

    public BaseImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.sharedConstructor(context);
    }

    public BaseImageView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.sharedConstructor(context);
    }

    private void sharedConstructor(Context context) {
        this.mContext = context;
        this.mPaint = new Paint(1);
    }

    public void invalidate() {
        this.mWeakBitmap = null;
        if (this.mMaskBitmap != null) {
            this.mMaskBitmap.recycle();
        }
        super.invalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @SuppressLint(value={"DrawAllocation"})
    protected void onDraw(Canvas canvas) {
        if (!this.isInEditMode()) {
            int i = canvas.saveLayer(0.0f, 0.0f, (float)this.getWidth(), (float)this.getHeight(), null, 31);
            try {
                Drawable drawable;
                Bitmap bitmap;
                Bitmap bitmap2 = bitmap = this.mWeakBitmap != null ? (Bitmap)this.mWeakBitmap.get() : null;
                if ((bitmap == null || bitmap.isRecycled()) && (drawable = this.getDrawable()) != null) {
                    bitmap = Bitmap.createBitmap((int)this.getWidth(), (int)this.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
                    Canvas bitmapCanvas = new Canvas(bitmap);
                    drawable.setBounds(0, 0, this.getWidth(), this.getHeight());
                    drawable.draw(bitmapCanvas);
                    if (this.mMaskBitmap == null || this.mMaskBitmap.isRecycled()) {
                        this.mMaskBitmap = this.getBitmap();
                    }
                    this.mPaint.reset();
                    this.mPaint.setFilterBitmap(false);
                    this.mPaint.setXfermode(sXfermode);
                    bitmapCanvas.drawBitmap(this.mMaskBitmap, 0.0f, 0.0f, this.mPaint);
                    this.mWeakBitmap = new WeakReference<Bitmap>(bitmap);
                }
                if (bitmap == null) return;
                this.mPaint.setXfermode(null);
                canvas.drawBitmap(bitmap, 0.0f, 0.0f, this.mPaint);
                return;
            }
            catch (Exception e) {
                System.gc();
                Log.e((String)TAG, (String)String.format("Failed to draw, Id :: %s. Error occurred :: %s", this.getId(), e.toString()));
                return;
            }
            finally {
                canvas.restoreToCount(i);
            }
        } else {
            super.onDraw(canvas);
        }
    }

    public abstract Bitmap getBitmap();
}

