/*
 * Decompiled with CFR 0.152.
 */
package com.monitorjbl.json;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonBackReference;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonManagedReference;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.monitorjbl.json.JsonView;
import com.monitorjbl.json.Match;
import com.monitorjbl.json.MatcherBehavior;
import com.monitorjbl.json.Memoizer;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.net.URI;
import java.net.URL;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class JsonViewSerializer
extends JsonSerializer<JsonView> {
    public static boolean log = false;
    private final Memoizer memoizer;
    private Map<Class<?>, JsonSerializer<Object>> customSerializersMap = null;
    private MatcherBehavior defaultMatcherBehavior = MatcherBehavior.CLASS_FIRST;

    public JsonViewSerializer() {
        this(1024);
    }

    public JsonViewSerializer(int maxCacheSize) {
        this.memoizer = new Memoizer(maxCacheSize);
    }

    public <T> void registerCustomSerializer(Class<T> cls, JsonSerializer<T> forType) {
        if (this.customSerializersMap == null) {
            this.customSerializersMap = new HashMap();
        }
        if (cls == null) {
            throw new IllegalArgumentException("Class must not be null");
        }
        if (cls.equals(JsonView.class)) {
            throw new IllegalArgumentException("Class cannot be " + JsonView.class);
        }
        if (this.customSerializersMap.containsKey(cls)) {
            throw new IllegalArgumentException("Class " + cls + " already has a serializer registered (" + this.customSerializersMap.get(cls) + ")");
        }
        this.customSerializersMap.put(cls, forType);
    }

    public void unregisterCustomSerializer(Class<?> cls) {
        if (this.customSerializersMap != null) {
            this.customSerializersMap.remove(cls);
        }
    }

    public void setDefaultMatcherBehavior(MatcherBehavior defaultMatcherBehavior) {
        this.defaultMatcherBehavior = defaultMatcherBehavior;
    }

    public void serialize(JsonView result, JsonGenerator jgen, SerializerProvider serializers) throws IOException {
        new JsonWriter(serializers, jgen, result).write(null, result.getValue());
    }

    static class AccessibleProperty {
        public final Class declaringClass;
        public final String name;
        public final Class type;
        public final Annotation[] annotations;
        public final int modifiers;
        public final Object property;
        private final Function<Object, Object> getter;

        public AccessibleProperty(String name, Annotation[] annotations, Object property) {
            this.name = name;
            this.annotations = annotations;
            this.property = property;
            if (property instanceof Field) {
                this.declaringClass = ((Field)property).getDeclaringClass();
                this.type = ((Field)property).getType();
                this.modifiers = ((Field)property).getModifiers();
                this.getter = this::getFromField;
            } else if (property instanceof Method) {
                this.declaringClass = ((Method)property).getDeclaringClass();
                this.type = ((Method)property).getReturnType();
                this.modifiers = ((Method)property).getModifiers();
                this.getter = this::getFromMethod;
            } else {
                throw new RuntimeException("Unable to access property from " + property);
            }
        }

        public Object get(Object obj) {
            return this.getter.apply(obj);
        }

        private Object getFromField(Object obj) {
            try {
                ((Field)this.property).setAccessible(true);
                return ((Field)this.property).get(obj);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }

        private Object getFromMethod(Object obj) {
            try {
                ((Method)this.property).setAccessible(true);
                return ((Method)this.property).invoke(obj, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AccessibleProperty that = (AccessibleProperty)o;
            return Objects.equals(this.declaringClass, that.declaringClass) && Objects.equals(this.name, that.name);
        }

        public int hashCode() {
            return Objects.hash(this.declaringClass, this.name);
        }
    }

    private static class MatchPrefixTuple {
        private final Match match;
        private final String prefix;

        public MatchPrefixTuple(Match match, String prefix) {
            this.match = match;
            this.prefix = prefix;
        }
    }

    class JsonWriter {
        Stack<String> path = new Stack();
        String currentPath = "";
        Match currentMatch = null;
        AccessibleProperty referringField = null;
        final SerializerProvider serializerProvider;
        final JsonGenerator jgen;
        final JsonView result;

        JsonWriter(SerializerProvider serializerProvider, JsonGenerator jgen, JsonView result) {
            this.serializerProvider = serializerProvider;
            this.jgen = jgen;
            this.result = result;
        }

        private JsonWriter(JsonGenerator jgen, JsonView result, Match currentMatch, SerializerProvider serializerProvider) {
            this.jgen = jgen;
            this.result = result;
            this.currentMatch = currentMatch;
            this.serializerProvider = serializerProvider;
        }

        private JsonWriter(JsonGenerator jgen, JsonView result, Match currentMatch, String currentPath, Stack<String> path, AccessibleProperty referringField, SerializerProvider serializerProvider) {
            this.jgen = jgen;
            this.result = result;
            this.currentMatch = currentMatch;
            this.currentPath = currentPath;
            this.referringField = referringField;
            this.path = path;
            this.serializerProvider = serializerProvider;
        }

        boolean writePrimitive(Object obj) throws IOException {
            if (obj instanceof String) {
                this.jgen.writeString((String)obj);
            } else if (obj instanceof Integer) {
                this.jgen.writeNumber(((Integer)obj).intValue());
            } else if (obj instanceof Long) {
                this.jgen.writeNumber(((Long)obj).longValue());
            } else if (obj instanceof Short) {
                this.jgen.writeNumber(((Short)obj).shortValue());
            } else if (obj instanceof Double) {
                this.jgen.writeNumber(((Double)obj).doubleValue());
            } else if (obj instanceof Float) {
                this.jgen.writeNumber(((Float)obj).floatValue());
            } else if (obj instanceof Character) {
                this.jgen.writeNumber((int)((Character)obj).charValue());
            } else if (obj instanceof Byte) {
                this.jgen.writeNumber((short)((Byte)obj).byteValue());
            } else if (obj instanceof Boolean) {
                this.jgen.writeBoolean(((Boolean)obj).booleanValue());
            } else if (obj == null) {
                this.jgen.writeNull();
            } else if (obj instanceof BigDecimal) {
                this.jgen.writeNumber((BigDecimal)obj);
            } else {
                return false;
            }
            return true;
        }

        boolean writeSpecial(Object obj) throws IOException {
            if (obj instanceof Date) {
                this.serializerProvider.defaultSerializeDateValue((Date)obj, this.jgen);
            } else if (obj instanceof Temporal) {
                this.serializerProvider.defaultSerializeValue(obj, this.jgen);
            } else if (obj instanceof URL) {
                this.jgen.writeString(obj.toString());
            } else if (obj instanceof URI) {
                this.jgen.writeString(obj.toString());
            } else if (obj instanceof UUID) {
                this.jgen.writeString(obj.toString());
            } else if (obj instanceof Class) {
                this.jgen.writeString(((Class)obj).getCanonicalName());
            } else {
                return false;
            }
            return true;
        }

        boolean writeEnum(Object obj) throws IOException {
            if (!obj.getClass().isEnum()) {
                return false;
            }
            this.jgen.writeString(((Enum)obj).name());
            return true;
        }

        boolean writeList(Object obj) throws IOException {
            if (obj instanceof List || obj instanceof Set || obj.getClass().isArray()) {
                Iterable iter;
                if (obj.getClass().isArray()) {
                    if (obj instanceof byte[]) {
                        this.jgen.writeBinary((byte[])obj);
                        return true;
                    }
                    iter = this.convertArray(obj);
                } else {
                    iter = (Iterable)obj;
                }
                this.jgen.writeStartArray();
                for (Object o : iter) {
                    new JsonWriter(this.jgen, this.result, this.currentMatch, this.currentPath, this.path, this.referringField, this.serializerProvider).write(null, o);
                }
            } else {
                return false;
            }
            this.jgen.writeEndArray();
            return true;
        }

        Iterable convertArray(Object obj) {
            List<Object> iter;
            if (obj instanceof int[]) {
                int[] arr = (int[])obj;
                iter = new ArrayList();
                for (int v : arr) {
                    ((List)iter).add(v);
                }
            } else if (obj instanceof double[]) {
                double[] arr = (double[])obj;
                iter = new ArrayList();
                for (double v : arr) {
                    ((List)iter).add(v);
                }
            } else if (obj instanceof float[]) {
                float[] arr = (float[])obj;
                iter = new ArrayList();
                for (float v : arr) {
                    ((List)iter).add(Float.valueOf(v));
                }
            } else if (obj instanceof long[]) {
                long[] arr = (long[])obj;
                iter = new ArrayList();
                for (long v : arr) {
                    ((List)iter).add(v);
                }
            } else if (obj instanceof short[]) {
                short[] arr = (short[])obj;
                iter = new ArrayList();
                for (short v : arr) {
                    ((List)iter).add(v);
                }
            } else if (obj instanceof char[]) {
                char[] arr = (char[])obj;
                iter = new ArrayList();
                for (char v : arr) {
                    ((List)iter).add(Character.valueOf(v));
                }
            } else if (obj instanceof boolean[]) {
                boolean[] arr = (boolean[])obj;
                iter = new ArrayList();
                for (boolean v : arr) {
                    ((List)iter).add(v);
                }
            } else {
                iter = Arrays.asList((Object[])obj);
            }
            return iter;
        }

        boolean writeMap(Object obj) throws IOException {
            if (obj instanceof Map) {
                Map map = (Map)obj;
                this.jgen.writeStartObject();
                for (Object key : map.keySet()) {
                    this.jgen.writeFieldName(key.toString());
                    new JsonWriter(this.jgen, this.result, this.currentMatch, this.serializerProvider).write(null, map.get(key));
                }
            } else {
                return false;
            }
            this.jgen.writeEndObject();
            return true;
        }

        void writeObject(Object obj) throws IOException {
            this.jgen.writeStartObject();
            List<AccessibleProperty> fields = this.getAccessibleProperties(obj.getClass());
            for (AccessibleProperty property : fields) {
                try {
                    Object val;
                    if (!this.fieldAllowed(property, obj.getClass()) || !this.valueAllowed(property, val = this.readField(obj, property), obj.getClass())) continue;
                    String name = this.getFieldName(property);
                    this.jgen.writeFieldName(name);
                    JsonSerializer fieldSerializer = this.annotatedWithJsonSerialize(property);
                    if (fieldSerializer != null) {
                        fieldSerializer.serialize(val, this.jgen, this.serializerProvider);
                        continue;
                    }
                    if (JsonViewSerializer.this.customSerializersMap != null && val != null) {
                        JsonSerializer serializer = (JsonSerializer)JsonViewSerializer.this.customSerializersMap.get(val.getClass());
                        if (serializer != null) {
                            serializer.serialize(val, this.jgen, this.serializerProvider);
                            continue;
                        }
                        new JsonWriter(this.jgen, this.result, this.currentMatch, this.currentPath, this.path, property, this.serializerProvider).write(name, val);
                        continue;
                    }
                    if (val instanceof JsonNode) {
                        this.serializerProvider.defaultSerializeValue(val, this.jgen);
                        continue;
                    }
                    new JsonWriter(this.jgen, this.result, this.currentMatch, this.currentPath, this.path, property, this.serializerProvider).write(name, val);
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    throw new RuntimeException(e);
                }
            }
            this.jgen.writeEndObject();
        }

        boolean valueAllowed(AccessibleProperty property, Object value, Class cls) {
            JsonInclude.Include defaultInclude = this.serializerProvider.getConfig() == null ? JsonInclude.Include.ALWAYS : this.serializerProvider.getConfig().getSerializationInclusion();
            JsonInclude jsonInclude = this.getAnnotation(property, JsonInclude.class);
            JsonSerialize jsonSerialize = this.getAnnotation(cls, JsonSerialize.class);
            if (jsonInclude != null && jsonInclude.value() == JsonInclude.Include.NON_NULL && value == null) {
                return false;
            }
            return value != null || defaultInclude == JsonInclude.Include.ALWAYS && jsonSerialize == null || jsonSerialize != null && jsonSerialize.include() == JsonSerialize.Inclusion.ALWAYS;
        }

        private Optional<Match> classMatchSearch(Class declaringClass) {
            ArrayList<Match> matches = new ArrayList<Match>();
            Stack classes = new Stack();
            classes.push(declaringClass);
            while (!classes.isEmpty()) {
                Class cls = (Class)classes.pop();
                Match match = this.result.getMatch(cls);
                if (match != null) {
                    matches.add(match);
                }
                if (cls.getInterfaces() != null) {
                    Stream.of(cls.getInterfaces()).forEach(c -> classes.push(c));
                }
                if (cls.getSuperclass() == null || cls.getSuperclass().equals(Object.class)) continue;
                classes.push(cls.getSuperclass());
            }
            if (matches.size() == 1) {
                return Optional.of(matches.get(0));
            }
            if (matches.size() > 1) {
                Match unionMatch = new Match();
                matches.forEach(m -> {
                    unionMatch.getExcludes().addAll(m.getExcludes());
                    unionMatch.getIncludes().addAll(m.getIncludes());
                    unionMatch.getTransforms().putAll(m.getTransforms());
                });
                return Optional.of(unionMatch);
            }
            return Optional.empty();
        }

        boolean fieldAllowed(AccessibleProperty property, Class declaringClass) {
            String name = property.name;
            if (Modifier.isStatic(property.modifiers)) {
                return false;
            }
            MatchPrefixTuple tuple = this.getMatchPrefix(declaringClass);
            String prefix = tuple.prefix;
            Match match = tuple.match;
            if (match != null) {
                if (this.currentMatch == null) {
                    this.currentMatch = match;
                }
                int included = this.containsMatchingPattern(match.getIncludes(), prefix + name, true);
                int excluded = this.containsMatchingPattern(match.getExcludes(), prefix + name, false);
                if (included == 1) {
                    return true;
                }
                if (excluded == 1) {
                    return false;
                }
                if (included == 0) {
                    return true;
                }
                if (excluded == 0) {
                    return false;
                }
                return !this.annotatedWithIgnore(property);
            }
            return !this.annotatedWithIgnore(property);
        }

        MatchPrefixTuple getMatchPrefix(Class declaringClass) {
            String prefix = this.currentPath.length() > 0 ? this.currentPath + "." : "";
            MatcherBehavior currentBehavior = this.result.matcherBehavior;
            if (currentBehavior == null) {
                currentBehavior = JsonViewSerializer.this.defaultMatcherBehavior;
            }
            Match match = null;
            if (currentBehavior == MatcherBehavior.CLASS_FIRST) {
                match = this.classMatchSearch(declaringClass).orElse(null);
                if (match == null) {
                    match = this.currentMatch;
                } else {
                    prefix = "";
                }
            } else if (currentBehavior == MatcherBehavior.PATH_FIRST) {
                if (this.currentMatch != null) {
                    match = this.currentMatch;
                } else {
                    match = this.classMatchSearch(declaringClass).orElse(null);
                    prefix = "";
                }
            }
            return new MatchPrefixTuple(match, prefix);
        }

        Object readField(Object obj, AccessibleProperty field) throws IllegalAccessException {
            MatchPrefixTuple tuple = this.getMatchPrefix(obj.getClass());
            if (tuple.match != null && tuple.match.getTransforms().containsKey(tuple.prefix + field.name)) {
                return tuple.match.getTransforms().get(tuple.prefix + field.name).apply(obj, field.get(obj));
            }
            return field.get(obj);
        }

        void write(String fieldName, Object value) throws IOException {
            if (fieldName != null) {
                this.path.push(fieldName);
                this.updateCurrentPath();
            }
            if (!(this.writePrimitive(value) || this.writeSpecial(value) || this.writeEnum(value) || this.writeList(value) || this.writeMap(value))) {
                this.writeObject(value);
            }
            if (fieldName != null) {
                this.path.pop();
                this.updateCurrentPath();
            }
        }

        void updateCurrentPath() {
            StringBuilder builder = new StringBuilder();
            for (String s : this.path) {
                builder.append(".");
                builder.append(s);
            }
            this.currentPath = builder.length() > 0 ? builder.toString().substring(1) : "";
        }

        <E> E readClassAnnotation(Class cls, Class annotationType, String methodName) {
            try {
                for (Annotation an : this.getAnnotations(cls)) {
                    Class<? extends Annotation> type = an.annotationType();
                    if (!an.annotationType().equals(annotationType)) continue;
                    for (Method method : type.getDeclaredMethods()) {
                        if (!method.getName().equals(methodName)) continue;
                        return (E)method.invoke((Object)an, (Object[])null);
                    }
                    throw new IllegalArgumentException("Method " + methodName + " not found on annotation " + annotationType);
                }
                throw new IllegalArgumentException("Annotation " + annotationType + " not found on class " + cls);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }

        int containsMatchingPattern(Set<String> values, String pattern, boolean matchPrefix) {
            return JsonViewSerializer.this.memoizer.matches(values, pattern, matchPrefix, () -> {
                int match = -1;
                for (String val : values) {
                    String replaced = val.replaceAll("\\.", "\\\\.").replaceAll("\\*", ".*");
                    if (!Pattern.compile(replaced).matcher(pattern).matches() && (!matchPrefix || !val.startsWith(pattern + "."))) continue;
                    match = replaced.contains("*") ? 0 : 1;
                    break;
                }
                return match;
            });
        }

        boolean annotatedWithIgnore(AccessibleProperty f) {
            return JsonViewSerializer.this.memoizer.annotatedWithIgnore(f, () -> {
                JsonIgnore jsonIgnore = this.getAnnotation(f, JsonIgnore.class);
                JsonIgnoreProperties classIgnoreProperties = this.getAnnotation(f.declaringClass, JsonIgnoreProperties.class);
                JsonIgnoreProperties fieldIgnoreProperties = null;
                boolean backReferenced = false;
                if (this.referringField != null) {
                    fieldIgnoreProperties = this.getAnnotation(this.referringField, JsonIgnoreProperties.class);
                }
                if (this.getAnnotation(f, JsonBackReference.class) != null && this.referringField != null) {
                    for (AccessibleProperty lastField : this.getAccessibleProperties(this.referringField.declaringClass)) {
                        JsonManagedReference fieldManagedReference = this.getAnnotation(lastField, JsonManagedReference.class);
                        if (fieldManagedReference == null || !lastField.type.equals(f.declaringClass)) continue;
                        backReferenced = true;
                        break;
                    }
                }
                return jsonIgnore != null && jsonIgnore.value() || classIgnoreProperties != null && Arrays.asList(classIgnoreProperties.value()).contains(f.name) || fieldIgnoreProperties != null && Arrays.asList(fieldIgnoreProperties.value()).contains(f.name) || backReferenced;
            });
        }

        JsonSerializer annotatedWithJsonSerialize(AccessibleProperty property) {
            JsonSerialize jsonSerialize = this.getAnnotation(property, JsonSerialize.class);
            if (jsonSerialize != null && !jsonSerialize.using().equals(JsonSerializer.None.class)) {
                try {
                    return (JsonSerializer)jsonSerialize.using().newInstance();
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw new RuntimeException(e);
                }
            }
            return null;
        }

        private Class<?>[] getInterfaces(Class cls) {
            return cls.getInterfaces();
        }

        private List<AccessibleProperty> getAccessibleProperties(Class cls) {
            return JsonViewSerializer.this.memoizer.accessibleProperty(cls, () -> {
                LinkedHashMap accessibleProperties = new LinkedHashMap();
                Predicate<Field> shouldProcessField = this.fieldVisibilityAllowed(cls);
                Predicate<Method> shouldProcessMethod = this.getterVisibilityAllowed(cls);
                Predicate<Object> visible = o -> {
                    if (o instanceof Field) {
                        return shouldProcessField.test((Field)o);
                    }
                    if (o instanceof Method) {
                        return shouldProcessMethod.test((Method)o);
                    }
                    throw new RuntimeException("Could not process property of type " + o.getClass());
                };
                this.getDeclaredFields(cls).stream().map(f -> new AccessibleProperty(f.getName(), f.getAnnotations(), f)).forEach(p -> accessibleProperties.put(p.name, p));
                this.getDeclaredMethods(cls).stream().filter(m -> m.getName().startsWith("get") && !m.getReturnType().equals(Void.class) && m.getParameters().length == 0).map(m -> new AccessibleProperty(this.getFieldNameFromGetter((Method)m), m.getAnnotations(), m)).forEach(p -> {
                    AccessibleProperty field = (AccessibleProperty)accessibleProperties.get(p.name);
                    if (field != null) {
                        HashSet<Annotation> annotations = new HashSet<Annotation>(Arrays.asList(field.annotations));
                        annotations.addAll(Arrays.asList(p.annotations));
                        p = new AccessibleProperty(p.name, annotations.toArray(new Annotation[0]), p.property);
                    }
                    if (shouldProcessMethod.test((Method)p.property)) {
                        accessibleProperties.put(p.name, p);
                    }
                });
                return accessibleProperties.values().stream().filter(p -> visible.test(p.property)).collect(Collectors.toList());
            });
        }

        private List<Field> getDeclaredFields(Class cls) {
            ArrayList<Field> fields = new ArrayList<Field>();
            Stack parents = new Stack();
            parents.push(cls);
            while (!parents.isEmpty()) {
                Class c = (Class)parents.pop();
                Stream.of(c.getDeclaredFields()).forEach(f -> fields.add((Field)f));
                if (c.getSuperclass() == null || c.getSuperclass().equals(Object.class)) continue;
                parents.push(c.getSuperclass());
            }
            return fields;
        }

        private List<Method> getDeclaredMethods(Class cls) {
            ArrayList<Method> methods = new ArrayList<Method>();
            Stack parents = new Stack();
            parents.push(cls);
            while (!parents.isEmpty()) {
                Class c = (Class)parents.pop();
                Stream.of(c.getDeclaredMethods()).forEach(m -> methods.add((Method)m));
                if (c.getSuperclass() != null && !c.getSuperclass().equals(Object.class)) {
                    parents.push(c.getSuperclass());
                }
                if (c.getInterfaces() == null) continue;
                Stream.of(c.getInterfaces()).forEach(i -> parents.push(i));
            }
            return methods;
        }

        private Annotation[] getAnnotations(Class cls) {
            return JsonViewSerializer.this.memoizer.annotations(cls, () -> cls.getAnnotations());
        }

        private <T extends Annotation> T getAnnotation(Class cls, Class<T> annotation) {
            Annotation[] annotations = this.getAnnotations(cls);
            if (annotations != null) {
                for (Annotation a : annotations) {
                    if (!a.annotationType().equals(annotation)) continue;
                    return (T)a;
                }
            }
            return null;
        }

        private <T extends Annotation> T getAnnotation(AccessibleProperty property, Class<T> annotation) {
            if (property.annotations != null) {
                for (Annotation a : property.annotations) {
                    if (!a.annotationType().equals(annotation)) continue;
                    return (T)a;
                }
            }
            return null;
        }

        private Predicate<Field> fieldVisibilityAllowed(Class cls) {
            JsonAutoDetect autoDetect = this.getAnnotation(cls, JsonAutoDetect.class);
            if (autoDetect == null) {
                return f -> false;
            }
            switch (autoDetect.fieldVisibility()) {
                case ANY: {
                    return f -> true;
                }
                case PUBLIC_ONLY: {
                    return f -> Modifier.isPublic(f.getModifiers());
                }
                case PROTECTED_AND_PUBLIC: {
                    return f -> Modifier.isPublic(f.getModifiers()) || Modifier.isProtected(f.getModifiers());
                }
                case NON_PRIVATE: {
                    return f -> !Modifier.isPrivate(f.getModifiers());
                }
                case DEFAULT: 
                case NONE: {
                    return f -> false;
                }
            }
            throw new RuntimeException("No support for field visibility " + autoDetect.fieldVisibility());
        }

        private Predicate<Method> getterVisibilityAllowed(Class cls) {
            JsonAutoDetect autoDetect = this.getAnnotation(cls, JsonAutoDetect.class);
            if (autoDetect == null) {
                return m -> true;
            }
            switch (autoDetect.getterVisibility()) {
                case ANY: 
                case DEFAULT: {
                    return m -> true;
                }
                case PUBLIC_ONLY: {
                    return m -> Modifier.isPublic(m.getModifiers());
                }
                case PROTECTED_AND_PUBLIC: {
                    return m -> Modifier.isPublic(m.getModifiers()) || Modifier.isProtected(m.getModifiers());
                }
                case NON_PRIVATE: {
                    return m -> !Modifier.isPrivate(m.getModifiers());
                }
                case NONE: {
                    return m -> false;
                }
            }
            throw new RuntimeException("No support for field visibility " + autoDetect.fieldVisibility());
        }

        private String getFieldName(AccessibleProperty property) {
            JsonProperty jsonProperty = this.getAnnotation(property, JsonProperty.class);
            if (jsonProperty != null && jsonProperty.value().length() > 0) {
                return jsonProperty.value();
            }
            return property.name;
        }

        private String getFieldNameFromGetter(Method method) {
            String name = method.getName().replace("get", "");
            return name.substring(0, 1).toLowerCase() + name.substring(1);
        }
    }
}

