/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.jms;

import com.mockrunner.mock.jms.MockConnection;
import com.mockrunner.mock.jms.MockQueue;
import com.mockrunner.mock.jms.MockQueueBrowser;
import com.mockrunner.mock.jms.MockQueueReceiver;
import com.mockrunner.mock.jms.MockQueueSender;
import com.mockrunner.mock.jms.MockSession;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.jms.JMSException;
import javax.jms.QueueBrowser;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;

public class QueueTransmissionManager
implements Serializable {
    private MockConnection connection;
    private MockSession session;
    private List queueSenderList;
    private List queueReceiverList;
    private List queueBrowserList;

    public QueueTransmissionManager(MockConnection connection, MockSession session) {
        this.connection = connection;
        this.session = session;
        this.queueSenderList = new ArrayList();
        this.queueReceiverList = new ArrayList();
        this.queueBrowserList = new ArrayList();
    }

    public void closeAll() {
        this.closeAllQueueSenders();
        this.closeAllQueueReceivers();
        this.closeAllQueueBrowsers();
    }

    public void closeAllQueueSenders() {
        for (int ii = 0; ii < this.queueSenderList.size(); ++ii) {
            QueueSender sender = (QueueSender)this.queueSenderList.get(ii);
            try {
                sender.close();
                continue;
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
        }
    }

    public void closeAllQueueReceivers() {
        for (int ii = 0; ii < this.queueReceiverList.size(); ++ii) {
            QueueReceiver receiver = (QueueReceiver)this.queueReceiverList.get(ii);
            try {
                receiver.close();
                continue;
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
        }
    }

    public void closeAllQueueBrowsers() {
        for (int ii = 0; ii < this.queueBrowserList.size(); ++ii) {
            QueueBrowser browser = (QueueBrowser)this.queueBrowserList.get(ii);
            try {
                browser.close();
                continue;
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
        }
    }

    public MockQueueSender createQueueSender(MockQueue queue) {
        MockQueueSender sender = new MockQueueSender(this.connection, this.session, queue);
        this.queueSenderList.add(sender);
        return sender;
    }

    public MockQueueSender getQueueSender(int index) {
        if (this.queueSenderList.size() <= index || index < 0) {
            return null;
        }
        return (MockQueueSender)this.queueSenderList.get(index);
    }

    public MockQueueSender getQueueSender(String queueName) {
        List senders = this.getQueueSenderList(queueName);
        if (senders.size() <= 0) {
            return null;
        }
        return (MockQueueSender)senders.get(0);
    }

    public List getQueueSenderList(String queueName) {
        ArrayList<QueueSender> resultList = new ArrayList<QueueSender>();
        for (int ii = 0; ii < this.queueSenderList.size(); ++ii) {
            QueueSender sender = (QueueSender)this.queueSenderList.get(ii);
            try {
                if (!sender.getQueue().getQueueName().equals(queueName)) continue;
                resultList.add(sender);
                continue;
            }
            catch (JMSException exc) {
                // empty catch block
            }
        }
        return Collections.unmodifiableList(resultList);
    }

    public List getQueueSenderList() {
        return Collections.unmodifiableList(this.queueSenderList);
    }

    public MockQueueReceiver createQueueReceiver(MockQueue queue, String messageSelector) {
        MockQueueReceiver receiver = new MockQueueReceiver(this.connection, this.session, queue, messageSelector);
        this.queueReceiverList.add(receiver);
        return receiver;
    }

    public MockQueueReceiver getQueueReceiver(int index) {
        if (this.queueReceiverList.size() <= index || index < 0) {
            return null;
        }
        return (MockQueueReceiver)this.queueReceiverList.get(index);
    }

    public MockQueueReceiver getQueueReceiver(String queueName) {
        List receivers = this.getQueueReceiverList(queueName);
        if (receivers.size() <= 0) {
            return null;
        }
        return (MockQueueReceiver)receivers.get(0);
    }

    public List getQueueReceiverList(String queueName) {
        ArrayList<QueueReceiver> resultList = new ArrayList<QueueReceiver>();
        for (int ii = 0; ii < this.queueReceiverList.size(); ++ii) {
            QueueReceiver receiver = (QueueReceiver)this.queueReceiverList.get(ii);
            try {
                if (!receiver.getQueue().getQueueName().equals(queueName)) continue;
                resultList.add(receiver);
                continue;
            }
            catch (JMSException exc) {
                // empty catch block
            }
        }
        return Collections.unmodifiableList(resultList);
    }

    public List getQueueReceiverList() {
        return Collections.unmodifiableList(this.queueReceiverList);
    }

    public MockQueueBrowser createQueueBrowser(MockQueue queue, String messageSelector) {
        MockQueueBrowser browser = new MockQueueBrowser(this.connection, queue, messageSelector);
        this.queueBrowserList.add(browser);
        return browser;
    }

    public MockQueueBrowser getQueueBrowser(int index) {
        if (this.queueBrowserList.size() <= index || index < 0) {
            return null;
        }
        return (MockQueueBrowser)this.queueBrowserList.get(index);
    }

    public MockQueueBrowser getQueueBrowser(String queueName) {
        List browsers = this.getQueueBrowserList(queueName);
        if (browsers.size() <= 0) {
            return null;
        }
        return (MockQueueBrowser)browsers.get(0);
    }

    public List getQueueBrowserList(String queueName) {
        ArrayList<QueueBrowser> resultList = new ArrayList<QueueBrowser>();
        for (int ii = 0; ii < this.queueBrowserList.size(); ++ii) {
            QueueBrowser browser = (QueueBrowser)this.queueBrowserList.get(ii);
            try {
                if (!browser.getQueue().getQueueName().equals(queueName)) continue;
                resultList.add(browser);
                continue;
            }
            catch (JMSException exc) {
                // empty catch block
            }
        }
        return Collections.unmodifiableList(resultList);
    }

    public List getQueueBrowserList() {
        return Collections.unmodifiableList(this.queueBrowserList);
    }
}

