/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.mock.jms;

import com.mockrunner.mock.jms.MockConnection;
import com.mockrunner.mock.jms.MockQueue;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import org.activemq.filter.mockrunner.Filter;
import org.activemq.selector.mockrunner.SelectorParser;

public class MockQueueBrowser
implements QueueBrowser,
Serializable {
    private MockConnection connection;
    private MockQueue queue;
    private boolean closed;
    private String messageSelector;
    private Filter messageSelectorFilter;

    public MockQueueBrowser(MockConnection connection, MockQueue queue) {
        this(connection, queue, null);
    }

    public MockQueueBrowser(MockConnection connection, MockQueue queue, String messageSelector) {
        this.connection = connection;
        this.queue = queue;
        this.closed = false;
        this.messageSelector = messageSelector;
        this.parseMessageSelector();
    }

    private void parseMessageSelector() {
        if (null == this.messageSelector || this.messageSelector.length() == 0) {
            this.messageSelectorFilter = null;
        } else {
            try {
                this.messageSelectorFilter = new SelectorParser().parse(this.messageSelector);
            }
            catch (InvalidSelectorException exc) {
                throw new RuntimeException("Error parsing message selector: " + exc.getMessage());
            }
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public Queue getQueue() throws JMSException {
        this.connection.throwJMSException();
        return this.queue;
    }

    public String getMessageSelector() throws JMSException {
        this.connection.throwJMSException();
        return this.messageSelector;
    }

    public Enumeration getEnumeration() throws JMSException {
        this.connection.throwJMSException();
        if (this.isClosed()) {
            throw new JMSException("Browser is closed");
        }
        return new Vector(this.getFilteredMessageList()).elements();
    }

    public void close() throws JMSException {
        this.connection.throwJMSException();
        this.closed = true;
    }

    private List getFilteredMessageList() {
        List messages = this.queue.getCurrentMessageList();
        if (null == this.messageSelectorFilter) {
            return messages;
        }
        if (!this.connection.getConfigurationManager().getUseMessageSelectors()) {
            return messages;
        }
        ArrayList<Message> filteredMessages = new ArrayList<Message>();
        for (int ii = 0; ii < messages.size(); ++ii) {
            Message nextMessage = (Message)messages.get(ii);
            try {
                if (!this.messageSelectorFilter.matches(nextMessage)) continue;
                filteredMessages.add(nextMessage);
                continue;
            }
            catch (JMSException exc) {
                throw new RuntimeException(exc.getMessage());
            }
        }
        return filteredMessages;
    }
}

