/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.jdbc;

import com.mockrunner.base.NestedApplicationException;
import com.mockrunner.jdbc.ResultSetFactory;
import com.mockrunner.mock.jdbc.MockResultSet;
import com.mockrunner.util.common.FileUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;

public class XMLResultSetFactory
implements ResultSetFactory {
    public static final int SYBASE_DIALECT = 0;
    public static final int SQUIRREL_DIALECT = 1;
    private File file = null;
    private String fileName = null;
    private boolean trim = true;
    private int dialect = 0;

    public XMLResultSetFactory(String fileName) {
        this.file = new File(fileName);
        this.fileName = fileName;
    }

    public XMLResultSetFactory(File file) {
        this.file = file;
        this.fileName = file.getAbsolutePath();
    }

    @Override
    public MockResultSet create(String id) {
        MockResultSet resultSet;
        switch (this.dialect) {
            case 0: {
                resultSet = this.createSybaseResultSet(id);
                break;
            }
            case 1: {
                resultSet = this.createSquirrelResultSet(id);
                break;
            }
            default: {
                resultSet = this.createSybaseResultSet(id);
            }
        }
        return resultSet;
    }

    public File getXMLFile() {
        if (this.file.exists() && this.file.isFile()) {
            return this.file;
        }
        try {
            this.file = FileUtil.findFile((String)this.file.getPath());
            return this.file;
        }
        catch (FileNotFoundException exc) {
            throw new RuntimeException("Could not find: " + this.file.getPath());
        }
    }

    public void setTrim(boolean trim) {
        this.trim = trim;
    }

    public boolean getTrim() {
        return this.trim;
    }

    public void setDialect(int dialect) {
        this.dialect = dialect;
    }

    public int getDialect() {
        return this.dialect;
    }

    public MockResultSet createSybaseResultSet(String id) {
        MockResultSet resultSet = new MockResultSet(id);
        SAXBuilder builder = new SAXBuilder();
        Document doc = null;
        File fileToParse = this.getXMLFile();
        if (null == fileToParse) {
            throw new RuntimeException("File " + this.fileName + " not found.");
        }
        try {
            doc = builder.build(fileToParse);
            Element root = doc.getRootElement();
            List rows = root.getChildren("row");
            Iterator ri = rows.iterator();
            boolean firstIteration = true;
            int colNum = 0;
            while (ri.hasNext()) {
                Element cRow = (Element)ri.next();
                List cRowChildren = cRow.getChildren();
                Iterator cri = cRowChildren.iterator();
                if (firstIteration) {
                    List columns = cRowChildren;
                    for (Object column : columns) {
                        Element ccRow = (Element)column;
                        resultSet.addColumn(ccRow.getName());
                        ++colNum;
                    }
                    firstIteration = false;
                }
                Object[] cRowValues = new String[colNum];
                int curCol = 0;
                while (cri.hasNext()) {
                    Element crValue = (Element)cri.next();
                    String value = this.trim ? crValue.getTextTrim() : crValue.getText();
                    cRowValues[curCol] = value;
                    ++curCol;
                }
                resultSet.addRow(cRowValues);
            }
        }
        catch (Exception exc) {
            throw new NestedApplicationException("Failure while reading from XML file", (Throwable)exc);
        }
        return resultSet;
    }

    public MockResultSet createSquirrelResultSet(String id) {
        MockResultSet resultSet = new MockResultSet(id);
        SAXBuilder builder = new SAXBuilder();
        Document doc = null;
        File fileToParse = this.getXMLFile();
        if (null == fileToParse) {
            throw new RuntimeException("File " + this.fileName + " not found.");
        }
        try {
            doc = builder.build(fileToParse);
            HashMap<Integer, String> columnNameMap = new HashMap<Integer, String>();
            Element root = doc.getRootElement();
            List columns = root.getChild("columns").getChildren("column");
            Iterator ci = columns.iterator();
            int maxColumnNumber = 0;
            while (ci.hasNext()) {
                Element cColumn = (Element)ci.next();
                int columnNumber = cColumn.getAttribute("number").getIntValue();
                if (columnNumber > maxColumnNumber) {
                    maxColumnNumber = columnNumber;
                }
                String columnName = cColumn.getChildText("name");
                columnNameMap.put(columnNumber, columnName);
            }
            int offset = 0;
            for (int ii = 0; ii < columnNameMap.size(); ++ii) {
                String name;
                while ((name = (String)columnNameMap.get(ii + offset)) == null) {
                    resultSet.addColumn("unknown." + ++offset);
                }
                resultSet.addColumn(name);
            }
            List rows = root.getChild("rows").getChildren("row");
            for (Object row : rows) {
                Element cRow = (Element)row;
                List cRowChildren = cRow.getChildren();
                Iterator cri = cRowChildren.iterator();
                Object[] cRowValues = new String[maxColumnNumber + 1];
                while (cri.hasNext()) {
                    Element crValue = (Element)cri.next();
                    String value = this.trim ? crValue.getTextTrim() : crValue.getText();
                    int curCol = crValue.getAttribute("columnNumber").getIntValue();
                    cRowValues[curCol] = value;
                }
                resultSet.addRow(cRowValues);
            }
        }
        catch (Exception exc) {
            throw new NestedApplicationException("Failure while reading from XML file", (Throwable)exc);
        }
        return resultSet;
    }
}

