/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.mock.jdbc;

import com.mockrunner.base.NestedApplicationException;
import com.mockrunner.jdbc.ParameterUtil;
import com.mockrunner.jdbc.SQLUtil;
import com.mockrunner.mock.jdbc.MockArray;
import com.mockrunner.mock.jdbc.MockBlob;
import com.mockrunner.mock.jdbc.MockClob;
import com.mockrunner.mock.jdbc.MockNClob;
import com.mockrunner.mock.jdbc.MockParameterMap;
import com.mockrunner.mock.jdbc.MockRef;
import com.mockrunner.mock.jdbc.MockResultSetMetaData;
import com.mockrunner.mock.jdbc.MockRowId;
import com.mockrunner.mock.jdbc.MockSQLXML;
import com.mockrunner.mock.jdbc.MockStatement;
import com.mockrunner.util.common.CaseAwareMap;
import com.mockrunner.util.common.CollectionUtil;
import com.mockrunner.util.common.StreamUtil;
import com.mockrunner.util.common.StringUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockResultSet
implements ResultSet,
Cloneable {
    private Statement statement;
    private String id;
    private Map<String, List<Object>> columnMap;
    private Map<String, List<Object>> columnMapCopy;
    private Map<String, List<Object>> insertRow;
    private List<String> columnNameList;
    private List<Boolean> updatedRows;
    private List<Boolean> deletedRows;
    private List<Boolean> insertedRows;
    private int cursor;
    private boolean isCursorInInsertRow;
    private boolean wasNull;
    private String cursorName;
    private int fetchSize = 0;
    private int fetchDirection = 1000;
    private int resultSetType = 1004;
    private int resultSetConcurrency = 1007;
    private int resultSetHoldability = 1;
    private boolean isDatabaseView;
    private ResultSetMetaData resultSetMetaData;
    private boolean closed;
    private boolean columnsCaseSensitive;

    public MockResultSet(String id) {
        this(id, "");
    }

    public MockResultSet(String id, String cursorName) {
        this.init();
        this.cursorName = cursorName;
        this.id = id;
        this.columnsCaseSensitive = false;
    }

    private void init() {
        this.columnMap = this.createCaseAwareMap();
        this.columnNameList = new ArrayList<String>();
        this.updatedRows = new ArrayList<Boolean>();
        this.deletedRows = new ArrayList<Boolean>();
        this.insertedRows = new ArrayList<Boolean>();
        this.cursor = -1;
        this.wasNull = false;
        this.closed = false;
        this.isCursorInInsertRow = false;
        this.isDatabaseView = false;
        this.resultSetMetaData = null;
        this.copyColumnMap();
        this.adjustInsertRow();
    }

    public MockResultSet evaluate(String sql, MockParameterMap parameters) {
        return this;
    }

    public void setColumnsCaseSensitive(boolean columnsCaseSensitive) {
        this.columnsCaseSensitive = columnsCaseSensitive;
        this.init();
    }

    public Object clone() {
        try {
            MockResultSet copy = (MockResultSet)super.clone();
            copy.columnNameList = new ArrayList<String>(this.columnNameList);
            copy.updatedRows = new ArrayList<Boolean>(this.updatedRows);
            copy.deletedRows = new ArrayList<Boolean>(this.deletedRows);
            copy.insertedRows = new ArrayList<Boolean>(this.insertedRows);
            copy.insertRow = this.copyColumnDataMap(this.insertRow);
            copy.columnMap = this.copyColumnDataMap(this.columnMap);
            copy.columnMapCopy = this.copyColumnDataMap(this.columnMapCopy);
            if (null != this.resultSetMetaData && this.resultSetMetaData instanceof MockResultSetMetaData) {
                copy.resultSetMetaData = (ResultSetMetaData)((MockResultSetMetaData)this.resultSetMetaData).clone();
            }
            return copy;
        }
        catch (CloneNotSupportedException exc) {
            throw new NestedApplicationException((Throwable)exc);
        }
    }

    public MockResultSet shallowCopy() {
        try {
            return (MockResultSet)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new NestedApplicationException((Throwable)e);
        }
    }

    public String getId() {
        return this.id;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    public void setResultSetMetaData(ResultSetMetaData resultSetMetaData) {
        this.resultSetMetaData = resultSetMetaData;
    }

    public void setStatement(Statement statement) {
        this.statement = statement;
        try {
            this.fetchDirection = statement.getFetchDirection();
            this.resultSetType = statement.getResultSetType();
            this.resultSetConcurrency = statement.getResultSetConcurrency();
            this.resultSetHoldability = statement.getResultSetHoldability();
            this.fetchSize = statement.getFetchSize();
            this.cursorName = ((MockStatement)statement).getCursorName();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void setCursorName(String cursorName) {
        this.cursorName = cursorName;
    }

    public void setResultSetType(int resultSetType) {
        this.resultSetType = resultSetType;
    }

    public void setResultSetConcurrency(int resultSetConcurrency) {
        this.resultSetConcurrency = resultSetConcurrency;
    }

    public void setResultSetHoldability(int resultSetHoldability) {
        this.resultSetHoldability = resultSetHoldability;
    }

    public void setDatabaseView(boolean databaseView) {
        this.isDatabaseView = databaseView;
    }

    public void addRow(Object[] values) {
        List<Object> valueList = Arrays.asList(values);
        this.addRow(valueList);
    }

    public void addRow(List<Object> values) {
        int missingColumns = values.size() - this.columnNameList.size();
        for (int yy = 0; yy < missingColumns; ++yy) {
            this.addColumn();
        }
        this.adjustColumns();
        for (int ii = 0; ii < values.size(); ++ii) {
            Object nextValue = values.get(ii);
            String nextColumnName = this.columnNameList.get(ii);
            List<Object> nextColumnList = this.columnMap.get(nextColumnName);
            nextColumnList.add(nextValue);
        }
        this.adjustColumns();
        this.copyColumnMap();
        this.adjustFlags();
    }

    public void addColumn() {
        this.addColumn(this.determineValidColumnName());
    }

    public void addColumn(String columnName) {
        this.addColumn(columnName, new ArrayList<Object>());
    }

    public void addColumn(Object[] values) {
        this.addColumn(this.determineValidColumnName(), values);
    }

    public void addColumn(List<Object> values) {
        this.addColumn(this.determineValidColumnName(), values);
    }

    public void addColumn(String columnName, Object[] values) {
        List<Object> columnValues = Arrays.asList(values);
        this.addColumn(columnName, columnValues);
    }

    public void addColumn(String columnName, List<Object> values) {
        ArrayList<Object> column = new ArrayList<Object>(values);
        this.columnMap.put(columnName, column);
        this.columnNameList.add(columnName);
        this.adjustColumns();
        this.adjustInsertRow();
        this.copyColumnMap();
        this.adjustFlags();
    }

    public int getRowCount() {
        if (this.columnMapCopy.size() == 0) {
            return 0;
        }
        List<Object> column = this.columnMapCopy.values().iterator().next();
        return column.size();
    }

    public int getColumnCount() {
        return this.columnMapCopy.size();
    }

    public boolean rowInserted(int number) {
        if (number < 1) {
            return false;
        }
        return this.insertedRows.get(number - 1);
    }

    public boolean rowDeleted(int number) {
        if (number < 1) {
            return false;
        }
        return this.deletedRows.get(number - 1);
    }

    public boolean rowUpdated(int number) {
        if (number < 1) {
            return false;
        }
        return this.updatedRows.get(number - 1);
    }

    public boolean isRowEqual(int number, List<Object> rowData) {
        List<Object> currentRow = this.getRow(number);
        if (null == currentRow) {
            return false;
        }
        if (currentRow.size() != rowData.size()) {
            return false;
        }
        for (int ii = 0; ii < currentRow.size(); ++ii) {
            Object source = currentRow.get(ii);
            Object target = rowData.get(ii);
            if (null != source && null != target && !source.getClass().isAssignableFrom(target.getClass()) && !target.getClass().isAssignableFrom(source.getClass())) {
                source = source.toString();
                target = target.toString();
            }
            if (ParameterUtil.compareParameter(source, target)) continue;
            return false;
        }
        return true;
    }

    public boolean isColumnEqual(int number, List<Object> columnData) {
        List<Object> currentColumn = this.getColumn(number);
        if (null == currentColumn) {
            return false;
        }
        if (currentColumn.size() != columnData.size()) {
            return false;
        }
        for (int ii = 0; ii < currentColumn.size(); ++ii) {
            Object source = currentColumn.get(ii);
            Object target = columnData.get(ii);
            if (null != source && null != target && !source.getClass().isAssignableFrom(target.getClass()) && !target.getClass().isAssignableFrom(source.getClass())) {
                source = source.toString();
                target = target.toString();
            }
            if (ParameterUtil.compareParameter(source, target)) continue;
            return false;
        }
        return true;
    }

    public boolean isColumnEqual(String name, List<Object> columnData) {
        List<Object> currentColumn = this.getColumn(name);
        if (null == currentColumn) {
            return false;
        }
        if (currentColumn.size() != columnData.size()) {
            return false;
        }
        for (int ii = 0; ii < currentColumn.size(); ++ii) {
            Object source = currentColumn.get(ii);
            Object target = columnData.get(ii);
            if (null != source && null != target && !source.getClass().isAssignableFrom(target.getClass()) && !target.getClass().isAssignableFrom(source.getClass())) {
                source = source.toString();
                target = target.toString();
            }
            if (ParameterUtil.compareParameter(source, target)) continue;
            return false;
        }
        return true;
    }

    public boolean isEqual(MockResultSet resultSet) {
        if (null == resultSet) {
            return false;
        }
        Map<String, List<Object>> thisMap = this.isDatabaseView ? this.columnMap : this.columnMapCopy;
        Map<String, List<Object>> otherMap = resultSet.isDatabaseView ? resultSet.columnMap : resultSet.columnMapCopy;
        for (String currentKey : thisMap.keySet()) {
            List<Object> thisList = thisMap.get(currentKey);
            List<Object> otherList = otherMap.get(currentKey);
            if (null == otherList) {
                return false;
            }
            if (thisList.size() != otherList.size()) {
                return false;
            }
            for (int ii = 0; ii < thisList.size(); ++ii) {
                Object source = thisList.get(ii);
                Object target = otherList.get(ii);
                if (null != source && null != target && !source.getClass().isAssignableFrom(target.getClass()) && !target.getClass().isAssignableFrom(source.getClass())) {
                    source = source.toString();
                    target = target.toString();
                }
                if (ParameterUtil.compareParameter(source, target)) continue;
                return false;
            }
        }
        return true;
    }

    public List<Object> getRow(int number) {
        if (number > this.getRowCount()) {
            return null;
        }
        if (number < 1) {
            return null;
        }
        int index = number - 1;
        ArrayList<Object> list = new ArrayList<Object>();
        for (int ii = 0; ii < this.columnNameList.size(); ++ii) {
            String nextColumnName = this.columnNameList.get(ii);
            List<Object> nextColumnList = this.isDatabaseView ? this.columnMap.get(nextColumnName) : this.columnMapCopy.get(nextColumnName);
            list.add(nextColumnList.get(index));
        }
        return list;
    }

    public List<Object> getColumn(int number) {
        if (number > this.getColumnCount()) {
            return null;
        }
        if (number < 1) {
            return null;
        }
        int index = number - 1;
        String columnName = this.columnNameList.get(index);
        return this.getColumn(columnName);
    }

    public List<Object> getColumn(String name) {
        ArrayList<Object> list = new ArrayList<Object>();
        List<Object> columnList = this.isDatabaseView ? this.columnMap.get(name) : this.columnMapCopy.get(name);
        if (null == columnList) {
            return null;
        }
        list.addAll(columnList);
        return list;
    }

    @Override
    public void close() throws SQLException {
        this.closed = true;
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.wasNull;
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        this.checkColumnBounds(columnIndex);
        this.checkRowBounds();
        String columnName = this.columnNameList.get(columnIndex - 1);
        return this.getObject(columnName);
    }

    @Override
    public Object getObject(String columnName) throws SQLException {
        this.checkRowBounds();
        if (this.rowDeleted()) {
            throw new SQLException("row was deleted");
        }
        List<Object> column = this.isDatabaseView ? this.columnMap.get(columnName) : this.columnMapCopy.get(columnName);
        this.checkColumnNotNull(column, columnName);
        Object value = column.get(this.cursor);
        this.wasNull = null == value;
        return value;
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        return (T)this.getObject(columnIndex);
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        return (T)this.getObject(columnLabel);
    }

    @Override
    public Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {
        return this.getObject(columnIndex);
    }

    @Override
    public Object getObject(String colName, Map<String, Class<?>> map) throws SQLException {
        return this.getObject(colName);
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        Object value = this.getObject(columnIndex);
        if (null != value) {
            return value.toString();
        }
        return null;
    }

    @Override
    public String getString(String columnName) throws SQLException {
        Object value = this.getObject(columnName);
        if (null != value) {
            return value.toString();
        }
        return null;
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        return this.getString(columnIndex);
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        return this.getString(columnLabel);
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        Object value = this.getObject(columnIndex);
        if (null != value) {
            if (value instanceof Boolean) {
                return (Boolean)value;
            }
            return Boolean.parseBoolean(value.toString());
        }
        return false;
    }

    @Override
    public boolean getBoolean(String columnName) throws SQLException {
        Object value = this.getObject(columnName);
        if (null != value) {
            if (value instanceof Boolean) {
                return (Boolean)value;
            }
            return Boolean.parseBoolean(value.toString());
        }
        return false;
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        Object value = this.getObject(columnIndex);
        if (null != value) {
            if (value instanceof Number) {
                return ((Number)value).byteValue();
            }
            return Byte.parseByte(value.toString());
        }
        return 0;
    }

    @Override
    public byte getByte(String columnName) throws SQLException {
        Object value = this.getObject(columnName);
        if (null != value) {
            if (value instanceof Number) {
                return ((Number)value).byteValue();
            }
            return Byte.parseByte(value.toString());
        }
        return 0;
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        Object value = this.getObject(columnIndex);
        if (null != value) {
            if (value instanceof Number) {
                return ((Number)value).shortValue();
            }
            return Short.parseShort(value.toString());
        }
        return 0;
    }

    @Override
    public short getShort(String columnName) throws SQLException {
        Object value = this.getObject(columnName);
        if (null != value) {
            if (value instanceof Number) {
                return ((Number)value).shortValue();
            }
            return Short.parseShort(value.toString());
        }
        return 0;
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        Object value = this.getObject(columnIndex);
        if (null != value) {
            if (value instanceof Number) {
                return ((Number)value).intValue();
            }
            return Integer.parseInt(value.toString());
        }
        return 0;
    }

    @Override
    public int getInt(String columnName) throws SQLException {
        Object value = this.getObject(columnName);
        if (null != value) {
            if (value instanceof Number) {
                return ((Number)value).intValue();
            }
            return Integer.parseInt(value.toString());
        }
        return 0;
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        Object value = this.getObject(columnIndex);
        if (null != value) {
            if (value instanceof Number) {
                return ((Number)value).longValue();
            }
            return Long.parseLong(value.toString());
        }
        return 0L;
    }

    @Override
    public long getLong(String columnName) throws SQLException {
        Object value = this.getObject(columnName);
        if (null != value) {
            if (value instanceof Number) {
                return ((Number)value).longValue();
            }
            return Long.parseLong(value.toString());
        }
        return 0L;
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        Object value = this.getObject(columnIndex);
        if (null != value) {
            if (value instanceof Number) {
                return ((Number)value).floatValue();
            }
            return Float.parseFloat(value.toString());
        }
        return 0.0f;
    }

    @Override
    public float getFloat(String columnName) throws SQLException {
        Object value = this.getObject(columnName);
        if (null != value) {
            if (value instanceof Number) {
                return ((Number)value).floatValue();
            }
            return Float.parseFloat(value.toString());
        }
        return 0.0f;
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        Object value = this.getObject(columnIndex);
        if (null != value) {
            if (value instanceof Number) {
                return ((Number)value).doubleValue();
            }
            return Double.parseDouble(value.toString());
        }
        return 0.0;
    }

    @Override
    public double getDouble(String columnName) throws SQLException {
        Object value = this.getObject(columnName);
        if (null != value) {
            if (value instanceof Number) {
                return ((Number)value).doubleValue();
            }
            return Double.parseDouble(value.toString());
        }
        return 0.0;
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        BigDecimal value = this.getBigDecimal(columnIndex);
        if (null != value) {
            return value.setScale(scale);
        }
        return null;
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        BigDecimal value = this.getBigDecimal(columnName);
        if (null != value) {
            return value.setScale(scale);
        }
        return null;
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        Object value = this.getObject(columnIndex);
        if (null != value) {
            if (value instanceof BigDecimal) {
                return (BigDecimal)value;
            }
            if (value instanceof Number) {
                return new BigDecimal(((Number)value).doubleValue());
            }
            return new BigDecimal(value.toString());
        }
        return null;
    }

    @Override
    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        Object value = this.getObject(columnName);
        if (null != value) {
            if (value instanceof BigDecimal) {
                return (BigDecimal)value;
            }
            if (value instanceof Number) {
                return new BigDecimal(((Number)value).doubleValue());
            }
            return new BigDecimal(value.toString());
        }
        return null;
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        Object value = this.getObject(columnIndex);
        if (null != value) {
            if (value instanceof byte[]) {
                return (byte[])value;
            }
            try {
                return value.toString().getBytes("ISO-8859-1");
            }
            catch (UnsupportedEncodingException exc) {
                throw new NestedApplicationException((Throwable)exc);
            }
        }
        return null;
    }

    @Override
    public byte[] getBytes(String columnName) throws SQLException {
        Object value = this.getObject(columnName);
        if (null != value) {
            if (value instanceof byte[]) {
                return (byte[])value;
            }
            try {
                return value.toString().getBytes("ISO-8859-1");
            }
            catch (UnsupportedEncodingException exc) {
                throw new NestedApplicationException((Throwable)exc);
            }
        }
        return null;
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        Object value = this.getObject(columnIndex);
        if (null != value) {
            if (value instanceof Date) {
                return (Date)value;
            }
            return Date.valueOf(value.toString());
        }
        return null;
    }

    @Override
    public Date getDate(String columnName) throws SQLException {
        Object value = this.getObject(columnName);
        if (null != value) {
            if (value instanceof Date) {
                return (Date)value;
            }
            return Date.valueOf(value.toString());
        }
        return null;
    }

    @Override
    public Date getDate(int columnIndex, Calendar calendar) throws SQLException {
        return this.getDate(columnIndex);
    }

    @Override
    public Date getDate(String columnName, Calendar calendar) throws SQLException {
        return this.getDate(columnName);
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        Object value = this.getObject(columnIndex);
        if (null != value) {
            if (value instanceof Time) {
                return (Time)value;
            }
            return Time.valueOf(value.toString());
        }
        return null;
    }

    @Override
    public Time getTime(String columnName) throws SQLException {
        Object value = this.getObject(columnName);
        if (null != value) {
            if (value instanceof Time) {
                return (Time)value;
            }
            return Time.valueOf(value.toString());
        }
        return null;
    }

    @Override
    public Time getTime(int columnIndex, Calendar calendar) throws SQLException {
        return this.getTime(columnIndex);
    }

    @Override
    public Time getTime(String columnName, Calendar calendar) throws SQLException {
        return this.getTime(columnName);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        Object value = this.getObject(columnIndex);
        if (null != value) {
            if (value instanceof Timestamp) {
                return (Timestamp)value;
            }
            return Timestamp.valueOf(value.toString());
        }
        return null;
    }

    @Override
    public Timestamp getTimestamp(String columnName) throws SQLException {
        Object value = this.getObject(columnName);
        if (null != value) {
            if (value instanceof Timestamp) {
                return (Timestamp)value;
            }
            return Timestamp.valueOf(value.toString());
        }
        return null;
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar calendar) throws SQLException {
        return this.getTimestamp(columnIndex);
    }

    @Override
    public Timestamp getTimestamp(String columnName, Calendar calendar) throws SQLException {
        return this.getTimestamp(columnName);
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        Object value = this.getObject(columnIndex);
        if (null != value) {
            if (value instanceof URL) {
                return (URL)value;
            }
            try {
                return new URL(value.toString());
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public URL getURL(String columnName) throws SQLException {
        Object value = this.getObject(columnName);
        if (null != value) {
            if (value instanceof URL) {
                return (URL)value;
            }
            try {
                return new URL(value.toString());
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        Object value = this.getObject(columnIndex);
        if (null != value) {
            if (value instanceof Blob) {
                return (Blob)value;
            }
            return new MockBlob(this.getBytes(columnIndex));
        }
        return null;
    }

    @Override
    public Blob getBlob(String columnName) throws SQLException {
        Object value = this.getObject(columnName);
        if (null != value) {
            if (value instanceof Blob) {
                return (Blob)value;
            }
            return new MockBlob(this.getBytes(columnName));
        }
        return null;
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        Object value = this.getObject(columnIndex);
        if (null != value) {
            if (value instanceof Clob) {
                return (Clob)value;
            }
            return new MockClob(this.getString(columnIndex));
        }
        return null;
    }

    @Override
    public Clob getClob(String columnName) throws SQLException {
        Object value = this.getObject(columnName);
        if (null != value) {
            if (value instanceof Clob) {
                return (Clob)value;
            }
            return new MockClob(this.getString(columnName));
        }
        return null;
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        Object value = this.getObject(columnIndex);
        if (null != value) {
            if (value instanceof NClob) {
                return (NClob)value;
            }
            if (value instanceof Clob) {
                return this.getNClobFromClob((Clob)value);
            }
            return new MockNClob(this.getString(columnIndex));
        }
        return null;
    }

    @Override
    public NClob getNClob(String columnName) throws SQLException {
        Object value = this.getObject(columnName);
        if (null != value) {
            if (value instanceof NClob) {
                return (NClob)value;
            }
            if (value instanceof Clob) {
                return this.getNClobFromClob((Clob)value);
            }
            return new MockNClob(this.getString(columnName));
        }
        return null;
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        Object value = this.getObject(columnIndex);
        if (null != value) {
            if (value instanceof SQLXML) {
                return (SQLXML)value;
            }
            return new MockSQLXML(this.getString(columnIndex));
        }
        return null;
    }

    @Override
    public SQLXML getSQLXML(String columnName) throws SQLException {
        Object value = this.getObject(columnName);
        if (null != value) {
            if (value instanceof SQLXML) {
                return (SQLXML)value;
            }
            return new MockSQLXML(this.getString(columnName));
        }
        return null;
    }

    @Override
    public Array getArray(int columnIndex) throws SQLException {
        Object value = this.getObject(columnIndex);
        if (null != value) {
            if (value instanceof Array) {
                return (Array)value;
            }
            return new MockArray(value);
        }
        return null;
    }

    @Override
    public Array getArray(String columnName) throws SQLException {
        Object value = this.getObject(columnName);
        if (null != value) {
            if (value instanceof Array) {
                return (Array)value;
            }
            return new MockArray(value);
        }
        return null;
    }

    @Override
    public Ref getRef(int columnIndex) throws SQLException {
        Object value = this.getObject(columnIndex);
        if (null != value) {
            if (value instanceof Ref) {
                return (Ref)value;
            }
            return new MockRef(value);
        }
        return null;
    }

    @Override
    public Ref getRef(String columnName) throws SQLException {
        Object value = this.getObject(columnName);
        if (null != value) {
            if (value instanceof Ref) {
                return (Ref)value;
            }
            return new MockRef(value);
        }
        return null;
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        Object value = this.getObject(columnIndex);
        if (null != value) {
            if (value instanceof RowId) {
                return (RowId)value;
            }
            return new MockRowId(this.getBytes(columnIndex));
        }
        return null;
    }

    @Override
    public RowId getRowId(String columnName) throws SQLException {
        Object value = this.getObject(columnName);
        if (null != value) {
            if (value instanceof RowId) {
                return (RowId)value;
            }
            return new MockRowId(this.getBytes(columnName));
        }
        return null;
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        return this.getBinaryStream(columnIndex);
    }

    @Override
    public InputStream getAsciiStream(String columnName) throws SQLException {
        return this.getBinaryStream(columnName);
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        Object value = this.getObject(columnIndex);
        if (null != value) {
            if (value instanceof InputStream) {
                return (InputStream)value;
            }
            return new ByteArrayInputStream(this.getBytes(columnIndex));
        }
        return null;
    }

    @Override
    public InputStream getBinaryStream(String columnName) throws SQLException {
        Object value = this.getObject(columnName);
        if (null != value) {
            if (value instanceof InputStream) {
                return (InputStream)value;
            }
            return new ByteArrayInputStream(this.getBytes(columnName));
        }
        return null;
    }

    @Override
    @Deprecated
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        Object value = this.getObject(columnIndex);
        if (null != value) {
            if (value instanceof InputStream) {
                return (InputStream)value;
            }
            try {
                return new ByteArrayInputStream(this.getString(columnIndex).getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException exc) {
                throw new NestedApplicationException((Throwable)exc);
            }
        }
        return null;
    }

    @Override
    @Deprecated
    public InputStream getUnicodeStream(String columnName) throws SQLException {
        Object value = this.getObject(columnName);
        if (null != value) {
            if (value instanceof InputStream) {
                return (InputStream)value;
            }
            try {
                return new ByteArrayInputStream(this.getString(columnName).getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException exc) {
                throw new NestedApplicationException((Throwable)exc);
            }
        }
        return null;
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        Object value = this.getObject(columnIndex);
        if (null != value) {
            if (value instanceof Reader) {
                return (Reader)value;
            }
            return new StringReader(this.getString(columnIndex));
        }
        return null;
    }

    @Override
    public Reader getCharacterStream(String columnName) throws SQLException {
        Object value = this.getObject(columnName);
        if (null != value) {
            if (value instanceof Reader) {
                return (Reader)value;
            }
            return new StringReader(this.getString(columnName));
        }
        return null;
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        return this.getCharacterStream(columnIndex);
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        return this.getCharacterStream(columnLabel);
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public String getCursorName() throws SQLException {
        return this.cursorName;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        if (null != this.resultSetMetaData) {
            return this.resultSetMetaData;
        }
        MockResultSetMetaData metaData = new MockResultSetMetaData();
        metaData.setColumnCount(this.getColumnCount());
        for (int ii = 0; ii < this.columnNameList.size(); ++ii) {
            metaData.setColumnName(ii + 1, this.columnNameList.get(ii));
        }
        return metaData;
    }

    @Override
    public Statement getStatement() throws SQLException {
        return this.statement;
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        return this.getRowCount() != 0 && this.cursor == -1;
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        return this.cursor >= this.getRowCount();
    }

    @Override
    public boolean isFirst() throws SQLException {
        return this.cursor == 0;
    }

    @Override
    public boolean isLast() throws SQLException {
        return this.cursor != -1 && this.cursor == this.getRowCount() - 1;
    }

    @Override
    public void beforeFirst() throws SQLException {
        if (this.isCursorInInsertRow) {
            throw new SQLException("cursor is in insert row");
        }
        this.checkResultSetType();
        this.cursor = -1;
    }

    @Override
    public void afterLast() throws SQLException {
        if (this.isCursorInInsertRow) {
            throw new SQLException("cursor is in insert row");
        }
        this.checkResultSetType();
        if (this.getRowCount() == 0) {
            return;
        }
        this.cursor = this.getRowCount();
    }

    @Override
    public boolean next() throws SQLException {
        if (this.isCursorInInsertRow) {
            throw new SQLException("cursor is in insert row");
        }
        if (this.getRowCount() == 0) {
            return false;
        }
        ++this.cursor;
        this.adjustCursor();
        return this.isCurrentRowValid();
    }

    @Override
    public boolean first() throws SQLException {
        if (this.isCursorInInsertRow) {
            throw new SQLException("cursor is in insert row");
        }
        this.checkResultSetType();
        if (this.getRowCount() == 0) {
            return false;
        }
        this.cursor = 0;
        return true;
    }

    @Override
    public boolean last() throws SQLException {
        if (this.isCursorInInsertRow) {
            throw new SQLException("cursor is in insert row");
        }
        this.checkResultSetType();
        if (this.getRowCount() == 0) {
            return false;
        }
        this.cursor = this.getRowCount() - 1;
        return true;
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        if (this.isCursorInInsertRow) {
            throw new SQLException("cursor is in insert row");
        }
        this.checkResultSetType();
        if (this.getRowCount() == 0) {
            return false;
        }
        if (row > 0) {
            this.cursor = row - 1;
        }
        if (row < 0) {
            this.cursor = this.getRowCount() + row;
        }
        this.adjustCursor();
        return this.isCurrentRowValid();
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        if (this.isCursorInInsertRow) {
            throw new SQLException("cursor is in insert row");
        }
        this.checkResultSetType();
        if (this.getRowCount() == 0) {
            return false;
        }
        this.cursor += rows;
        this.adjustCursor();
        return this.isCurrentRowValid();
    }

    @Override
    public int getRow() throws SQLException {
        return this.cursor + 1;
    }

    @Override
    public boolean previous() throws SQLException {
        if (this.isCursorInInsertRow) {
            throw new SQLException("cursor is in insert row");
        }
        this.checkResultSetType();
        if (this.getRowCount() == 0) {
            return false;
        }
        --this.cursor;
        this.adjustCursor();
        return this.isCurrentRowValid();
    }

    @Override
    public void setFetchDirection(int fetchDirection) throws SQLException {
        this.checkFetchDirectionArguments(fetchDirection);
        if (this.fetchDirection == fetchDirection) {
            return;
        }
        if (this.fetchDirection == 1002 || fetchDirection == 1002) {
            this.fetchDirection = fetchDirection;
            return;
        }
        this.fetchDirection = fetchDirection;
        for (List<Object> column : this.columnMapCopy.values()) {
            Collections.reverse(column);
        }
        if (-1 != this.cursor) {
            this.cursor = this.getRowCount() - this.cursor - 1;
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return this.fetchDirection;
    }

    @Override
    public void setFetchSize(int fetchSize) throws SQLException {
        this.fetchSize = fetchSize;
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    @Override
    public int getType() throws SQLException {
        return this.resultSetType;
    }

    @Override
    public int getConcurrency() throws SQLException {
        return this.resultSetConcurrency;
    }

    @Override
    public int getHoldability() throws SQLException {
        return this.resultSetHoldability;
    }

    @Override
    public int findColumn(String columnName) throws SQLException {
        for (int ii = 0; ii < this.columnNameList.size(); ++ii) {
            if (!columnName.equals(this.columnNameList.get(ii))) continue;
            return ii + 1;
        }
        throw new SQLException("No column with name " + columnName + " found");
    }

    @Override
    public void updateObject(int columnIndex, Object value) throws SQLException {
        this.checkColumnBounds(columnIndex);
        if (!this.isCursorInInsertRow) {
            this.checkRowBounds();
            if (this.rowDeleted()) {
                throw new SQLException("row was deleted");
            }
        }
        String columnName = this.columnNameList.get(columnIndex - 1);
        this.updateObject(columnName, value);
    }

    @Override
    public void updateObject(int columnIndex, Object value, int scale) throws SQLException {
        this.updateObject(columnIndex, value);
    }

    @Override
    public void updateObject(String columnName, Object value, int scale) throws SQLException {
        this.updateObject(columnName, value);
    }

    @Override
    public void updateObject(String columnName, Object value) throws SQLException {
        this.checkResultSetConcurrency();
        if (!this.isCursorInInsertRow) {
            this.checkRowBounds();
            if (this.rowDeleted()) {
                throw new SQLException("row was deleted");
            }
        }
        if (this.isCursorInInsertRow) {
            List<Object> column = this.insertRow.get(columnName);
            this.checkColumnNotNull(column, columnName);
            column.set(0, value);
        } else {
            List<Object> column = this.columnMapCopy.get(columnName);
            this.checkColumnNotNull(column, columnName);
            column.set(this.cursor, value);
        }
    }

    @Override
    public void updateString(int columnIndex, String value) throws SQLException {
        this.updateObject(columnIndex, (Object)value);
    }

    @Override
    public void updateString(String columnName, String value) throws SQLException {
        this.updateObject(columnName, (Object)value);
    }

    @Override
    public void updateNString(int columnIndex, String value) throws SQLException {
        this.updateObject(columnIndex, (Object)value);
    }

    @Override
    public void updateNString(String columnLabel, String value) throws SQLException {
        this.updateObject(columnLabel, (Object)value);
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        this.updateObject(columnIndex, null);
    }

    @Override
    public void updateNull(String columnName) throws SQLException {
        this.updateObject(columnName, null);
    }

    @Override
    public void updateBoolean(int columnIndex, boolean booleanValue) throws SQLException {
        this.updateObject(columnIndex, (Object)booleanValue);
    }

    @Override
    public void updateBoolean(String columnName, boolean booleanValue) throws SQLException {
        this.updateObject(columnName, (Object)booleanValue);
    }

    @Override
    public void updateByte(int columnIndex, byte byteValue) throws SQLException {
        this.updateObject(columnIndex, (Object)byteValue);
    }

    @Override
    public void updateByte(String columnName, byte byteValue) throws SQLException {
        this.updateObject(columnName, (Object)byteValue);
    }

    @Override
    public void updateShort(int columnIndex, short shortValue) throws SQLException {
        this.updateObject(columnIndex, (Object)shortValue);
    }

    @Override
    public void updateShort(String columnName, short shortValue) throws SQLException {
        this.updateObject(columnName, (Object)shortValue);
    }

    @Override
    public void updateInt(int columnIndex, int intValue) throws SQLException {
        this.updateObject(columnIndex, (Object)intValue);
    }

    @Override
    public void updateInt(String columnName, int intValue) throws SQLException {
        this.updateObject(columnName, (Object)intValue);
    }

    @Override
    public void updateLong(int columnIndex, long longValue) throws SQLException {
        this.updateObject(columnIndex, (Object)longValue);
    }

    @Override
    public void updateLong(String columnName, long longValue) throws SQLException {
        this.updateObject(columnName, (Object)longValue);
    }

    @Override
    public void updateFloat(int columnIndex, float floatValue) throws SQLException {
        this.updateObject(columnIndex, (Object)Float.valueOf(floatValue));
    }

    @Override
    public void updateFloat(String columnName, float floatValue) throws SQLException {
        this.updateObject(columnName, (Object)Float.valueOf(floatValue));
    }

    @Override
    public void updateDouble(int columnIndex, double doubleValue) throws SQLException {
        this.updateObject(columnIndex, (Object)doubleValue);
    }

    @Override
    public void updateDouble(String columnName, double doubleValue) throws SQLException {
        this.updateObject(columnName, (Object)doubleValue);
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal bigDecimal) throws SQLException {
        this.updateObject(columnIndex, (Object)bigDecimal);
    }

    @Override
    public void updateBigDecimal(String columnName, BigDecimal bigDecimal) throws SQLException {
        this.updateObject(columnName, (Object)bigDecimal);
    }

    @Override
    public void updateBytes(int columnIndex, byte[] byteArray) throws SQLException {
        this.updateObject(columnIndex, (Object)byteArray);
    }

    @Override
    public void updateBytes(String columnName, byte[] byteArray) throws SQLException {
        this.updateObject(columnName, (Object)byteArray);
    }

    @Override
    public void updateDate(int columnIndex, Date date) throws SQLException {
        this.updateObject(columnIndex, (Object)date);
    }

    @Override
    public void updateDate(String columnName, Date date) throws SQLException {
        this.updateObject(columnName, (Object)date);
    }

    @Override
    public void updateTime(int columnIndex, Time time) throws SQLException {
        this.updateObject(columnIndex, (Object)time);
    }

    @Override
    public void updateTime(String columnName, Time time) throws SQLException {
        this.updateObject(columnName, (Object)time);
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp timeStamp) throws SQLException {
        this.updateObject(columnIndex, (Object)timeStamp);
    }

    @Override
    public void updateTimestamp(String columnName, Timestamp timeStamp) throws SQLException {
        this.updateObject(columnName, (Object)timeStamp);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream stream, int length) throws SQLException {
        this.updateBinaryStream(columnIndex, stream, length);
    }

    @Override
    public void updateAsciiStream(String columnName, InputStream stream, int length) throws SQLException {
        this.updateBinaryStream(columnName, stream, length);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream stream, long length) throws SQLException {
        this.updateBinaryStream(columnIndex, stream, length);
    }

    @Override
    public void updateAsciiStream(String columnName, InputStream stream, long length) throws SQLException {
        this.updateBinaryStream(columnName, stream, length);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream stream) throws SQLException {
        this.updateBinaryStream(columnIndex, stream);
    }

    @Override
    public void updateAsciiStream(String columnName, InputStream stream) throws SQLException {
        this.updateBinaryStream(columnName, stream);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream stream, int length) throws SQLException {
        byte[] data = StreamUtil.getStreamAsByteArray((InputStream)stream, (int)length);
        this.updateObject(columnIndex, (Object)new ByteArrayInputStream(data));
    }

    @Override
    public void updateBinaryStream(String columnName, InputStream stream, int length) throws SQLException {
        byte[] data = StreamUtil.getStreamAsByteArray((InputStream)stream, (int)length);
        this.updateObject(columnName, (Object)new ByteArrayInputStream(data));
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream stream, long length) throws SQLException {
        this.updateBinaryStream(columnIndex, stream, (int)length);
    }

    @Override
    public void updateBinaryStream(String columnName, InputStream stream, long length) throws SQLException {
        this.updateBinaryStream(columnName, stream, (int)length);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream stream) throws SQLException {
        byte[] data = StreamUtil.getStreamAsByteArray((InputStream)stream);
        this.updateObject(columnIndex, (Object)new ByteArrayInputStream(data));
    }

    @Override
    public void updateBinaryStream(String columnName, InputStream stream) throws SQLException {
        byte[] data = StreamUtil.getStreamAsByteArray((InputStream)stream);
        this.updateObject(columnName, (Object)new ByteArrayInputStream(data));
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader reader, int length) throws SQLException {
        String data = StreamUtil.getReaderAsString((Reader)reader, (int)length);
        this.updateObject(columnIndex, (Object)new StringReader(data));
    }

    @Override
    public void updateCharacterStream(String columnName, Reader reader, int length) throws SQLException {
        String data = StreamUtil.getReaderAsString((Reader)reader, (int)length);
        this.updateObject(columnName, (Object)new StringReader(data));
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader reader, long length) throws SQLException {
        this.updateCharacterStream(columnIndex, reader, (int)length);
    }

    @Override
    public void updateCharacterStream(String columnName, Reader reader, long length) throws SQLException {
        this.updateCharacterStream(columnName, reader, (int)length);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader reader) throws SQLException {
        String data = StreamUtil.getReaderAsString((Reader)reader);
        this.updateObject(columnIndex, (Object)new StringReader(data));
    }

    @Override
    public void updateCharacterStream(String columnName, Reader reader) throws SQLException {
        String data = StreamUtil.getReaderAsString((Reader)reader);
        this.updateObject(columnName, (Object)new StringReader(data));
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader reader) throws SQLException {
        this.updateCharacterStream(columnIndex, reader);
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        this.updateCharacterStream(columnLabel, reader);
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader reader, long length) throws SQLException {
        this.updateCharacterStream(columnIndex, reader, length);
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        this.updateCharacterStream(columnLabel, reader, length);
    }

    @Override
    public void updateRef(int columnIndex, Ref ref) throws SQLException {
        this.updateObject(columnIndex, (Object)ref);
    }

    @Override
    public void updateRef(String columnName, Ref ref) throws SQLException {
        this.updateObject(columnName, (Object)ref);
    }

    @Override
    public void updateRowId(int columnIndex, RowId rowId) throws SQLException {
        this.updateObject(columnIndex, (Object)rowId);
    }

    @Override
    public void updateRowId(String columnName, RowId rowId) throws SQLException {
        this.updateObject(columnName, (Object)rowId);
    }

    @Override
    public void updateBlob(int columnIndex, Blob blob) throws SQLException {
        this.updateObject(columnIndex, (Object)blob);
    }

    @Override
    public void updateBlob(String columnName, Blob blob) throws SQLException {
        this.updateObject(columnName, (Object)blob);
    }

    @Override
    public void updateBlob(int columnIndex, InputStream stream, long length) throws SQLException {
        byte[] data = StreamUtil.getStreamAsByteArray((InputStream)stream, (int)((int)length));
        this.updateBlob(columnIndex, (Blob)new MockBlob(data));
    }

    @Override
    public void updateBlob(String columnName, InputStream stream, long length) throws SQLException {
        byte[] data = StreamUtil.getStreamAsByteArray((InputStream)stream, (int)((int)length));
        this.updateBlob(columnName, (Blob)new MockBlob(data));
    }

    @Override
    public void updateBlob(int columnIndex, InputStream stream) throws SQLException {
        byte[] data = StreamUtil.getStreamAsByteArray((InputStream)stream);
        this.updateBlob(columnIndex, (Blob)new MockBlob(data));
    }

    @Override
    public void updateBlob(String columnName, InputStream stream) throws SQLException {
        byte[] data = StreamUtil.getStreamAsByteArray((InputStream)stream);
        this.updateBlob(columnName, (Blob)new MockBlob(data));
    }

    @Override
    public void updateClob(int columnIndex, Clob clob) throws SQLException {
        this.updateObject(columnIndex, (Object)clob);
    }

    @Override
    public void updateClob(String columnName, Clob clob) throws SQLException {
        this.updateObject(columnName, (Object)clob);
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        String data = StreamUtil.getReaderAsString((Reader)reader, (int)((int)length));
        this.updateClob(columnIndex, (Clob)new MockClob(data));
    }

    @Override
    public void updateClob(String columnName, Reader reader, long length) throws SQLException {
        String data = StreamUtil.getReaderAsString((Reader)reader, (int)((int)length));
        this.updateClob(columnName, (Clob)new MockClob(data));
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
        String data = StreamUtil.getReaderAsString((Reader)reader);
        this.updateClob(columnIndex, (Clob)new MockClob(data));
    }

    @Override
    public void updateClob(String columnName, Reader reader) throws SQLException {
        String data = StreamUtil.getReaderAsString((Reader)reader);
        this.updateClob(columnName, (Clob)new MockClob(data));
    }

    @Override
    public void updateNClob(int columnIndex, NClob nClob) throws SQLException {
        this.updateObject(columnIndex, (Object)nClob);
    }

    @Override
    public void updateNClob(String columnName, NClob nClob) throws SQLException {
        this.updateObject(columnName, (Object)nClob);
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        String data = StreamUtil.getReaderAsString((Reader)reader, (int)((int)length));
        this.updateNClob(columnIndex, (NClob)new MockNClob(data));
    }

    @Override
    public void updateNClob(String columnName, Reader reader, long length) throws SQLException {
        String data = StreamUtil.getReaderAsString((Reader)reader, (int)((int)length));
        this.updateNClob(columnName, (NClob)new MockNClob(data));
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        String data = StreamUtil.getReaderAsString((Reader)reader);
        this.updateNClob(columnIndex, (NClob)new MockNClob(data));
    }

    @Override
    public void updateNClob(String columnName, Reader reader) throws SQLException {
        String data = StreamUtil.getReaderAsString((Reader)reader);
        this.updateNClob(columnName, (NClob)new MockNClob(data));
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        this.updateObject(columnIndex, (Object)xmlObject);
    }

    @Override
    public void updateSQLXML(String columnName, SQLXML xmlObject) throws SQLException {
        this.updateObject(columnName, (Object)xmlObject);
    }

    @Override
    public void updateArray(int columnIndex, Array array) throws SQLException {
        this.updateObject(columnIndex, (Object)array);
    }

    @Override
    public void updateArray(String columnName, Array array) throws SQLException {
        this.updateObject(columnName, (Object)array);
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        this.checkRowBounds();
        return this.updatedRows.get(this.cursor);
    }

    @Override
    public boolean rowInserted() throws SQLException {
        this.checkRowBounds();
        return this.insertedRows.get(this.cursor);
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        this.checkRowBounds();
        return this.deletedRows.get(this.cursor);
    }

    @Override
    public void insertRow() throws SQLException {
        if (!this.isCursorInInsertRow) {
            throw new SQLException("cursor is not in insert row");
        }
        this.checkResultSetConcurrency();
        this.insertRow(this.cursor);
    }

    @Override
    public void updateRow() throws SQLException {
        if (this.isCursorInInsertRow) {
            throw new SQLException("cursor is in insert row");
        }
        if (this.rowDeleted()) {
            throw new SQLException("row was deleted");
        }
        this.checkResultSetConcurrency();
        this.checkRowBounds();
        this.updateRow(this.cursor, true);
        this.updatedRows.set(this.cursor, true);
    }

    @Override
    public void deleteRow() throws SQLException {
        if (this.isCursorInInsertRow) {
            throw new SQLException("cursor is in insert row");
        }
        this.checkResultSetConcurrency();
        this.checkRowBounds();
        this.deleteRow(this.cursor);
        this.deletedRows.set(this.cursor, true);
    }

    @Override
    public void refreshRow() throws SQLException {
        this.cancelRowUpdates();
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        if (this.isCursorInInsertRow) {
            throw new SQLException("cursor is in insert row");
        }
        if (this.rowDeleted()) {
            throw new SQLException("row was deleted");
        }
        this.checkRowBounds();
        this.updateRow(this.cursor, false);
        this.updatedRows.set(this.cursor, false);
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        this.adjustCursorForInsert();
        this.isCursorInInsertRow = true;
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        this.isCursorInInsertRow = false;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new SQLException("No object found for " + iface);
    }

    private void checkColumnNotNull(List<Object> column, String columnName) throws SQLException {
        if (column == null) {
            throw new SQLException("No column " + columnName);
        }
    }

    private void checkColumnBounds(int columnIndex) throws SQLException {
        if (columnIndex - 1 >= this.columnNameList.size()) {
            throw new SQLException("Index " + columnIndex + " out of bounds");
        }
    }

    private void checkRowBounds() throws SQLException {
        if (!this.isCurrentRowValid()) {
            throw new SQLException("Current row invalid");
        }
    }

    private boolean isCurrentRowValid() {
        return this.cursor < this.getRowCount() && -1 != this.cursor;
    }

    private void checkResultSetType() throws SQLException {
        if (this.resultSetType == 1003) {
            throw new SQLException("ResultSet is TYPE_FORWARD_ONLY");
        }
    }

    private void checkResultSetConcurrency() throws SQLException {
        if (this.resultSetConcurrency == 1007) {
            throw new SQLException("ResultSet is CONCUR_READ_ONLY");
        }
    }

    private void checkFetchDirectionArguments(int fetchDirection) throws SQLException {
        SQLUtil.checkFetchDirection(fetchDirection);
        if (this.resultSetType == 1003 && fetchDirection != 1000) {
            throw new SQLException("resultSetType is TYPE_FORWARD_ONLY, only FETCH_FORWARD allowed");
        }
    }

    private void insertRow(int index) {
        for (String currentColumnName : this.columnMapCopy.keySet()) {
            List<Object> copyColumn = this.columnMapCopy.get(currentColumnName);
            List<Object> databaseColumn = this.columnMap.get(currentColumnName);
            List<Object> sourceColumn = this.insertRow.get(currentColumnName);
            copyColumn.add(index, ParameterUtil.copyParameter(sourceColumn.get(0)));
            databaseColumn.add(index, ParameterUtil.copyParameter(sourceColumn.get(0)));
        }
        this.updatedRows.add(index, false);
        this.deletedRows.add(index, false);
        this.insertedRows.add(index, true);
    }

    private void deleteRow(int index) {
        for (String currentColumnName : this.columnMapCopy.keySet()) {
            List<Object> copyColumn = this.columnMapCopy.get(currentColumnName);
            List<Object> databaseColumn = this.columnMap.get(currentColumnName);
            copyColumn.set(index, null);
            databaseColumn.set(index, null);
        }
    }

    private void updateRow(int index, boolean toDatabase) {
        for (String currentColumnName : this.columnMapCopy.keySet()) {
            List<Object> targetColumn;
            List<Object> sourceColumn;
            if (toDatabase) {
                sourceColumn = this.columnMapCopy.get(currentColumnName);
                targetColumn = this.columnMap.get(currentColumnName);
            } else {
                sourceColumn = this.columnMap.get(currentColumnName);
                targetColumn = this.columnMapCopy.get(currentColumnName);
            }
            targetColumn.set(index, ParameterUtil.copyParameter(sourceColumn.get(index)));
        }
    }

    private void adjustCursorForInsert() {
        if (this.cursor >= this.getRowCount()) {
            this.cursor = this.getRowCount() - 1;
        }
        if (this.cursor < 0) {
            this.cursor = 0;
        }
    }

    private void adjustCursor() {
        if (this.cursor < 0) {
            this.cursor = -1;
        }
        if (this.cursor >= this.getRowCount()) {
            this.cursor = this.getRowCount();
        }
    }

    private void adjustColumns() {
        int rowCount = 0;
        for (List<Object> nextColumn : this.columnMap.values()) {
            rowCount = Math.max(rowCount, nextColumn.size());
        }
        for (List<Object> nextColumn : this.columnMap.values()) {
            CollectionUtil.fillList(nextColumn, (int)rowCount);
        }
    }

    private void adjustFlags() {
        int ii;
        for (ii = this.updatedRows.size(); ii < this.getRowCount(); ++ii) {
            this.updatedRows.add(false);
        }
        for (ii = this.deletedRows.size(); ii < this.getRowCount(); ++ii) {
            this.deletedRows.add(false);
        }
        for (ii = this.insertedRows.size(); ii < this.getRowCount(); ++ii) {
            this.insertedRows.add(false);
        }
    }

    private void adjustInsertRow() {
        this.insertRow = this.createCaseAwareMap();
        Iterator<String> columns = this.columnMap.keySet().iterator();
        while (columns.hasNext()) {
            ArrayList<Object> list = new ArrayList<Object>(1);
            list.add(null);
            this.insertRow.put(columns.next(), list);
        }
    }

    private void copyColumnMap() {
        this.columnMapCopy = this.copyColumnDataMap(this.columnMap);
    }

    private String determineValidColumnName() {
        String name = "Column";
        int count = this.columnNameList.size() + 1;
        while (this.columnMap.containsKey(name + count)) {
            ++count;
        }
        return name + count;
    }

    private <T> Map<String, List<T>> copyColumnDataMap(Map<String, List<T>> columnMap) {
        Map<String, List<T>> copy = this.createCaseAwareMap();
        Iterator<String> columns = columnMap.keySet().iterator();
        while (columns.hasNext()) {
            ArrayList<Object> copyList = new ArrayList<Object>();
            String nextKey = columns.next();
            List<T> nextColumnList = columnMap.get(nextKey);
            for (T nextColumnList1 : nextColumnList) {
                Object copyParameter = ParameterUtil.copyParameter(nextColumnList1);
                copyList.add(copyParameter);
            }
            copy.put(nextKey, copyList);
        }
        return copy;
    }

    private <T> Map<String, T> createCaseAwareMap() {
        return new CaseAwareMap(this.columnsCaseSensitive);
    }

    private NClob getNClobFromClob(Clob clobValue) throws SQLException {
        return new MockNClob(clobValue.getSubString(1L, (int)clobValue.length()));
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("ResultSet " + this.id + ":\n");
        buffer.append("Number of rows: " + this.getRowCount() + "\n");
        buffer.append("Number of columns: " + this.getColumnCount() + "\n");
        buffer.append("Column names:\n");
        StringUtil.appendObjectsAsString((StringBuffer)buffer, this.columnNameList);
        buffer.append("Data:\n");
        for (int ii = 1; ii <= this.getRowCount(); ++ii) {
            buffer.append("Row number " + ii + ":\n");
            StringUtil.appendObjectsAsString((StringBuffer)buffer, this.getRow(ii));
        }
        return buffer.toString();
    }
}

