/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.gen.proc;

import java.util.List;

public class JavaLineAssembler {
    private StringBuffer buffer;
    private String newLine;
    private int indentLevel;
    private String defaultMethodModifier;

    public JavaLineAssembler() {
        this.reset();
        this.newLine = System.getProperty("line.separator");
    }

    public void reset() {
        this.buffer = new StringBuffer();
        this.indentLevel = 0;
        this.defaultMethodModifier = "";
    }

    public String getResult() {
        return this.buffer.toString();
    }

    public StringBuffer getResultAsBuffer() {
        return new StringBuffer(this.getResult());
    }

    public void setIndentLevel(int indentLevel) {
        this.indentLevel = indentLevel;
    }

    public void setDefaultMethodModifier(String defaultMethodModifier) {
        this.defaultMethodModifier = defaultMethodModifier;
    }

    public void appendBlank() {
        this.buffer.append(" ");
    }

    public void appendBlank(int number) {
        for (int ii = 0; ii < number; ++ii) {
            this.appendBlank();
        }
    }

    public void appendNewLine() {
        this.buffer.append(this.newLine);
    }

    public void appendNewLine(int number) {
        for (int ii = 0; ii < number; ++ii) {
            this.appendNewLine();
        }
    }

    public void appendLeftBrace() {
        this.buffer.append("{");
    }

    public void appendRightBrace() {
        this.buffer.append("}");
    }

    public void appendLeftParenthesis() {
        this.buffer.append("(");
    }

    public void appendRightParenthesis() {
        this.buffer.append(")");
    }

    public void appendComma() {
        this.buffer.append(",");
    }

    public void appendIndent() {
        this.appendBlank(this.indentLevel * 4);
    }

    public void appendLine(String line) {
        if (null != line && line.length() > 0) {
            this.appendIndent();
            this.buffer.append(line);
            this.appendNewLine();
        }
    }

    public void appendCodeLines(String[] lines) {
        if (null == lines || lines.length <= 0) {
            this.appendNewLine();
        } else {
            for (String line : lines) {
                this.appendLine(line);
            }
        }
    }

    public void appendPackageInfo(String packageName) {
        if (null != packageName && packageName.length() > 0) {
            this.appendLine("package " + packageName + ";");
            this.appendNewLine();
        }
    }

    public void appendImport(String importLine) {
        this.appendLine("import " + importLine + ";");
    }

    public void appendImports(List<String> imports) {
        if (null == imports) {
            return;
        }
        for (String anImport : imports) {
            this.appendImport(anImport);
        }
    }

    public void appendClassDefintion(String className) {
        this.appendClassDefintion(className, "");
    }

    public void appendClassDefintion(String className, String superClass) {
        this.appendClassDefintion(className, "", superClass, null);
    }

    public void appendClassDefintion(String className, String[] interfaceDef) {
        this.appendClassDefintion(className, "", "", interfaceDef);
    }

    public void appendClassDefintion(String className, String modifier, String superClass, String[] interfaceDef) {
        if (null == className || className.length() <= 0) {
            return;
        }
        superClass = null == superClass || superClass.length() <= 0 ? "" : " extends " + superClass;
        String interfaceDefList = "";
        if (null != interfaceDef && interfaceDef.length > 0) {
            interfaceDefList = " implements " + this.prepareCommaSeparatedList(interfaceDef, null);
        }
        if (null == modifier) {
            modifier = "";
        }
        if (modifier.length() > 0) {
            modifier = modifier + " ";
        }
        this.appendLine("public " + modifier + "class " + className + superClass + interfaceDefList);
    }

    public void appendMemberDeclaration(String type, String name) {
        if (null == type || type.length() <= 0) {
            return;
        }
        if (null == name || name.length() <= 0) {
            return;
        }
        this.appendLine("private " + type + " " + name + ";");
    }

    public void appendConstructorDeclaration(String name) {
        this.appendConstructorDeclaration(name, null, null);
    }

    public void appendConstructorDeclaration(String name, String[] parameterTypes, String[] parameterNames) {
        this.appendConstructorDeclaration(name, parameterTypes, parameterNames, null);
    }

    public void appendConstructorDeclaration(String name, String[] parameterTypes, String[] parameterNames, String[] exceptions) {
        if (null == name || name.length() <= 0) {
            return;
        }
        StringBuffer buffer = new StringBuffer(30);
        buffer.append("public ");
        this.appendSignature(name, parameterTypes, parameterNames, exceptions, buffer);
        this.appendLine(buffer.toString());
    }

    public void appendMethodDeclaration(String name) {
        this.appendMethodDeclaration("void", name);
    }

    public void appendMethodDeclaration(String returnType, String name) {
        this.appendMethodDeclaration(returnType, name, null, null);
    }

    public void appendMethodDeclaration(String returnType, String name, String[] parameterTypes, String[] parameterNames) {
        this.appendMethodDeclaration(null, returnType, name, parameterTypes, parameterNames);
    }

    public void appendMethodDeclaration(String[] modifiers, String returnType, String name, String[] parameterTypes, String[] parameterNames) {
        this.appendMethodDeclaration(modifiers, returnType, name, parameterTypes, parameterNames, null);
    }

    public void appendMethodDeclaration(String[] modifiers, String returnType, String name, String[] parameterTypes, String[] parameterNames, String[] exceptions) {
        if (null == name || name.length() <= 0) {
            return;
        }
        if (null == returnType || returnType.length() <= 0) {
            returnType = "void";
        }
        StringBuffer buffer = new StringBuffer(30);
        if (null != this.defaultMethodModifier && this.defaultMethodModifier.length() > 0) {
            buffer.append(this.defaultMethodModifier).append(" ");
        }
        buffer.append(this.prepareModifierList(modifiers));
        buffer.append(returnType).append(" ");
        this.appendSignature(name, parameterTypes, parameterNames, exceptions, buffer);
        this.appendLine(buffer.toString());
    }

    private void appendSignature(String name, String[] parameterTypes, String[] parameterNames, String[] exceptions, StringBuffer buffer) {
        buffer.append(name);
        buffer.append("(");
        buffer.append(this.prepareCommaSeparatedList(parameterTypes, this.getParameterNameList(parameterTypes, parameterNames)));
        buffer.append(")");
        this.appendThrowsClause(exceptions, buffer);
    }

    private void appendThrowsClause(String[] exceptions, StringBuffer buffer) {
        if (null == exceptions || exceptions.length <= 0) {
            return;
        }
        String throwsClause = this.prepareCommaSeparatedList(exceptions, null);
        buffer.append(" throws ").append(throwsClause);
    }

    public void appendComment(String oneLineComment) {
        if (null == oneLineComment || oneLineComment.length() <= 0) {
            return;
        }
        this.appendLine("//" + oneLineComment);
    }

    public void appendBlockComment(String[] commentLines) {
        this.appendBlockComment(commentLines, "/*");
    }

    public void appendJavaDocComment(String[] commentLines) {
        this.appendBlockComment(commentLines, "/**");
    }

    private void appendBlockComment(String[] commentLines, String commentStart) {
        if (null == commentLines || commentLines.length <= 0) {
            return;
        }
        this.appendLine(commentStart);
        for (String commentLine : commentLines) {
            this.appendLine(" * " + commentLine);
        }
        this.appendLine(" */");
    }

    private String prepareModifierList(String[] modifiers) {
        if (null == modifiers) {
            modifiers = new String[]{};
        }
        StringBuilder listBuffer = new StringBuilder(50);
        for (String modifier : modifiers) {
            listBuffer.append(modifier).append(" ");
        }
        return listBuffer.toString();
    }

    private String[] getParameterNameList(String[] types, String[] names) {
        if (null == types) {
            types = new String[]{};
        }
        if (null == names) {
            names = new String[]{};
        }
        if (names.length >= types.length) {
            return names;
        }
        String[] newNames = new String[types.length];
        System.arraycopy(names, 0, newNames, 0, names.length);
        for (int ii = 0; ii < types.length - names.length; ++ii) {
            newNames[names.length + ii] = "param" + (names.length + ii);
        }
        return newNames;
    }

    private String prepareCommaSeparatedList(String[] types, String[] names) {
        if (null == types) {
            types = new String[]{};
        }
        if (null == names) {
            names = new String[]{};
        }
        StringBuilder listBuffer = new StringBuilder(50);
        for (int ii = 0; ii < types.length; ++ii) {
            listBuffer.append(types[ii]);
            if (ii < names.length) {
                listBuffer.append(" ").append(names[ii]);
            }
            if (ii >= types.length - 1) continue;
            listBuffer.append(", ");
        }
        return listBuffer.toString();
    }
}

