/*
 * Decompiled with CFR 0.152.
 */
package com.mobileia.contacts.entity;

import android.os.Parcel;
import android.os.Parcelable;
import jagerfield.mobilecontactslibrary.Contact.Contact;
import jagerfield.mobilecontactslibrary.ElementContainers.EmailContainer;
import jagerfield.mobilecontactslibrary.ElementContainers.NumberContainer;
import java.util.ArrayList;

public class Person
implements Parcelable {
    public long id;
    public String fullname;
    public String phone;
    public String email;
    public String photo;
    public int has_account;
    public static final Parcelable.Creator<Person> CREATOR = new Parcelable.Creator<Person>(){

        public Person createFromParcel(Parcel in) {
            return new Person(in);
        }

        public Person[] newArray(int size) {
            return new Person[size];
        }
    };

    public Person() {
    }

    public Person(Parcel in) {
        this.id = in.readLong();
        this.fullname = in.readString();
        this.phone = in.readString();
        this.email = in.readString();
        this.photo = in.readString();
        this.has_account = in.readInt();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int i) {
        parcel.writeLong(this.id);
        parcel.writeString(this.fullname);
        parcel.writeString(this.phone);
        parcel.writeString(this.email);
        parcel.writeString(this.photo);
        parcel.writeInt(this.has_account);
    }

    public static Person fromContact(Contact contact) {
        Person person = new Person();
        person.id = contact.getId();
        person.fullname = contact.getDisplaydName();
        if (contact.getNumbers().size() > 0) {
            person.phone = ((NumberContainer)contact.getNumbers().get(0)).getNormalizedNumber();
        }
        if (contact.getEmails().size() > 0) {
            person.email = ((EmailContainer)contact.getEmails().get(0)).getEmail();
        }
        person.photo = contact.getPhotoUri();
        return person;
    }

    public static ArrayList<Person> fromContacts(ArrayList<Contact> contacts) {
        ArrayList<Person> list = new ArrayList<Person>();
        for (Contact c : contacts) {
            list.add(Person.fromContact(c));
        }
        return list;
    }
}

