/*
 * Decompiled with CFR 0.152.
 */
package com.mobileia.contacts.activity;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.widget.LinearLayout;
import com.miguelcatalan.materialsearchview.MaterialSearchView;
import com.mobileia.contacts.R;
import com.mobileia.contacts.adapter.BaseContactAdapter;
import com.mobileia.contacts.adapter.MiniContactAdapter;
import com.mobileia.contacts.adapter.NormalContactAdapter;
import com.mobileia.contacts.entity.Person;
import com.mobileia.contacts.helper.PermissionHelper;
import com.mobileia.contacts.helper.ToolbarHelper;
import com.mobileia.recyclerview.MobileiaRecyclerView;
import jagerfield.mobilecontactslibrary.Contact.Contact;
import jagerfield.mobilecontactslibrary.ImportContactsAsync;
import java.util.ArrayList;

public class SelectContactActivity
extends AppCompatActivity
implements MaterialSearchView.OnQueryTextListener,
BaseContactAdapter.OnContactAdapter {
    public static final String EXTRA_CONTACT_SELECTED = "com.mobileia.contacts.activity.SelectContactActivity.EXTRA_CONTACT_SELECTED";
    protected MaterialSearchView mSearchView;
    protected NormalContactAdapter mAdapter;
    protected MiniContactAdapter mAdapterSelect;
    protected MobileiaRecyclerView mRecyclerView;
    protected RecyclerView mRecyclerSelect;
    protected LinearLayout mContainerSelect;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_select_contact);
        ToolbarHelper.setUp(this, "Seleccionar contactos:");
        this.setUpViews();
        this.setUpRecyclerView();
        this.requestPermission();
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        this.getMenuInflater().inflate(R.menu.select_contact, menu2);
        MenuItem item = menu2.findItem(R.id.navigation_search);
        this.mSearchView.setMenuItem(item);
        return true;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case 16908332: {
                this.onBackPressed();
            }
        }
        return super.onOptionsItemSelected(item);
    }

    public void onBackPressed() {
        if (this.mSearchView.isSearchOpen()) {
            this.mSearchView.closeSearch();
        } else {
            this.setResult(0, new Intent());
            this.finish();
        }
    }

    @Override
    public void onClickContact(Contact contact) {
        this.mContainerSelect.setVisibility(0);
        if (this.mAdapterSelect.isExist(contact)) {
            return;
        }
        this.mAdapterSelect.addContact(contact);
    }

    public boolean onQueryTextSubmit(String query) {
        return false;
    }

    public boolean onQueryTextChange(String newText) {
        if (newText != null && newText.length() > 2) {
            this.mAdapter.filterByQuery(newText);
        } else if (newText == null || newText.length() == 0) {
            this.mAdapter.clearFilter();
        }
        return false;
    }

    public void onClickSend(View v) {
        ArrayList<Person> selecteds = Person.fromContacts(this.mAdapterSelect.getItems());
        Intent intent = new Intent();
        intent.putParcelableArrayListExtra(EXTRA_CONTACT_SELECTED, selecteds);
        this.setResult(-1, intent);
        this.finish();
    }

    protected void setUpRecyclerView() {
        this.setUpAdapter();
        this.mRecyclerView = (MobileiaRecyclerView)this.findViewById(R.id.list);
        this.mRecyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this));
        this.mRecyclerView.setAdapter((RecyclerView.Adapter)this.mAdapter);
        this.mRecyclerSelect = (RecyclerView)this.findViewById(R.id.list_select);
        this.mRecyclerSelect.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this, 0, false));
        this.mRecyclerSelect.setAdapter((RecyclerView.Adapter)this.mAdapterSelect);
        this.mContainerSelect = (LinearLayout)this.findViewById(R.id.container_select);
    }

    protected void setUpAdapter() {
        this.mAdapter = new NormalContactAdapter();
        this.mAdapter.setOnClickListener(this);
        this.mAdapterSelect = new MiniContactAdapter();
        this.mAdapterSelect.setOnClickListener(new BaseContactAdapter.OnContactAdapter(){

            @Override
            public void onClickContact(Contact contact) {
                SelectContactActivity.this.mAdapterSelect.removeContact(contact);
                if (SelectContactActivity.this.mAdapterSelect.getItemCount() == 0) {
                    SelectContactActivity.this.mContainerSelect.setVisibility(8);
                }
            }
        });
    }

    protected void requestPermission() {
        PermissionHelper.readContacts((Activity)this, new PermissionHelper.OnReadContacts(){

            @Override
            public void success() {
                new ImportContactsAsync((Activity)SelectContactActivity.this, new ImportContactsAsync.ICallback(){

                    public void mobileContacts(ArrayList<Contact> contactList) {
                        SelectContactActivity.this.cleanContactWithoutNumber(contactList);
                        SelectContactActivity.this.mAdapter.loadContacts(contactList);
                    }
                }).execute((Object[])new Void[0]);
            }

            @Override
            public void denied() {
            }
        });
    }

    protected void setUpViews() {
        this.mSearchView = (MaterialSearchView)this.findViewById(R.id.search_view);
        this.mSearchView.setOnQueryTextListener((MaterialSearchView.OnQueryTextListener)this);
    }

    protected void cleanContactWithoutNumber(ArrayList<Contact> contactList) {
        ArrayList<Contact> deletes = new ArrayList<Contact>();
        for (Contact c : contactList) {
            if (c.getNumbers().size() != 0) continue;
            deletes.add(c);
        }
        contactList.removeAll(deletes);
    }
}

