/*
 * Decompiled with CFR 0.152.
 */
package com.mobileia.contacts.view.holder;

import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import com.bumptech.glide.request.RequestOptions;
import com.mobileia.contacts.R;
import com.mobileia.contacts.helper.GlideApp;
import jagerfield.mobilecontactslibrary.Contact.Contact;
import jagerfield.mobilecontactslibrary.ElementContainers.NumberContainer;

public class ContactViewHolder
extends RecyclerView.ViewHolder
implements View.OnClickListener {
    public final TextView title;
    public final TextView subtitle;
    public final ImageView image;
    public Contact contact;
    protected OnContactViewHolder mListener;

    public ContactViewHolder(View itemView, OnContactViewHolder listener) {
        super(itemView);
        this.mListener = listener;
        itemView.setOnClickListener((View.OnClickListener)this);
        this.title = (TextView)itemView.findViewById(R.id.text_name);
        this.subtitle = (TextView)itemView.findViewById(R.id.text_data);
        this.image = (ImageView)itemView.findViewById(R.id.image);
    }

    public void onClick(View view) {
        this.mListener.onClickContact(this.contact);
    }

    public void bindContact(Contact c) {
        String photo;
        this.contact = c;
        this.title.setText((CharSequence)c.getDisplaydName());
        if (this.subtitle != null) {
            if (c.getNumbers().size() > 0) {
                this.subtitle.setText((CharSequence)((NumberContainer)c.getNumbers().get(0)).getNormalizedNumber());
            } else {
                this.subtitle.setText((CharSequence)"");
            }
        }
        if ((photo = c.getPhotoUri()) != null && photo.length() > 0) {
            GlideApp.with((View)this.image).load(photo).apply(RequestOptions.circleCropTransform()).into(this.image);
        } else {
            GlideApp.with((View)this.image).load(R.drawable.avatar_one).apply(RequestOptions.circleCropTransform()).into(this.image);
        }
    }

    public static interface OnContactViewHolder {
        public void onClickContact(Contact var1);
    }
}

