/*
 * Decompiled with CFR 0.152.
 */
package com.mobileia.contacts.adapter;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import com.mobileia.contacts.R;
import com.mobileia.contacts.view.holder.ContactViewHolder;
import jagerfield.mobilecontactslibrary.Contact.Contact;
import java.util.ArrayList;

public class BaseContactAdapter
extends RecyclerView.Adapter<ContactViewHolder>
implements ContactViewHolder.OnContactViewHolder {
    public static final int TYPE_NORMAL = 0;
    public static final int TYPE_MINI = 1;
    protected int mType = 0;
    protected ArrayList<Contact> mAll = new ArrayList();
    protected ArrayList<Contact> mFiltered = new ArrayList();
    protected OnContactAdapter mListener = null;

    @Override
    public void onClickContact(Contact contact) {
        if (this.mListener != null) {
            this.mListener.onClickContact(contact);
        }
    }

    public ContactViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        int layout2 = R.layout.item_contact;
        if (this.mType == 1) {
            layout2 = R.layout.item_contact_mini;
        }
        return new ContactViewHolder(LayoutInflater.from((Context)parent.getContext()).inflate(layout2, parent, false), this);
    }

    public void onBindViewHolder(ContactViewHolder holder, int position) {
        holder.bindContact(this.mFiltered.get(position));
    }

    public int getItemCount() {
        return this.mFiltered.size();
    }

    public void loadContacts(ArrayList<Contact> list) {
        this.mAll.addAll(list);
        this.mFiltered.addAll(list);
        this.notifyDataSetChanged();
    }

    public void addContact(Contact c) {
        this.mFiltered.add(c);
        this.notifyDataSetChanged();
    }

    public void filterByQuery(String query) {
        this.mFiltered.clear();
        for (Contact c : this.mAll) {
            if (!c.getDisplaydName().toLowerCase().contains(query.toLowerCase())) continue;
            this.mFiltered.add(c);
        }
        this.notifyDataSetChanged();
    }

    public void clearFilter() {
        this.mFiltered.clear();
        this.mFiltered.addAll(this.mAll);
        this.notifyDataSetChanged();
    }

    public void removeContact(Contact c) {
        this.mFiltered.remove(c);
        this.notifyDataSetChanged();
    }

    public boolean isExist(Contact c) {
        for (Contact attend : this.mFiltered) {
            if (attend.getId() != c.getId()) continue;
            return true;
        }
        return false;
    }

    public ArrayList<Contact> getItems() {
        return this.mFiltered;
    }

    public void setOnClickListener(OnContactAdapter listener) {
        this.mListener = listener;
    }

    public static interface OnContactAdapter {
        public void onClickContact(Contact var1);
    }
}

