/*
 * Decompiled with CFR 0.152.
 */
package com.mks.connect;

import com.mks.api.IntegrationPoint;
import com.mks.api.IntegrationPointFactory;
import com.mks.api.Session;
import com.mks.api.VersionNumber;
import com.mks.api.fedsso.SSOSession;
import com.mks.api.response.APIException;
import com.mks.api.response.InvalidIntegrationPointException;
import com.mks.api.response.fedsso.ConnectionNotSecureException;
import com.mks.api.util.APIVersion;
import com.mks.connect.UserApplicationSSOSessionImpl;
import com.mks.connect.UserApplicationSessionImpl;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.http.client.HttpClient;

public class IntegrationPointImpl
implements IntegrationPoint {
    private VersionNumber apiVersion;
    private String host;
    private int port;
    private boolean isClientIP;
    private Set<Session> sessions;
    private ConcurrentHashMap<SSOSession, SSOSession> ssoSessions;
    private boolean secure;
    private boolean autoStartIC;
    private IntegrationPointFactory ipf;
    private HttpClient httpClient;

    public IntegrationPointImpl(IntegrationPointFactory ipf, HttpClient httpClient, String hostname, int port, boolean secure, VersionNumber apiVersion) {
        this.ipf = ipf;
        this.httpClient = httpClient;
        this.host = hostname;
        this.port = port;
        this.secure = secure;
        this.sessions = new HashSet<Session>();
        this.ssoSessions = new ConcurrentHashMap();
        this.isClientIP = port == 0;
        this.apiVersion = apiVersion;
    }

    @Override
    public VersionNumber getAPIRequestVersion() {
        return this.apiVersion;
    }

    @Override
    public String getHostname() {
        return this.host;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    void setPort(int port) {
        this.port = port;
    }

    @Override
    public boolean isSecure() {
        return this.secure;
    }

    @Override
    public Session createSession() throws APIException {
        return this.createNamedSession(null, null);
    }

    public SSOSession createSSOSession(APIVersion apiRequestVersion) throws APIException {
        if (this.isClientIntegrationPoint()) {
            throw new InvalidIntegrationPointException("Use server integration point.");
        }
        if (!this.isSecure()) {
            throw new ConnectionNotSecureException("Connection is not secure.");
        }
        UserApplicationSSOSessionImpl uas = new UserApplicationSSOSessionImpl(this, this.httpClient, null);
        this.ssoSessions.put(uas, uas);
        return uas;
    }

    @Override
    public Session createNamedSession(String integrationID, VersionNumber overrideRequestVersion) throws APIException {
        return this.createNamedSession(integrationID, overrideRequestVersion, null, null);
    }

    @Override
    public Session createSession(String username, String password) throws APIException {
        return this.createNamedSession(null, null, username, password);
    }

    @Override
    public Session createSession(String username, String password, int apiMajorVersion, int apiMinorVersion) throws APIException {
        return this.createNamedSession(null, new APIVersion(apiMajorVersion, apiMinorVersion), username, password);
    }

    @Override
    public Session createNamedSession(String integrationID, VersionNumber overrideRequestVersion, String username, String password) throws APIException {
        VersionNumber requestVersion = overrideRequestVersion == null ? this.getAPIRequestVersion() : overrideRequestVersion;
        return this.createSession(integrationID, requestVersion, false, username, password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Session createSession(String integrationID, VersionNumber apiRequestVersion, boolean anonymous, String username, String password) throws APIException {
        UserApplicationSessionImpl uas = new UserApplicationSessionImpl(this, this.httpClient, integrationID, apiRequestVersion, username, password, anonymous);
        Set<Session> set = this.sessions;
        synchronized (set) {
            this.sessions.add(uas);
        }
        return uas;
    }

    @Override
    public Session getCommonSession() throws APIException {
        return this.getCommonSession(null, null);
    }

    @Override
    public Session getCommonSession(String username, String password) throws APIException {
        return this.createSession(null, this.getAPIRequestVersion(), true, username, password);
    }

    @Override
    public Iterator<Session> getSessions() {
        return Collections.unmodifiableSet(new HashSet<Session>(this.sessions)).iterator();
    }

    public Iterator<SSOSession> getSSOSessions() {
        return Collections.unmodifiableMap(this.ssoSessions).keySet().iterator();
    }

    @Override
    public boolean getAutoStartIntegrityClient() {
        return this.autoStartIC;
    }

    @Override
    public void setAutoStartIntegrityClient(boolean autoStartIC) {
        this.autoStartIC = autoStartIC;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        Set<Session> set = this.sessions;
        synchronized (set) {
            for (UserApplicationSessionImpl userApplicationSessionImpl : this.sessions) {
                try {
                    userApplicationSessionImpl.release(true, false);
                }
                catch (IOException ex) {
                    IntegrationPointFactory.getLogger().exception(this, "API", 0, (Throwable)ex);
                }
                catch (APIException ex) {
                    IntegrationPointFactory.getLogger().exception(this, "API", 0, (Throwable)ex);
                }
            }
            this.sessions.removeAll(this.sessions);
        }
        this.ipf.removeIntegrationPoint(this);
    }

    public void removeSSOIntegrationPoint() throws APIException {
        if (!this.ssoSessions.isEmpty()) {
            throw new APIException("Failed to release the Integration point. SSO sessions exists.");
        }
        this.ipf.removeIntegrationPoint(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeSession(Session s) {
        Set<Session> set = this.sessions;
        synchronized (set) {
            this.sessions.remove(s);
        }
    }

    protected void removeSSOSession(SSOSession s) {
        this.ssoSessions.remove(s);
    }

    @Override
    public boolean isClientIntegrationPoint() {
        return this.isClientIP;
    }
}

