/*
 * Decompiled with CFR 0.152.
 */
package com.mks.api.util;

import com.mks.api.IntegrationPointFactory;
import com.mks.api.util.MKSLogger;
import org.apache.commons.logging.Log;

public class HttpClientLogAdapter
implements Log {
    private static final String CATEGORY_HTTP = "HTTP";
    private static final String CATEGORY_FATAL = "ERROR";
    private static final int LEVEL_FATAL = 0;
    private static final String CATEGORY_ERROR = "ERROR";
    private static final int LEVEL_ERROR = 0;
    private static final String CATEGORY_WARN = "WARNING";
    private static final int LEVEL_WARN = 5;
    private static final String CATEGORY_INFO = "HTTP";
    private static final int LEVEL_INFO = 0;
    private static final String CATEGORY_DEBUG = "HTTP";
    private static final int LEVEL_DEBUG = 5;
    private static final String CATEGORY_TRACE = "HTTP";
    private static final int LEVEL_TRACE = 10;
    private final MKSLogger apiLogger = IntegrationPointFactory.getLogger();

    public HttpClientLogAdapter(String logName) {
    }

    @Override
    public boolean isFatalEnabled() {
        return this.apiLogger.messageCheck("ERROR", 0);
    }

    @Override
    public void fatal(Object message) {
        this.apiLogger.message("ERROR", 0, this.objectToString(message));
    }

    @Override
    public void fatal(Object message, Throwable throwable) {
        this.fatal(message);
        this.apiLogger.exception("ERROR", 0, throwable);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.apiLogger.messageCheck("ERROR", 0);
    }

    @Override
    public void error(Object message) {
        this.apiLogger.message("ERROR", 0, this.objectToString(message));
    }

    @Override
    public void error(Object message, Throwable throwable) {
        this.error(message);
        this.apiLogger.exception("ERROR", 0, throwable);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.apiLogger.messageCheck(CATEGORY_WARN, 5);
    }

    @Override
    public void warn(Object message) {
        this.apiLogger.message(CATEGORY_WARN, 5, this.objectToString(message));
    }

    @Override
    public void warn(Object message, Throwable throwable) {
        this.warn(message);
        this.apiLogger.exception(CATEGORY_WARN, 5, throwable);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.apiLogger.messageCheck("HTTP", 0);
    }

    @Override
    public void info(Object message) {
        this.apiLogger.message("HTTP", 0, this.objectToString(message));
    }

    @Override
    public void info(Object message, Throwable throwable) {
        this.info(message);
        this.apiLogger.exception("HTTP", 0, throwable);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.apiLogger.messageCheck("HTTP", 5);
    }

    @Override
    public void debug(Object message) {
        this.apiLogger.message("HTTP", 5, this.objectToString(message));
    }

    @Override
    public void debug(Object message, Throwable throwable) {
        this.debug(message);
        this.apiLogger.exception("HTTP", 5, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return this.apiLogger.messageCheck("HTTP", 10);
    }

    @Override
    public void trace(Object message) {
        this.apiLogger.message("HTTP", 10, this.objectToString(message));
    }

    @Override
    public void trace(Object message, Throwable throwable) {
        this.trace(message);
        this.apiLogger.exception("HTTP", 10, throwable);
    }

    private String objectToString(Object object) {
        if (object == null) {
            return "";
        }
        return object.toString();
    }
}

