/*
 * Decompiled with CFR 0.152.
 */
package com.mks.api.util;

import com.mks.api.CmdRunner;
import com.mks.api.IntegrationPoint;
import com.mks.api.IntegrationPointFactory;
import com.mks.api.Session;
import com.mks.api.response.APIException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;

public final class APIViewer {
    private static final String API_PROTOCOL_VERSION = "IntegrityAPI.protocol.version";
    private static final String IS_API_RESPONSE_CACHED = "com.mks.api.response.cache";
    private static final String IS_API_RESPONSE_INTERIM = "com.mks.api.response.interim";
    private static final String IS_API_XML_OUTPUT = "com.mks.api.xml.output";
    private static final String IS_API_RDF_OUTPUT = "com.mks.api.rdf.output";
    private static final String APIVIEWER_CONFIG_FILE = "apiviewer.config.file";
    private static final String IS_API_AUTOCONNECT = "com.mks.api.autoconnect";
    private static final String API_VERSION_MINOR = "com.mks.api.version.minor";
    private static final String API_VERSION_MAJOR = "com.mks.api.version.major";
    private static final String API_DEFAULT_PASSWORD = "com.mks.api.default.password";
    private static final String API_DEFAULT_USERNAME = "com.mks.api.default.username";
    private static final String API_DEFAULT_PORT = "com.mks.api.default.port";
    private static final String API_DEFAULT_HOSTNAME = "com.mks.api.default.hostname";
    private static final String API_SESSION_PASSWORD = "com.mks.api.session.password";
    private static final String API_SESSION_USERNAME = "com.mks.api.session.username";
    private static final String IS_API_SESSION_COMMON = "com.mks.api.session.common";
    private static final String API_INTEGRATION_ID = "com.mks.api.integration.id";
    private static final String API_CALLER_ID = "com.mks.api.caller.id";
    private static final String API_IP_PORT = "com.mks.api.ip.port";
    private static final String IS_API_IP_SECURE = "com.mks.api.ip.secure";
    private static final String API_IP_HOSTNAME = "com.mks.api.ip.hostname";
    private static final String API_VENDOR = "com.mks.api.vendor";

    private CmdRunner createCmdRunner() throws APIException {
        String ipHost = System.getProperty(API_IP_HOSTNAME);
        boolean ipSecure = Boolean.getBoolean(IS_API_IP_SECURE);
        String tmpStr = System.getProperty(API_IP_PORT);
        int ipPort = 0;
        if (tmpStr != null && tmpStr.trim().length() > 0) {
            ipPort = Integer.parseInt(tmpStr);
        }
        String sessionUser = System.getProperty(API_SESSION_USERNAME);
        String sessionPass = System.getProperty(API_SESSION_PASSWORD);
        boolean isCommon = Boolean.getBoolean(IS_API_SESSION_COMMON) && sessionUser == null;
        String defaultHost = System.getProperty(API_DEFAULT_HOSTNAME);
        int defaultPort = 0;
        tmpStr = System.getProperty(API_DEFAULT_PORT);
        if (tmpStr != null && tmpStr.trim().length() > 0) {
            defaultPort = Integer.parseInt(tmpStr);
        }
        String defaultUser = System.getProperty(API_DEFAULT_USERNAME);
        String defaultPass = System.getProperty(API_DEFAULT_PASSWORD);
        int majorVersion = 0;
        int minorVersion = 0;
        tmpStr = System.getProperty(API_VERSION_MAJOR);
        if (tmpStr != null && tmpStr.trim().length() > 0) {
            majorVersion = Integer.parseInt(tmpStr);
        }
        if ((tmpStr = System.getProperty(API_VERSION_MINOR)) != null && tmpStr.trim().length() > 0) {
            minorVersion = Integer.parseInt(tmpStr);
        }
        IntegrationPointFactory ipf = IntegrationPointFactory.getInstance();
        IntegrationPoint ip = null;
        if (ipHost == null) {
            ipHost = "localhost";
        }
        if (ipHost.equals("localhost") && ipPort == 0) {
            ip = ipf.createLocalIntegrationPoint(majorVersion, minorVersion);
        } else {
            if (ipPort == 0) {
                ipPort = 80;
            }
            ip = ipf.createIntegrationPoint(ipHost, ipPort, ipSecure, majorVersion, minorVersion);
            if (defaultHost == null) {
                defaultHost = ipHost;
            }
            if (defaultPort == 0) {
                defaultPort = ipPort;
            }
        }
        String autostartClient = System.getProperty(IS_API_AUTOCONNECT);
        if (autostartClient != null && autostartClient.trim().equalsIgnoreCase("true")) {
            ip.setAutoStartIntegrityClient(true);
        } else {
            ip.setAutoStartIntegrityClient(false);
        }
        Session session = null;
        if (isCommon) {
            session = ip.getCommonSession();
        } else {
            session = ip.createNamedSession(System.getProperty(API_INTEGRATION_ID), null, sessionUser, sessionPass);
            if (defaultUser == null) {
                defaultUser = sessionUser;
            }
            if (defaultPass == null) {
                defaultPass = sessionPass;
            }
        }
        CmdRunner cr = session.createCmdRunner();
        String callerId = System.getProperty(API_CALLER_ID);
        if (callerId != null) {
            cr.setInvocationID(callerId);
        }
        if (defaultHost != null && defaultHost.trim().length() > 0) {
            cr.setDefaultHostname(defaultHost.trim());
        }
        if (defaultPort > 0) {
            cr.setDefaultPort(defaultPort);
        }
        if (defaultUser != null && defaultUser.trim().length() > 0) {
            cr.setDefaultUsername(defaultUser.trim());
        }
        if (defaultPass != null && defaultPass.trim().length() > 0) {
            cr.setDefaultPassword(defaultPass.trim());
        }
        return cr;
    }

    private static String[] extractViewerProperties(String[] utilityArgs) {
        System.setProperty(IS_API_SESSION_COMMON, "true");
        int idx = 0;
        while (idx < utilityArgs.length && utilityArgs[idx].startsWith("--")) {
            String viewerArg;
            String viewerOption = viewerArg = utilityArgs[idx++].substring(2);
            String optionValue = null;
            int equalsPos = viewerArg.indexOf(61);
            if (equalsPos >= 0) {
                viewerOption = viewerArg.substring(0, equalsPos);
                optionValue = viewerArg.substring(equalsPos + 1);
            }
            if (viewerOption.equals("iphostname")) {
                System.setProperty(API_IP_HOSTNAME, optionValue);
                continue;
            }
            if (viewerOption.equals("ipport")) {
                System.setProperty(API_IP_PORT, optionValue);
                continue;
            }
            if (viewerOption.equals("iplocal")) {
                System.setProperty(API_IP_HOSTNAME, "localhost");
                System.setProperty(API_IP_PORT, "0");
                continue;
            }
            if (viewerOption.equals("ipautostart")) {
                System.setProperty(IS_API_AUTOCONNECT, "true");
                continue;
            }
            if (viewerOption.equals("ipversion")) {
                int x = optionValue.indexOf(46);
                System.setProperty(API_VERSION_MAJOR, optionValue.substring(0, x));
                System.setProperty(API_VERSION_MINOR, optionValue.substring(x + 1));
                continue;
            }
            if (viewerOption.equals("ipsecure")) {
                System.setProperty(IS_API_IP_SECURE, "true");
                continue;
            }
            if (viewerOption.equals("responseType")) {
                boolean interim = false;
                boolean cached = true;
                if (optionValue.equals("INTERIM_CACHE")) {
                    interim = true;
                } else if (optionValue.equals("INTERIM_NO_CACHE")) {
                    interim = true;
                    cached = false;
                }
                if (!optionValue.equals("NO_INTERIM")) {
                    APIViewer.showUsage();
                }
                System.setProperty(IS_API_RESPONSE_INTERIM, interim ? "true" : "false");
                System.setProperty(IS_API_RESPONSE_CACHED, cached ? "true" : "false");
                continue;
            }
            if (viewerOption.equals("namedsession")) {
                System.setProperty(IS_API_SESSION_COMMON, "false");
                if (optionValue == null) continue;
                System.setProperty(API_INTEGRATION_ID, optionValue);
                continue;
            }
            if (viewerOption.equals("sessionuser")) {
                System.setProperty(API_SESSION_USERNAME, optionValue);
                continue;
            }
            if (viewerOption.equals("sessionpassword")) {
                System.setProperty(API_SESSION_PASSWORD, optionValue);
                continue;
            }
            if (viewerOption.equals("xml")) {
                System.setProperty(IS_API_XML_OUTPUT, "true");
                continue;
            }
            if (viewerOption.equals("rdf")) {
                System.setProperty(IS_API_RDF_OUTPUT, "true");
                continue;
            }
            if (viewerOption.equals("defaulthostname")) {
                System.setProperty(API_DEFAULT_HOSTNAME, optionValue);
                continue;
            }
            if (viewerOption.equals("defaultport")) {
                System.setProperty(API_DEFAULT_PORT, optionValue);
                continue;
            }
            if (viewerOption.equals("defaultuser")) {
                System.setProperty(API_DEFAULT_USERNAME, optionValue);
                continue;
            }
            if (viewerOption.equals("defaultpassword")) {
                System.setProperty(API_DEFAULT_PASSWORD, optionValue);
                continue;
            }
            if (viewerOption.equals("protocolversion")) {
                System.setProperty(API_PROTOCOL_VERSION, optionValue);
                continue;
            }
            if (viewerOption.equals("vendor")) {
                System.setProperty(API_VENDOR, optionValue);
                continue;
            }
            if (viewerOption.equals("namedrunner")) {
                System.setProperty(API_CALLER_ID, optionValue);
                continue;
            }
            if (!viewerOption.equals("help")) {
                System.out.println("Invalid viewer option: --" + viewerOption + "\n");
            }
            APIViewer.showUsage();
        }
        if (idx == utilityArgs.length || utilityArgs[idx].equals("-?")) {
            APIViewer.showUsage();
        }
        String[] cmdArgs = new String[utilityArgs.length - idx];
        for (int i = idx; i < utilityArgs.length; ++i) {
            cmdArgs[i - idx] = utilityArgs[i];
        }
        return cmdArgs;
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            APIViewer.showUsage();
        }
        try {
            File f;
            String cf = System.getProperty(APIVIEWER_CONFIG_FILE);
            File file = f = cf != null ? new File(cf) : null;
            if (f != null) {
                if (!f.exists() || !f.canRead()) {
                    System.out.println("Cannot open configuration file: " + f);
                    System.exit(1);
                }
                Properties p = new Properties(System.getProperties());
                p.load(new FileInputStream(f));
                System.setProperties(p);
            }
        }
        catch (IOException ex) {
            System.out.println("Could not load the configuration file.");
            System.out.println(ex.getMessage());
            ex.printStackTrace();
        }
        catch (IllegalArgumentException ex) {
            System.out.println("Could not load the configuration file.");
            System.out.println(ex.getMessage());
            ex.printStackTrace();
        }
        String[] cmdArgs = APIViewer.extractViewerProperties(args);
        new APIViewer().viewCommandExecution(cmdArgs);
    }

    private static void showUsage() {
        System.out.println("Syntax:\njava -Dapiviewer.config.file=<Configuration File> " + APIViewer.class.getCanonicalName() + " \\");
        System.out.println("\t[APIViewer options] \\\n\t<Integrity Application> <Integrity Application Command> [options] [selection]");
        System.out.println("\n where [APIViewer options] are:\n");
        System.out.println("\t--iphostname=<host name>");
        System.out.println("\t--ipport=<port>");
        System.out.println("\t--iplocal");
        System.out.println("\t--ipautostart (--iplocal must be specified)");
        System.out.println("\t--ipversion=<major>.<minor> (optional api request version)");
        System.out.println("\t--ipsecure (observed only if --iplocal is not specified)");
        System.out.println("\t--sessionuser=<username>");
        System.out.println("\t--sessionpassword=<password>");
        System.out.println("\t--xml (optional)");
        System.out.println("\t--protocolversion=<major>.<minor> (optional api protocol version)");
        System.out.println("\t--responsetype=<NO_INTERIM|INTERIM_CACHE|INTERIM_NO_CACHE>");
        System.out.println("\t--defaulthostname=<hostname> (optional)");
        System.out.println("\t--defaultport=<port> (optional)");
        System.out.println("\t--defaultuser=<username> (optional)");
        System.out.println("\t--defaultpassword=<password> (optional)");
        System.out.println("\t--defaultimpersonateduser=<username> (optional)");
        System.out.println("\t--vendor=<vendorname> (optional)");
        System.out.println("\t--help (display this message and exit)");
        System.exit(1);
    }

    /*
     * Exception decompiling
     */
    private void viewCommandExecution(String[] cmdArgs) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

