/*
 * Decompiled with CFR 0.152.
 */
package com.mks.api.fedsso.ssotests;

import com.mks.api.Command;
import com.mks.api.IntegrationPointFactory;
import com.mks.api.Option;
import com.mks.api.fedsso.SSOCmdRunner;
import com.mks.api.fedsso.SSOSession;
import com.mks.api.fedsso.ssotests.SSOTestException;
import com.mks.api.fedsso.ssotests.TestCaseID;
import com.mks.api.response.APIConnectionException;
import com.mks.api.response.APIException;
import com.mks.api.response.ApplicationRuntimeException;
import com.mks.api.response.InterruptedException;
import com.mks.api.response.InvalidCommandRunnerStateException;
import com.mks.api.response.InvalidIntegrationPointException;
import com.mks.api.response.Response;
import com.mks.api.response.WorkItemIterator;
import com.mks.api.response.fedsso.ConnectionNotSecureException;
import com.mks.api.response.fedsso.InvalidTokenConnectFailedException;
import com.mks.api.response.fedsso.InvalidTokenExecutionIncompleteException;
import com.mks.api.util.APIVersion;
import com.mks.api.util.ResponseUtil;
import com.mks.connect.IntegrationPointImpl;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import junit.framework.Assert;

public class JavaAPISSOTest {
    private static String apiIPHostname = "localhost";
    private static int apiIPPort = 0;
    private static final APIVersion API_VERSION = APIVersion.API_4_16;
    private static String oAuthToken = null;
    private static String oAuthToken1 = null;
    private static int testCase = 0;
    private final String VALIDPROJECT_TESTPOINT_CLASS = "mks.ic.si.commands.ValidProjectSpecified";
    private final String ADDPROJECT_TESTPOINT_CLASS = "mks.ic.common.ui.xml.XMLBlimpIO";
    private final String VALIDPROJECT_TESTPOINT_METHOD = "satisfy";
    private final String ADDPROJECT_TESTPOINT_METHOD = "readBlimpFile";
    private final String TESTPOINT_TYPE = "sleep";
    private final String TESTPOINT_COUNT = "1";
    private final String TESTPOINT_ARG = "120";
    private static IntegrationPointImpl clientIP = null;
    private static IntegrationPointImpl serverIP = null;
    private static SSOSession ssoSession = null;

    public static void initTestEnvironment() throws SSOTestException {
        try {
            clientIP = (IntegrationPointImpl)IntegrationPointFactory.getInstance().createLocalIntegrationPoint(API_VERSION);
            serverIP = (IntegrationPointImpl)IntegrationPointFactory.getInstance().createIntegrationPoint(apiIPHostname, apiIPPort, true, API_VERSION);
        }
        catch (APIException e) {
            e.setMessage("Failed to create Integration Point");
            throw new SSOTestException(e);
        }
    }

    public static void releaseTestEnvironment(String token) throws SSOTestException {
        try {
            if (ssoSession != null) {
                Iterator<SSOCmdRunner> cmdRunners = ssoSession.getCmdRunners();
                while (cmdRunners.hasNext()) {
                    SSOCmdRunner cmdRunner = cmdRunners.next();
                    cmdRunner.release(token);
                }
                ssoSession.release(token);
            }
            if (clientIP != null) {
                clientIP.release();
                clientIP = null;
            }
            if (serverIP != null) {
                serverIP.removeSSOIntegrationPoint();
                serverIP = null;
            }
        }
        catch (APIException e) {
            throw new SSOTestException(e);
        }
        catch (IOException e) {
            throw new SSOTestException(e);
        }
    }

    private static Response executeCommand(String[] cmd, String token) throws APIException, SSOTestException {
        Response response = null;
        try {
            ssoSession = serverIP.createSSOSession(null);
            SSOCmdRunner cmdRunner = ssoSession.createCmdRunner(token);
            response = cmdRunner.execute(cmd);
        }
        catch (APIException e) {
            throw e;
        }
        finally {
            JavaAPISSOTest.releaseTestEnvironment(token);
        }
        return response;
    }

    @TestCaseID(value=5782904)
    private void testSSOSessionWithValidToken(String ... cmdArgs) throws SSOTestException {
        try {
            Response response = JavaAPISSOTest.executeCommand(new String[]{"api", "ping"}, oAuthToken);
            Assert.assertNotNull((String)"Did expect response", (Object)response);
            Assert.assertNull((String)"Did not expect any exception", (Object)response.getAPIException());
            Assert.assertEquals((Object)API_VERSION, (Object)response.getAPIVersion());
        }
        catch (APIException e) {
            throw new SSOTestException(e);
        }
    }

    @TestCaseID(value=6130270)
    private void testSSOSessionWithInvalidToken(String ... cmdArgs) throws SSOTestException {
        try {
            String token = "invalidtoken";
            JavaAPISSOTest.executeCommand(new String[]{"api", "ping"}, token);
            Assert.fail((String)"Did not expect response");
        }
        catch (APIException e) {
            Assert.assertTrue((boolean)(e instanceof InvalidTokenConnectFailedException));
        }
    }

    @TestCaseID(value=6130272)
    private void testSSOSessionWithExpiredToken(String ... cmdArgs) throws SSOTestException {
        try {
            JavaAPISSOTest.executeCommand(new String[]{"api", "ping"}, oAuthToken);
            Assert.fail((String)"Did not expect response");
        }
        catch (APIException e) {
            Assert.assertTrue((boolean)(e instanceof InvalidTokenConnectFailedException));
        }
    }

    @TestCaseID(value=6130274)
    private void testSSOSessionWithNullToken(String ... cmdArgs) throws SSOTestException {
        try {
            String token = null;
            JavaAPISSOTest.executeCommand(new String[]{"api", "ping"}, token);
            Assert.fail((String)"Did not expect response");
        }
        catch (APIException e) {
            Assert.assertTrue((boolean)(e instanceof InvalidTokenConnectFailedException));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestCaseID(value=6263979)
    private void testCreateSSOSessionOnNonSecureConnection(String ... cmdArgs) throws SSOTestException {
        try {
            serverIP = (IntegrationPointImpl)IntegrationPointFactory.getInstance().createIntegrationPoint(apiIPHostname, apiIPPort, false, API_VERSION);
            ssoSession = serverIP.createSSOSession(null);
            Assert.fail((String)"Did not expect ssoSession");
        }
        catch (APIException e) {
            Assert.assertTrue((boolean)(e instanceof ConnectionNotSecureException));
        }
        finally {
            JavaAPISSOTest.releaseTestEnvironment(oAuthToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestCaseID(value=6263982)
    private void testCreateSSOSessionWithClientIP(String ... cmdArgs) throws SSOTestException {
        try {
            ssoSession = clientIP.createSSOSession(null);
            Assert.fail((String)"Did not expect ssoSession");
        }
        catch (APIException e) {
            Assert.assertTrue((boolean)(e instanceof InvalidIntegrationPointException));
        }
        finally {
            JavaAPISSOTest.releaseTestEnvironment(oAuthToken);
        }
    }

    @TestCaseID(value=6264018)
    private void testSSOSessionOnNonFedSSOScheme(String ... cmdArgs) throws SSOTestException {
        try {
            JavaAPISSOTest.executeCommand(new String[]{"im", "connect"}, oAuthToken);
            Assert.fail((String)"Did not expect response");
        }
        catch (APIException e) {
            Assert.assertTrue((boolean)(e instanceof ApplicationRuntimeException));
        }
    }

    @TestCaseID(value=6368826)
    private void testReleaseSSOSessionWithInvalidToken(String ... cmdArgs) throws SSOTestException {
        SSOCmdRunner cmdRunner = null;
        try {
            ssoSession = serverIP.createSSOSession(null);
            cmdRunner = ssoSession.createCmdRunner(oAuthToken);
            Response response = cmdRunner.execute(new String[]{"im", "connect"});
            Assert.assertNotNull((Object)response);
            Assert.assertNull((Object)response.getAPIException());
            cmdRunner.release(oAuthToken);
            try {
                ssoSession.release("invalidToken");
                Assert.fail((String)"Expecting exception");
            }
            catch (APIException e) {
                Assert.assertTrue((boolean)(e instanceof InvalidTokenConnectFailedException));
            }
            Iterator<SSOSession> ssoSessions = serverIP.getSSOSessions();
            Assert.assertNotNull(ssoSessions);
            Assert.assertTrue((boolean)ssoSessions.next().equals(ssoSession));
        }
        catch (APIException e) {
            throw new SSOTestException(e);
        }
        catch (IOException e) {
            throw new SSOTestException(e);
        }
        finally {
            JavaAPISSOTest.releaseTestEnvironment(oAuthToken);
        }
    }

    @TestCaseID(value=6368879)
    private void testExecuteCommandOnReleasedCmdRunner(String ... cmdArgs) throws SSOTestException {
        try {
            ssoSession = serverIP.createSSOSession(null);
            SSOCmdRunner cmdRunner = ssoSession.createCmdRunner(oAuthToken);
            Response response = cmdRunner.execute(new String[]{"im", "connect"});
            Assert.assertNotNull((Object)response);
            Assert.assertNull((Object)response.getAPIException());
            cmdRunner.release(oAuthToken);
            Iterator<SSOCmdRunner> cmdRunners = ssoSession.getCmdRunners();
            Assert.assertFalse((boolean)cmdRunners.hasNext());
            try {
                cmdRunner.execute(new String[]{"im", "connect"});
            }
            catch (APIException e1) {
                Assert.assertTrue((boolean)(e1 instanceof InvalidCommandRunnerStateException));
            }
        }
        catch (APIException e) {
            throw new SSOTestException(e);
        }
        finally {
            JavaAPISSOTest.releaseTestEnvironment(oAuthToken);
        }
    }

    @TestCaseID(value=6264004)
    private void testRemoveIPFails(String ... cmdArgs) throws SSOTestException {
        SSOCmdRunner cmdRunner = null;
        try {
            ssoSession = serverIP.createSSOSession(null);
            cmdRunner = ssoSession.createCmdRunner(oAuthToken);
            Response response = cmdRunner.execute(new String[]{"api", "ping"});
            Assert.assertNotNull((Object)response);
            Assert.assertNull((String)"Did not expect any exception", (Object)response.getAPIException());
            Assert.assertEquals((Object)API_VERSION, (Object)response.getAPIVersion());
            try {
                serverIP.removeSSOIntegrationPoint();
                Assert.fail((String)"Expecting exception.");
            }
            catch (APIException e) {
                Assert.assertTrue((boolean)e.getMessage().equals("Failed to release the Integration point. SSO sessions exists."));
            }
        }
        catch (APIException e) {
            throw new SSOTestException(e);
        }
        finally {
            JavaAPISSOTest.releaseTestEnvironment(oAuthToken);
        }
    }

    @TestCaseID(value=6264014)
    private void testDifferentValidTokensForSameUser(String ... cmdArgs) throws SSOTestException {
        try {
            ssoSession = serverIP.createSSOSession(null);
            SSOCmdRunner cmdRunner = ssoSession.createCmdRunner(oAuthToken);
            SSOCmdRunner cmdRunner1 = ssoSession.createCmdRunner(oAuthToken1);
            Response response = cmdRunner.execute(new String[]{"api", "ping"});
            Assert.assertNotNull((Object)response);
            Assert.assertNull((Object)response.getAPIException());
            Assert.assertEquals((Object)API_VERSION, (Object)response.getAPIVersion());
            Response response1 = cmdRunner1.execute(new String[]{"api", "ping"});
            Assert.assertNotNull((Object)response1);
            Assert.assertNull((Object)response.getAPIException());
            Assert.assertEquals((Object)API_VERSION, (Object)response1.getAPIVersion());
        }
        catch (APIException e) {
            throw new SSOTestException(e);
        }
        finally {
            JavaAPISSOTest.releaseTestEnvironment(oAuthToken);
        }
    }

    @TestCaseID(value=6164149)
    private void testDifferentValidTokensFromDifferentUsers(String ... cmdArgs) throws SSOTestException {
        SSOCmdRunner cmdRunner = null;
        SSOCmdRunner cmdRunner1 = null;
        try {
            ssoSession = serverIP.createSSOSession(null);
            cmdRunner = ssoSession.createCmdRunner(oAuthToken);
            cmdRunner1 = ssoSession.createCmdRunner(oAuthToken1);
            Response response = cmdRunner.execute(new String[]{"api", "ping"});
            Assert.assertNotNull((Object)response);
            Assert.assertNull((Object)response.getAPIException());
            Assert.assertEquals((Object)API_VERSION, (Object)response.getAPIVersion());
            try {
                cmdRunner1.execute(new String[]{"api", "ping"});
                Assert.fail((String)"Expecting exception.");
            }
            catch (APIException e) {
                Assert.assertTrue((boolean)(e instanceof APIConnectionException));
            }
        }
        catch (APIException e) {
            throw new SSOTestException(e);
        }
        finally {
            JavaAPISSOTest.releaseTestEnvironment(oAuthToken);
        }
    }

    @TestCaseID(value=6284883)
    private void testExecuteWithInterim(String ... cmdArgs) throws SSOTestException {
        try {
            ssoSession = serverIP.createSSOSession(null);
            SSOCmdRunner cmdRunner = ssoSession.createCmdRunner(oAuthToken);
            Response response = cmdRunner.executeWithInterim(new String[]{"api", "ping"}, false);
            Assert.assertNotNull((Object)response);
            Assert.assertNull((String)"Did not expect any exception", (Object)response.getAPIException());
            Assert.assertEquals((Object)API_VERSION, (Object)response.getAPIVersion());
            if (!cmdRunner.isFinished()) {
                cmdRunner.interrupt(oAuthToken);
            }
        }
        catch (APIException e) {
            throw new SSOTestException(e);
        }
        finally {
            JavaAPISSOTest.releaseTestEnvironment(oAuthToken);
        }
    }

    @TestCaseID(value=6284909)
    private void testLongRunningOperation(String ... cmdArgs) throws SSOTestException {
        try {
            Command cmd;
            SSOSession ssoSession = serverIP.createSSOSession(null);
            SSOCmdRunner cmdRunner = ssoSession.createCmdRunner(oAuthToken);
            String topProject = this.createProject(cmdRunner);
            try {
                cmd = this.getTestPoint("mks.ic.si.commands.ValidProjectSpecified", "satisfy", "sleep", "1", "120");
                cmdRunner.execute(cmd);
            }
            catch (APIException e1) {
                System.out.println("Attaching test point failed. ");
                throw e1;
            }
            cmd = new Command("si", "projectinfo");
            cmd.addOption(new Option("P", topProject));
            Response response = cmdRunner.execute(cmd);
            Assert.assertNotNull((Object)response);
            Assert.assertNull((Object)response.getAPIException());
            Assert.assertNotNull((Object)response.getWorkItems());
            try {
                cmdRunner.release(oAuthToken);
                ssoSession.release(oAuthToken);
                Assert.fail((String)"Expecting exception.");
            }
            catch (APIException e) {
                Assert.assertTrue((boolean)(e instanceof InvalidTokenConnectFailedException));
            }
            catch (IOException e1) {
                throw new SSOTestException(e1);
            }
        }
        catch (APIException e) {
            throw new SSOTestException(e);
        }
    }

    @TestCaseID(value=6366750)
    private void testSubsequentHTTPRequests(String ... cmdArgs) throws SSOTestException {
        try {
            SSOSession ssoSession = serverIP.createSSOSession(null);
            SSOCmdRunner cmdRunner = ssoSession.createCmdRunner(oAuthToken);
            String topProject = this.createProject(cmdRunner);
            try {
                Command cmd = this.getTestPoint("mks.ic.common.ui.xml.XMLBlimpIO", "readBlimpFile", "sleep", "1", "120");
                cmdRunner.execute(cmd);
            }
            catch (APIException e1) {
                System.out.println("Attaching test point failed. ");
                throw e1;
            }
            String tempFile = null;
            try {
                tempFile = System.getProperty("java.io.tmpdir") + "\\member.txt";
                File f = new File(tempFile);
                f.createNewFile();
            }
            catch (Exception e) {
                System.out.println("File creation failed.");
                throw new SSOTestException(e);
            }
            Command cmd = new Command("si", "projectadd");
            cmd.addOption(new Option("sourceFile", "remote://\\" + tempFile));
            cmd.addSelection("member");
            cmd.addOption(new Option("P", topProject));
            try {
                cmdRunner.execute(cmd);
                Assert.fail((String)"Expecting exception");
            }
            catch (APIException e) {
                Assert.assertTrue((boolean)(e instanceof InvalidTokenExecutionIncompleteException));
            }
        }
        catch (APIException e) {
            throw new SSOTestException(e);
        }
    }

    @TestCaseID(value=6264021)
    public void releaseIntegrityConnection(String ... cmdArgs) throws SSOTestException {
        try {
            ssoSession = serverIP.createSSOSession(null);
            SSOCmdRunner cmdRunner = ssoSession.createCmdRunner(oAuthToken);
            Response serversBeforeCmd = ssoSession.createCmdRunner(oAuthToken).execute(new String[]{"im", "servers"});
            Assert.assertNotNull((String)"Did expect response", (Object)serversBeforeCmd);
            Assert.assertNull((String)"Did not expect any exception", (Object)serversBeforeCmd.getAPIException());
            Assert.assertEquals((Object)API_VERSION, (Object)serversBeforeCmd.getAPIVersion());
            WorkItemIterator wiServersBeforeCmd = serversBeforeCmd.getWorkItems();
            Assert.assertFalse((boolean)wiServersBeforeCmd.hasNext());
            Response response = cmdRunner.execute(new String[]{"im", "connect"});
            Assert.assertNotNull((String)"Did expect response", (Object)response);
            Assert.assertNull((String)"Did not expect any exception", (Object)response.getAPIException());
            Assert.assertEquals((Object)API_VERSION, (Object)response.getAPIVersion());
            Response serversInCmd = ssoSession.createCmdRunner(oAuthToken).execute(new String[]{"im", "servers"});
            Assert.assertNotNull((String)"Did expect response", (Object)serversInCmd);
            Assert.assertNull((String)"Did not expect any exception", (Object)serversInCmd.getAPIException());
            Assert.assertEquals((Object)API_VERSION, (Object)serversInCmd.getAPIVersion());
            WorkItemIterator wiServersInCmd = serversInCmd.getWorkItems();
            Assert.assertTrue((boolean)wiServersInCmd.hasNext());
            cmdRunner.release(oAuthToken);
            ssoSession.release(oAuthToken);
            serverIP.removeSSOIntegrationPoint();
            Response serversAfterCmd = ssoSession.createCmdRunner(oAuthToken).execute(new String[]{"im", "servers"});
            Assert.assertNotNull((String)"Did expect response", (Object)serversAfterCmd);
            Assert.assertNull((String)"Did not expect any exception", (Object)serversAfterCmd.getAPIException());
            Assert.assertEquals((Object)API_VERSION, (Object)serversAfterCmd.getAPIVersion());
            WorkItemIterator wiServersAfterCmd = serversAfterCmd.getWorkItems();
            Assert.assertFalse((boolean)wiServersAfterCmd.hasNext());
        }
        catch (APIException e) {
            throw new SSOTestException(e);
        }
        catch (IOException e) {
            throw new SSOTestException(e);
        }
        finally {
            JavaAPISSOTest.releaseTestEnvironment(oAuthToken);
        }
    }

    @TestCaseID(value=-1)
    private void executeProvidedCommand(String ... cmdArgs) throws SSOTestException {
        try {
            ssoSession = serverIP.createSSOSession(null);
            SSOCmdRunner cmdRunner = ssoSession.createCmdRunner(oAuthToken);
            Response response = cmdRunner.execute(cmdArgs);
            ResponseUtil.printResponse(response, 1, System.out);
        }
        catch (APIException e) {
            throw new SSOTestException(e);
        }
        finally {
            JavaAPISSOTest.releaseTestEnvironment(oAuthToken);
        }
    }

    private Command getTestPoint(String testClass, String method, String type, String count, String args) throws SSOTestException {
        Command cmd = new Command("si", "diag");
        cmd.addOption(new Option("diag", "invokemethod"));
        cmd.addOption(new Option("target", "server"));
        cmd.addSelection("mks.frame.diag.TestPoint");
        cmd.addSelection("setTest");
        cmd.addSelection(testClass);
        cmd.addSelection(method);
        cmd.addSelection(type);
        cmd.addSelection(count);
        cmd.addSelection(args);
        return cmd;
    }

    private String createProject(SSOCmdRunner cmdRunner) {
        Command cmdCreatePro = new Command("si", "createproject");
        String topProject = "/Top" + System.currentTimeMillis() + "/project.pj";
        cmdCreatePro.addSelection(topProject);
        Response response = null;
        try {
            response = cmdRunner.execute(cmdCreatePro);
        }
        catch (APIException e) {
            System.out.println("Project creation failed. ");
            e.printStackTrace();
        }
        Assert.assertNotNull((Object)response);
        try {
            Assert.assertNull((Object)response.getAPIException());
        }
        catch (InterruptedException e) {
            System.out.println("Project creation failed. ");
            e.printStackTrace();
        }
        return topProject;
    }

    private static String[] extractProperties(String[] utilityArgs) {
        int idx = 0;
        while (idx < utilityArgs.length && utilityArgs[idx].startsWith("--")) {
            String viewerArg;
            String viewerOption = viewerArg = utilityArgs[idx++].substring(2);
            String optionValue = null;
            int equalsPos = viewerArg.indexOf(61);
            if (equalsPos >= 0) {
                viewerOption = viewerArg.substring(0, equalsPos);
                optionValue = viewerArg.substring(equalsPos + 1);
            }
            if (viewerOption.equals("iphostname")) {
                apiIPHostname = optionValue;
                continue;
            }
            if (viewerOption.equals("ipport")) {
                apiIPPort = Integer.parseInt(optionValue);
                continue;
            }
            if (viewerOption.equals("token")) {
                oAuthToken = optionValue;
                continue;
            }
            if (viewerOption.equals("token1")) {
                oAuthToken1 = optionValue;
                continue;
            }
            if (viewerOption.equals("testcase")) {
                testCase = Integer.parseInt(optionValue);
                continue;
            }
            if (!viewerOption.equals("help")) {
                System.out.println("Invalid viewer option: --" + viewerOption + "\n");
            }
            JavaAPISSOTest.showUsage();
        }
        if (testCase == 0) {
            testCase = -1;
        }
        if (utilityArgs[idx - 1].equals("-?")) {
            JavaAPISSOTest.showUsage();
        }
        String[] cmdArgs = null;
        if (idx != utilityArgs.length) {
            cmdArgs = new String[utilityArgs.length - idx];
            for (int i = idx; i < utilityArgs.length; ++i) {
                cmdArgs[i - idx] = utilityArgs[i];
            }
            return cmdArgs;
        }
        return cmdArgs;
    }

    public static void main(String[] args) throws SSOTestException {
        if (args.length < 2) {
            JavaAPISSOTest.showUsage();
        }
        String[] cmdArgs = JavaAPISSOTest.extractProperties(args);
        try {
            Class<?> c = Class.forName("com.mks.api.fedsso.ssotests.JavaAPISSOTest");
            Object t = c.newInstance();
            Method[] methods = c.getDeclaredMethods();
            boolean isTestCase = false;
            JavaAPISSOTest.initTestEnvironment();
            for (Method method : methods) {
                TestCaseID annotation = method.getAnnotation(TestCaseID.class);
                if (annotation == null || annotation.value() != testCase) continue;
                method.invoke(t, new Object[]{cmdArgs});
                isTestCase = true;
            }
            if (!isTestCase) {
                System.out.println("Invalid Test Case " + testCase);
            } else {
                System.out.println("Test executed successfully.");
            }
        }
        catch (ClassNotFoundException x) {
            x.printStackTrace();
        }
        catch (IllegalAccessException x) {
            x.printStackTrace();
        }
        catch (InstantiationException x) {
            x.printStackTrace();
        }
        catch (InvocationTargetException x) {
            x.printStackTrace();
        }
    }

    private static void showUsage() {
        System.out.println("\t[JavaAPISSOTest options] \\\n\t<Integrity Application> <Integrity Application Command> [options] [selection]");
        System.out.println("\n where [JavaAPISSOTest options] are:\n");
        System.out.println("\t--iphostname=<host name>");
        System.out.println("\t--ipport=<port>");
        System.out.println("\t--testcase=<TestCaseID>");
        System.out.println("\t--token=<OAuthToken>");
        System.out.println("\t--token1=<OAuthToken1>");
        System.out.println("\t--help (display this message and exit)");
        System.exit(1);
    }
}

