/*
 * Decompiled with CFR 0.152.
 */
package com.mks.api.commands.ide;

import com.mks.api.CmdRunnerCreator;
import com.mks.api.commands.SICommands;
import com.mks.api.commands.ide.SandboxInfo;
import com.mks.api.commands.ide.WorkingDirectory;
import com.mks.api.commands.ide.WorkingFile;
import com.mks.api.commands.ide.WorkingFileCache;
import com.mks.api.commands.ide.WorkingFileFactory;
import com.mks.api.response.APIException;
import com.mks.api.response.WorkItem;
import com.mks.api.response.WorkItemIterator;
import java.io.File;
import java.util.HashSet;

public final class WorkingDirectoryFactory {
    private WorkingDirectoryFactory() {
    }

    public static WorkingDirectory getWorkingDirectory(CmdRunnerCreator session, WorkingFile wf, boolean register) throws APIException {
        return WorkingDirectoryFactory.getWorkingDirectory(session, wf.isMember() ? wf.getMemberName().getParentFile() : wf.getFile().getParentFile(), register);
    }

    public static WorkingDirectory getWorkingDirectory(CmdRunnerCreator session, File directory, boolean register) throws APIException {
        SICommands si = new SICommands(session, false);
        String directoryPath = directory.getAbsolutePath();
        WorkingDirectory workingDirectory = new WorkingDirectory(directory);
        try {
            SandboxInfo info = SandboxInfo.getSandboxInfo(si, directory);
            if (info != null) {
                workingDirectory.addSandbox(info);
                if (register) {
                    WorkingFileCache.getInstance().monitorSandbox(si.getCmdRunnerCreator(), info.getSandboxFile());
                }
            }
            return workingDirectory;
        }
        catch (APIException ex) {
            if (!"common.AmbiguousParentSandbox".equals(ex.getExceptionId())) {
                throw ex;
            }
            HashSet<String> closestSandboxes = null;
            File closestSandboxDir = null;
            String directoryTestPath = directoryPath;
            if (WorkingDirectoryFactory.isWin32()) {
                directoryTestPath = directoryTestPath.toLowerCase();
            }
            WorkItemIterator wii = si.getSandboxes(true).getWorkItems();
            while (wii.hasNext()) {
                int closestSandboxPathLength;
                WorkItem wi = wii.next();
                String sandboxName = wi.getField("sandboxName").getValueAsString();
                File sandboxLocation = new File(sandboxName).getParentFile();
                String testPath = sandboxLocation.getAbsolutePath();
                if (WorkingDirectoryFactory.isWin32()) {
                    testPath = testPath.toLowerCase();
                }
                int n = closestSandboxPathLength = closestSandboxDir != null ? closestSandboxDir.getPath().length() : 0;
                if (testPath.length() > closestSandboxPathLength && directoryTestPath.startsWith(testPath)) {
                    closestSandboxDir = sandboxLocation;
                    closestSandboxes = new HashSet<String>();
                }
                if (!sandboxLocation.equals(closestSandboxDir)) continue;
                closestSandboxes.add(sandboxName);
            }
            if (closestSandboxes != null) {
                for (String sandboxName : closestSandboxes) {
                    SandboxInfo info = SandboxInfo.getSandboxInfo(si, new File(sandboxName));
                    if (info == null) continue;
                    workingDirectory.addSandbox(info);
                }
            }
            WorkingFileCache.getInstance().monitorDirectory(si.getCmdRunnerCreator(), workingDirectory);
            return workingDirectory;
        }
    }

    static boolean isWin32() {
        return WorkingFileFactory.isWin32();
    }

    public static void invalidate(File directory) {
        WorkingDirectoryFactory.invalidate(directory, WorkingFileFactory.getNewOrdinal());
    }

    public static void invalidate(File directory, long ordinal) {
        WorkingFileCache.getInstance().invalidate(directory, ordinal);
    }
}

