/*
 * Decompiled with CFR 0.152.
 */
package com.mks.api.commands;

import com.mks.api.CmdRunnerCreator;
import com.mks.api.commands.SIAddCommand;
import com.mks.api.commands.WFTrackCommandBase;
import com.mks.api.commands.ide.WorkingFile;
import com.mks.api.commands.ide.WorkingFileList;
import com.mks.api.response.APIException;
import com.mks.api.response.Response;
import java.util.Iterator;

class WFTrackNewFile
extends WFTrackCommandBase {
    private boolean neverExpandKeywords = false;
    private boolean binary;

    WFTrackNewFile(CmdRunnerCreator session, boolean binary, boolean neverExpandKeywords) throws APIException {
        this(session, binary);
        this.neverExpandKeywords = neverExpandKeywords;
    }

    WFTrackNewFile(CmdRunnerCreator session, boolean binary) throws APIException {
        super(session);
        this.binary = binary;
    }

    WFTrackNewFile(CmdRunnerCreator session) throws APIException {
        this(session, false);
    }

    @Override
    protected Response execute(WorkingFileList workingFiles) throws APIException {
        Response r;
        WorkingFileList toBeAdded = new WorkingFileList();
        WorkingFileList toBeReverted = new WorkingFileList();
        Iterator<WorkingFile> iWorkingFiles = workingFiles.iterator();
        while (iWorkingFiles.hasNext()) {
            WorkingFile wf = iWorkingFiles.next();
            if (!wf.isInSandboxDir() || wf.isSandbox() || wf.isAdded()) continue;
            if (wf.isControlled() && !wf.isFormerMember() && wf.isDropped()) {
                toBeReverted.add(wf);
                continue;
            }
            if (wf.isMember()) continue;
            toBeAdded.add(wf);
        }
        if (!toBeReverted.isEmpty() && (r = this.revertDeferred(toBeReverted)) != null && r.getAPIException() != null) {
            return r;
        }
        if (!toBeAdded.isEmpty()) {
            SIAddCommand siAdd = new SIAddCommand(this.getCmdRunnerCreator());
            siAdd.setDeferred(true);
            siAdd.setCpid(this.cpid);
            siAdd.setBinary(this.binary);
            siAdd.setCloseCP(false);
            siAdd.setAllowCreateSubs(this.allowCreateSubs);
            Response[] response = null;
            response = this.runApiCommand(siAdd, toBeAdded, this.interactive);
            for (int j = 0; j < response.length; ++j) {
                if (response[j] == null || response[j].getAPIException() == null) continue;
                return response[j];
            }
        }
        return null;
    }
}

