/*
 * Decompiled with CFR 0.152.
 */
package com.mks.api.commands;

import com.mks.api.CmdRunnerCreator;
import com.mks.api.Option;
import com.mks.api.OptionList;
import com.mks.api.commands.GenericWFCommandRunner;
import com.mks.api.commands.SILockCommand;
import com.mks.api.commands.SIMoveCPEntryCommand;
import com.mks.api.commands.SIUnlockCommand;
import com.mks.api.commands.WFTrackCommandBase;
import com.mks.api.commands.WFTrackDeletedFile;
import com.mks.api.commands.WFTrackMovedFile;
import com.mks.api.commands.WFTrackNewFile;
import com.mks.api.commands.ide.SandboxInfo;
import com.mks.api.commands.ide.WorkingFile;
import com.mks.api.commands.ide.WorkingFileList;
import com.mks.api.response.APIException;
import com.mks.api.response.Response;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

class WFTrackMoveToChangePackage
extends WFTrackCommandBase {
    private static final String CPENTRYTYPE_EXCLUSIVE_LOCK = "exclusivelock:deferred";
    private static final String CPENTRYTYPE_NONEXCLUSIVE_LOCK = "nonexclusivelock:deferred";
    private static final String CPENTRYTYPE_RENAME = "rename:deferred";
    private static final String CPENTRYTYPE_MOVE = "movemember:deferred";
    private static final String CPENTRYTYPE_ADD = "add:deferred";
    private static final String CPENTRYTYPE_DROP = "drop:deferred";
    private Map<File, SandboxInfo> localSandboxCache = new HashMap<File, SandboxInfo>();

    WFTrackMoveToChangePackage(CmdRunnerCreator session) throws APIException {
        super(session);
    }

    @Override
    protected Response execute(WorkingFileList workingFiles) throws APIException {
        WorkingFileList toBeReverted = new WorkingFileList();
        WorkingFileList toBeAdded = new WorkingFileList();
        WorkingFileList toBeDropped = new WorkingFileList();
        WorkingFileList toBeMoved = new WorkingFileList();
        WorkingFileList toBeUnlocked = new WorkingFileList();
        WorkingFileList toBeLocked = new WorkingFileList();
        WorkingFileList addsToBeMoved = new WorkingFileList();
        WorkingFileList dropsToBeMoved = new WorkingFileList();
        WorkingFileList movesToBeMoved = new WorkingFileList();
        WorkingFileList renamesToBeMoved = new WorkingFileList();
        WorkingFileList nonExclusiveLocksToBeMoved = new WorkingFileList();
        WorkingFileList exclusiveLocksToBeMoved = new WorkingFileList();
        if (this.cpid == null) {
            this.cpid = ":none";
        }
        Iterator<WorkingFile> i = workingFiles.iterator();
        while (i.hasNext()) {
            WorkingFile wf = i.next();
            if (this.cpid.equals(wf.getWorkingCpidOrNone())) continue;
            if (!wf.isControlled() && wf.getFile().exists()) {
                toBeAdded.add(wf);
                continue;
            }
            if (!":none".equals(this.cpid) && wf.isChangePackageValid() && !wf.isNullCP()) {
                if (wf.isAdded()) {
                    addsToBeMoved.add(wf);
                }
                if (wf.isDropped()) {
                    dropsToBeMoved.add(wf);
                }
                if (wf.isMoved()) {
                    movesToBeMoved.add(wf);
                }
                if (wf.isRenamed()) {
                    renamesToBeMoved.add(wf);
                }
                if (wf.isExclusiveLockByMe()) {
                    exclusiveLocksToBeMoved.add(wf);
                    continue;
                }
                if (!wf.isLockedByMe()) continue;
                nonExclusiveLocksToBeMoved.add(wf);
                continue;
            }
            if (wf.isAdded()) {
                toBeReverted.add(wf);
                toBeAdded.add(wf);
            }
            if (!wf.getFile().exists() || wf.isDropped()) {
                toBeReverted.add(wf);
                toBeDropped.add(wf);
            }
            if (wf.isMoved() || wf.isRenamed()) {
                throw new APIException("INVALID_MOVE_TO_CP_OPERATION");
            }
            if (wf.isLockedByMe()) {
                toBeUnlocked.add(wf);
            }
            if (wf.isDropped() || !wf.isModified() && !wf.isLockedByMe()) continue;
            toBeLocked.add(wf);
        }
        Response r = null;
        r = this.moveAdds(addsToBeMoved);
        if (r != null && r.getAPIException() != null) {
            return r;
        }
        r = this.moveDrops(dropsToBeMoved);
        if (r != null && r.getAPIException() != null) {
            return r;
        }
        r = this.moveMoves(movesToBeMoved);
        if (r != null && r.getAPIException() != null) {
            return r;
        }
        r = this.moveRenames(renamesToBeMoved);
        if (r != null && r.getAPIException() != null) {
            return r;
        }
        r = this.moveExclusiveLocks(exclusiveLocksToBeMoved);
        if (r != null && r.getAPIException() != null) {
            return r;
        }
        r = this.moveNonExclusiveLocks(nonExclusiveLocksToBeMoved);
        if (r != null && r.getAPIException() != null) {
            return r;
        }
        r = this.revertDeferred(toBeReverted);
        if (r != null && r.getAPIException() != null) {
            return r;
        }
        r = this.unlockFiles(toBeUnlocked);
        if (r != null && r.getAPIException() != null) {
            return r;
        }
        r = this.dropFiles(toBeDropped);
        if (r != null && r.getAPIException() != null) {
            return r;
        }
        r = this.addFiles(toBeAdded);
        if (r != null && r.getAPIException() != null) {
            return r;
        }
        r = this.moveFiles(toBeMoved);
        if (r != null && r.getAPIException() != null) {
            return r;
        }
        r = this.lockFiles(toBeLocked);
        if (r != null && r.getAPIException() != null) {
            return r;
        }
        return null;
    }

    private final String convertWorkingFileToSIMoveCPEntrySelection(CmdRunnerCreator session, String cpEntryType, WorkingFile wf) throws APIException {
        SandboxInfo sandbox;
        StringBuffer sb = new StringBuffer(cpEntryType);
        sb.append(":");
        if (wf.getMemberSandbox().equals(wf.getSandboxFile())) {
            sandbox = wf.getSandboxInfo();
            this.localSandboxCache.put(sandbox.getSandboxFile(), sandbox);
        } else {
            sandbox = this.localSandboxCache.get(wf.getMemberSandbox());
            if (sandbox == null) {
                sandbox = SandboxInfo.getSandboxInfo(session, wf.getMemberSandbox());
                this.localSandboxCache.put(sandbox.getSandboxFile(), sandbox);
            }
        }
        StringBuffer closestProject = cpEntryType.equals(CPENTRYTYPE_EXCLUSIVE_LOCK) || cpEntryType.equals(CPENTRYTYPE_NONEXCLUSIVE_LOCK) ? new StringBuffer(sandbox.getReferredProject().replace('\\', '/')) : new StringBuffer(sandbox.getProject().replace('\\', '/'));
        int i = closestProject.indexOf(":");
        while (i != -1) {
            closestProject.insert(i, "\\");
            i = closestProject.indexOf(":", i + 2);
        }
        sb.append(closestProject.toString());
        sb.append(":");
        sb.append(wf.getSandboxInfo().getDevPath() == null ? "" : wf.getSandboxInfo().getDevPath());
        sb.append(":");
        sb.append(wf.getMemberNameRelative());
        sb.append(":");
        sb.append(wf.getWorkingRev() == null ? "1.1" : wf.getWorkingRev());
        return sb.toString();
    }

    private final Response executeSIMoveCPEntry(String cpEntryType, WorkingFileList workingFilesToBeMoved) throws APIException {
        if (workingFilesToBeMoved.isEmpty()) {
            return null;
        }
        CmdRunnerCreator cmdRunner = this.getCmdRunnerCreator();
        OptionList options = new OptionList();
        options.add(new Option("moveEntriesEnclosingDeferred"));
        options.add(new Option("noConfirmCascade"));
        Iterator<WorkingFile> i = workingFilesToBeMoved.iterator();
        ArrayList<Response> responses = new ArrayList<Response>();
        while (i.hasNext()) {
            WorkingFile wf = i.next();
            if (!wf.isInSandboxDir()) continue;
            SIMoveCPEntryCommand siMoveCPEntry = new SIMoveCPEntryCommand(wf.getWorkingCpid(), this.cpid, cmdRunner);
            siMoveCPEntry.addOptionList(options);
            responses.add(siMoveCPEntry.execute(this.convertWorkingFileToSIMoveCPEntrySelection(cmdRunner, cpEntryType, wf), this.interactive));
        }
        Response r = null;
        for (int j = 0; j < responses.size(); ++j) {
            r = (Response)responses.get(j);
            if (r == null || r.getAPIException() == null) continue;
            return r;
        }
        return null;
    }

    private final Response moveExclusiveLocks(WorkingFileList exclusiveLocksToBeMoved) throws APIException {
        return this.executeSIMoveCPEntry(CPENTRYTYPE_EXCLUSIVE_LOCK, exclusiveLocksToBeMoved);
    }

    private final Response moveNonExclusiveLocks(WorkingFileList nonExclusiveLocksToBeMoved) throws APIException {
        return this.executeSIMoveCPEntry(CPENTRYTYPE_NONEXCLUSIVE_LOCK, nonExclusiveLocksToBeMoved);
    }

    private final Response moveRenames(WorkingFileList renamesToBeMoved) throws APIException {
        return this.executeSIMoveCPEntry(CPENTRYTYPE_RENAME, renamesToBeMoved);
    }

    private final Response moveMoves(WorkingFileList movesToBeMoved) throws APIException {
        return this.executeSIMoveCPEntry(CPENTRYTYPE_MOVE, movesToBeMoved);
    }

    private final Response moveAdds(WorkingFileList addsToBeMoved) throws APIException {
        return this.executeSIMoveCPEntry(CPENTRYTYPE_ADD, addsToBeMoved);
    }

    private final Response moveDrops(WorkingFileList dropsToBeMoved) throws APIException {
        return this.executeSIMoveCPEntry(CPENTRYTYPE_DROP, dropsToBeMoved);
    }

    private Response dropFiles(WorkingFileList toBeDropped) throws APIException {
        if (toBeDropped.isEmpty()) {
            return null;
        }
        WFTrackDeletedFile wfDeleted = new WFTrackDeletedFile(this.getCmdRunnerCreator());
        wfDeleted.setCpid(this.cpid);
        try {
            return wfDeleted.execute(this.update(toBeDropped), this.interactive);
        }
        catch (APIException ex) {
            if (!ex.getExceptionId().equals("si.CPPolicy")) {
                throw ex;
            }
            for (WorkingFile file : toBeDropped.getList()) {
                file.getFile().delete();
            }
            return null;
        }
    }

    private Response addFiles(WorkingFileList toBeAdded) throws APIException {
        if (toBeAdded.isEmpty()) {
            return null;
        }
        WFTrackNewFile wfNew = new WFTrackNewFile(this.getCmdRunnerCreator());
        wfNew.setCpid(this.cpid);
        wfNew.setPreferredRoot(this.getPreferredRoot());
        try {
            return wfNew.execute(this.update(toBeAdded), this.interactive);
        }
        catch (APIException ex) {
            if (!ex.getExceptionId().equals("si.CPPolicy")) {
                throw ex;
            }
            return null;
        }
    }

    private Response moveFiles(WorkingFileList toBeMoved) throws APIException {
        if (toBeMoved.isEmpty()) {
            return null;
        }
        Response response = null;
        Iterator<WorkingFile> it = toBeMoved.iterator();
        while (it.hasNext()) {
            WorkingFile wf = it.next();
            WFTrackMovedFile wfMoved = new WFTrackMovedFile(this.getCmdRunnerCreator());
            wfMoved.setCpid(this.cpid);
            wfMoved.setPreferredRoot(this.getPreferredRoot());
            wfMoved.setNewName(wf.getFile().getAbsolutePath());
            response = wfMoved.execute(new WorkingFileList(new WorkingFile[]{wf}), this.interactive);
            if (response == null || response.getAPIException() == null) continue;
            return response;
        }
        return response;
    }

    private Response unlockFiles(WorkingFileList toBeUnlocked) throws APIException {
        if (toBeUnlocked.isEmpty()) {
            return null;
        }
        SIUnlockCommand siUnlock = new SIUnlockCommand(this.getCmdRunnerCreator());
        siUnlock.setAction("remove");
        GenericWFCommandRunner wfUnlock = new GenericWFCommandRunner(this.getCmdRunnerCreator(), siUnlock);
        return wfUnlock.execute(toBeUnlocked, this.interactive);
    }

    private Response lockFiles(WorkingFileList toBeLocked) throws APIException {
        String workingRev;
        if (toBeLocked.isEmpty()) {
            return null;
        }
        ArrayList<WorkingFile> outOfDate = new ArrayList<WorkingFile>();
        ArrayList<WorkingFile> upToDate = new ArrayList<WorkingFile>(toBeLocked.getList());
        Iterator it = upToDate.iterator();
        while (it.hasNext()) {
            WorkingFile wf = (WorkingFile)it.next();
            workingRev = wf.getField("workingRev").getValueAsString();
            String memberRev = wf.getField("memberRev").getValueAsString();
            if (memberRev == null || memberRev.equals(workingRev)) continue;
            outOfDate.add(wf);
            it.remove();
        }
        for (WorkingFile wf : outOfDate) {
            workingRev = wf.getField("workingRev").getValueAsString();
            this.lockFile(wf, workingRev);
        }
        if (upToDate.isEmpty()) {
            return null;
        }
        SILockCommand siLock = new SILockCommand(this.getCmdRunnerCreator());
        siLock.setCpid(this.cpid);
        siLock.setAllowPrompting(false);
        GenericWFCommandRunner wfLock = new GenericWFCommandRunner(this.getCmdRunnerCreator(), siLock);
        try {
            WorkingFile[] wfArray = new WorkingFile[upToDate.size()];
            return wfLock.execute(new WorkingFileList(upToDate.toArray(wfArray)), this.interactive);
        }
        catch (APIException ex) {
            if (!ex.getExceptionId().equals("si.CPPolicy")) {
                throw ex;
            }
            return null;
        }
    }

    private Response lockFile(WorkingFile wf, String workingRev) throws APIException {
        if (wf == null) {
            return null;
        }
        SILockCommand siLock = new SILockCommand(this.getCmdRunnerCreator());
        siLock.setCpid(this.cpid);
        siLock.setAllowPrompting(false);
        siLock.setRevision(workingRev);
        GenericWFCommandRunner wfLock = new GenericWFCommandRunner(this.getCmdRunnerCreator(), siLock);
        try {
            WorkingFileList toBeLocked = new WorkingFileList();
            toBeLocked.add(wf);
            return wfLock.execute(toBeLocked, this.interactive);
        }
        catch (APIException ex) {
            if (!ex.getExceptionId().equals("si.CPPolicy")) {
                throw ex;
            }
            return null;
        }
    }
}

