/*
 * Decompiled with CFR 0.152.
 */
package com.mks.api.commands;

import com.mks.api.CmdRunnerCreator;
import com.mks.api.Command;
import com.mks.api.Option;
import com.mks.api.OptionList;
import com.mks.api.SelectionList;
import com.mks.api.commands.TrackingCommandBase;
import com.mks.api.response.APIException;
import com.mks.api.response.InvalidCommandSelectionException;
import com.mks.api.response.Response;

class SIMoveCPEntryCommand
extends TrackingCommandBase {
    private final String targetCP;

    SIMoveCPEntryCommand(String currentCP, String targetCP, CmdRunnerCreator session) throws APIException {
        super(session);
        if (currentCP == null || currentCP.length() == 0 || targetCP == null || targetCP.length() == 0) {
            throw new APIException(new IllegalArgumentException());
        }
        this.setCpid(currentCP);
        this.targetCP = targetCP;
    }

    @Override
    protected Response execute(SelectionList selection) throws APIException {
        if (selection == null || selection.size() != 1) {
            throw new InvalidCommandSelectionException("The SI MoveCPEntry command requires a single selection.");
        }
        Command myCommand = new Command("si", "movecpentry");
        OptionList options = this.getBaseOptions();
        options.add(this.getTrackableCommandOptions());
        if (this.interactive) {
            options.add(new Option("gui"));
        }
        options.add(new Option("noConfirm"));
        options.add(new Option("targetcpid", this.targetCP));
        myCommand.setOptionList(options);
        myCommand.setSelectionList(selection);
        return this.runAPICommand(myCommand);
    }
}

