/*
 * Decompiled with CFR 0.152.
 */
package com.mks.api.commands;

import com.mks.api.CmdRunnerCreator;
import com.mks.api.Command;
import com.mks.api.Option;
import com.mks.api.commands.MKSCommands;
import com.mks.api.response.APIException;
import com.mks.api.response.Field;
import com.mks.api.response.InvalidCommandOptionException;
import com.mks.api.response.InvalidCommandSelectionException;
import com.mks.api.response.Item;
import com.mks.api.response.Response;
import com.mks.api.response.Result;
import com.mks.api.response.WorkItem;
import com.mks.api.response.WorkItemIterator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class IMCommands
extends MKSCommands {
    public IMCommands(CmdRunnerCreator session) throws APIException {
        super(session);
    }

    public void imConnect() throws APIException {
        Command cmd = new Command("im", "connect");
        cmd.addOption(new Option("g"));
        this.runAPICommand(cmd);
    }

    public void imEditIssue(int issueId) throws APIException {
        Command cmd = new Command("im", "editissue");
        cmd.addOption(new Option("g"));
        String issue = String.valueOf(issueId);
        if (issue == null || issue.length() <= 0) {
            throw new InvalidCommandSelectionException("IMCommands.imEditIssue: parameter 'issueId' is invalid.");
        }
        cmd.addSelection(issue);
        this.runAPICommand(cmd);
    }

    public void imViewIssue(int issueId) throws APIException {
        this.imViewIssue(issueId, false);
    }

    public void imViewIssue(int issueId, boolean tviGui) throws APIException {
        String issue;
        Command cmd = new Command("im", "viewissue");
        cmd.addOption(new Option("g"));
        if (tviGui) {
            cmd.addOption(new Option("tvigui"));
        }
        if ((issue = String.valueOf(issueId)) == null || issue.length() <= 0) {
            throw new InvalidCommandSelectionException("IMCommands.imViewIssue: parameter 'issueId' is invalid.");
        }
        cmd.addSelection(issue);
        this.runAPICommand(cmd);
    }

    public void imViewDocument(int documentId) throws APIException {
        this.imViewDocument(documentId, false);
    }

    public void imViewDocument(int documentId, boolean tviGui) throws APIException {
        String issue;
        Command cmd = new Command("im", "viewsegment");
        cmd.addOption(new Option("g"));
        if (tviGui) {
            cmd.addOption(new Option("tvigui"));
        }
        if ((issue = String.valueOf(documentId)) == null || issue.length() <= 0) {
            throw new InvalidCommandSelectionException("IMCommands.imViewDocument: parameter 'documentId' is invalid.");
        }
        cmd.addSelection(issue);
        this.runAPICommand(cmd);
    }

    public String imCreateIssue() throws APIException {
        String newIssueid = "";
        Command cmd = new Command("im", "createissue");
        cmd.addOption(new Option("g"));
        Response response = this.runAPICommand(cmd);
        Result result = null;
        Item item = null;
        if (response != null) {
            result = response.getResult();
        }
        if (result != null) {
            item = result.getPrimaryValue();
        }
        if (item != null) {
            newIssueid = item.getId();
        }
        return newIssueid;
    }

    public void imCopyIssue(int issueId) throws APIException {
        Command cmd = new Command("im", "copyissue");
        cmd.addOption(new Option("g"));
        cmd.addOption(new Option("link"));
        cmd.addOption(new Option("copyfields"));
        String issue = String.valueOf(issueId);
        if (issue == null || issue.length() <= 0) {
            throw new InvalidCommandSelectionException("IMCommands.imCopyIssue: parameter 'issueId' is invalid.");
        }
        cmd.addSelection(issue);
        this.runAPICommand(cmd);
    }

    public void imViewCP(String cpId) throws APIException {
        if (cpId == null || cpId.length() == 0) {
            throw new InvalidCommandSelectionException("IMCommands.imViewCP: parameter 'cpId' cannot be null or empty.");
        }
        Command cmd = new Command("im", "viewcp");
        cmd.addOption(new Option("g"));
        cmd.addSelection(cpId);
        this.runAPICommand(cmd);
    }

    public String[] imGetQueries() throws APIException {
        String[] result = new String[]{};
        Command cmd = new Command("im", "queries");
        cmd.addOption(new Option("showVisibleOnly"));
        cmd.addOption(new Option("fields", "name"));
        cmd.addOption(new Option("settingsUI", "gui"));
        Response response = this.runAPICommand(cmd);
        result = new String[response.getWorkItemListSize()];
        int index = 0;
        WorkItemIterator it = response.getWorkItems();
        while (it.hasNext()) {
            result[index] = it.next().getField("name").getValueAsString();
            ++index;
        }
        return result;
    }

    public String[] imGetQueryFields(String query) throws APIException {
        String[] result = new String[]{};
        Command cmd = new Command("im", "queries");
        cmd.addOption(new Option("showVisibleOnly"));
        cmd.addOption(new Option("fields", "fields"));
        cmd.addOption(new Option("settingsUI", "gui"));
        if (query != null & query.length() > 0) {
            cmd.addSelection(query);
        }
        Response response = null;
        try {
            response = this.runAPICommand(cmd);
            WorkItem wi = response.getWorkItem(query);
            Field columns = wi.getField("fields");
            List list = columns.getList();
            result = new String[list.size()];
            Iterator it = list.iterator();
            int index = 0;
            while (it.hasNext()) {
                result[index] = ((Item)it.next()).getId();
                ++index;
            }
        }
        catch (NoSuchElementException nsee) {
            // empty catch block
        }
        return result;
    }

    public String[] imGetColumnSets() throws APIException {
        String[] result = new String[]{};
        Command cmd = new Command("im", "columnsets");
        cmd.addOption(new Option("fields", "name"));
        cmd.addOption(new Option("settingsUI", "gui"));
        Response response = this.runAPICommand(cmd);
        WorkItemIterator it = response.getWorkItems();
        result = new String[response.getWorkItemListSize()];
        int i = 0;
        while (it.hasNext()) {
            result[i] = it.next().getField("name").getValueAsString();
            ++i;
        }
        return result;
    }

    public String[] imGetColumnsetFields(String columnset) throws APIException {
        String[] result;
        block4: {
            result = new String[]{};
            Command cmd = new Command("im", "viewcolumnset");
            cmd.addOption(new Option("settingsUI", "gui"));
            if (columnset != null & columnset.length() > 0) {
                cmd.addSelection(columnset);
            }
            Response response = null;
            try {
                response = this.runAPICommand(cmd);
                WorkItem wi = response.getWorkItem(columnset);
                Field columns = wi.getField("fields");
                List list = columns.getList();
                result = new String[list.size()];
                Iterator it = list.iterator();
                int index = 0;
                while (it.hasNext()) {
                    result[index] = ((Item)it.next()).getId();
                    ++index;
                }
            }
            catch (NoSuchElementException nsee) {
                if (columnset.equalsIgnoreCase("default")) break block4;
                result = this.imGetColumnsetFields("default");
            }
        }
        return result;
    }

    public void launchMKSGUI() throws APIException {
        Command cmd = new Command("im", "gui");
        this.runAPICommand(cmd);
    }

    public WorkItem[] imGetIssuesViewContents(String query, String[] fields) throws APIException {
        if (query == null || query.length() == 0) {
            throw new InvalidCommandOptionException("IMCommands.imGetIssuesViewContents: parameter 'query' cannot be null or empty.");
        }
        if (fields == null || fields.length == 0) {
            throw new InvalidCommandOptionException("IMCommands.imGetIssuesViewContents: parameter 'fields' cannot be null or empty.");
        }
        WorkItem[] issues = new WorkItem[]{};
        Command cmd = new Command("im", "issues");
        cmd.addOption(new Option("settingsUI", "gui"));
        cmd.addOption(new Option("query", query));
        StringBuffer fieldsValue = new StringBuffer();
        for (int i = 0; i < fields.length; ++i) {
            String field = fields[i];
            if (fieldsValue.length() > 0) {
                fieldsValue.append(",");
            }
            fieldsValue.append(field);
        }
        cmd.addOption(new Option("fields", fieldsValue.toString()));
        Response response = this.runAPICommand(cmd);
        issues = new WorkItem[response.getWorkItemListSize()];
        int index = 0;
        WorkItemIterator items = response.getWorkItems();
        while (items.hasNext()) {
            issues[index] = items.next();
            ++index;
        }
        return issues;
    }

    public WorkItem[] imGetImplementerCPViewContents(int issueId) throws APIException {
        WorkItem[] cps = new WorkItem[]{};
        Command cmd = new Command("im", "viewcp");
        cmd.addOption(new Option("filter", "type:implementer"));
        String issue = String.valueOf(issueId);
        if (issue == null || issue.length() <= 0) {
            throw new InvalidCommandSelectionException("IMCommands.imGetImplementerCPViewContents: parameter 'issueId' is invalid.");
        }
        cmd.addSelection(issue);
        Response response = this.runAPICommand(cmd);
        cps = new WorkItem[response.getWorkItemListSize()];
        int index = 0;
        WorkItemIterator items = response.getWorkItems();
        while (items.hasNext()) {
            cps[index] = items.next();
            ++index;
        }
        return cps;
    }
}

