/*
 * Decompiled with CFR 0.152.
 */
package com.mks.api;

import com.mks.api.IntegrationPoint;
import com.mks.api.VersionNumber;
import com.mks.api.response.APIException;
import com.mks.api.response.APIExceptionFactory;
import com.mks.api.response.InvalidHostException;
import com.mks.api.util.APIVersion;
import com.mks.api.util.MKSLogger;
import com.mks.connect.IntegrationPointImpl;
import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.NoSuchAlgorithmException;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.SSLContext;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;

public class IntegrationPointFactory {
    private static final String API_IMP_VERSION_MSG = "Integrity API Implementation Version: {0}";
    private static final String INVALID_HOST_ERROR_MSG = "Invalid hostname: {0}";
    private static final String CREATE_IP_MSG = "Creating an IntegrationPoint to: {0}:{1,number,#} (Secure = {2})";
    private static final String IP_ADD_ERROR_MSG = "IntegrationPoint not added to the set";
    private MKSLogger apiLogger;
    private Set<IntegrationPoint> points;
    private Map<VersionNumber, IntegrationPoint> localPoints = null;
    private final AtomicReference<CloseableHttpClient> httpClient = new AtomicReference();
    private static IntegrationPointFactory instance;

    private IntegrationPointFactory() {
        this.points = new HashSet<IntegrationPoint>();
        this.initLogger();
        try {
            String msg = MessageFormat.format(API_IMP_VERSION_MSG, APIVersion.getAPIReleaseVersion());
            this.apiLogger.message(this, "API", 10, msg);
        }
        catch (Throwable t) {
            this.apiLogger.exception("DEBUG", 10, t);
        }
        boolean debugHTTP = Boolean.getBoolean("IntegrityAPI.log.HTTP");
        if (debugHTTP) {
            this.apiLogger.message("API", "Logging http from HTTPClient");
            System.setProperty("org.apache.commons.logging.Log", "com.mks.api.util.HttpClientLogAdapter");
            System.setProperty("org.apache.commons.logging.simplelog.showdatetime", "true");
            System.setProperty("org.apache.commons.logging.simplelog.log.org.apache.http.wire", "debug");
            System.setProperty("org.apache.commons.logging.simplelog.log.org.apache.http", "debug");
        }
    }

    private CloseableHttpClient getHttpClient() {
        CloseableHttpClient client = this.httpClient.get();
        if (client == null && !this.httpClient.compareAndSet(null, client = this.createHttpClient())) {
            client = this.httpClient.get();
        }
        return client;
    }

    private CloseableHttpClient createHttpClient() {
        SSLContext sslContext;
        try {
            sslContext = SSLContext.getDefault();
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException(ex);
        }
        SSLConnectionSocketFactory tlsSocketFactory = new SSLConnectionSocketFactory(sslContext, new String[]{"TLSv1"}, null, SSLConnectionSocketFactory.getDefaultHostnameVerifier());
        Registry<ConnectionSocketFactory> connectionSocketFactoryRegistry = RegistryBuilder.create().register("http", PlainConnectionSocketFactory.INSTANCE).register("https", (PlainConnectionSocketFactory)((Object)tlsSocketFactory)).build();
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager(connectionSocketFactoryRegistry);
        connectionManager.setDefaultMaxPerRoute(Integer.MAX_VALUE);
        connectionManager.setMaxTotal(Integer.MAX_VALUE);
        this.scheduleConnectionEviction(connectionManager);
        RequestConfig requestConfig = RequestConfig.custom().setRedirectsEnabled(false).setSocketTimeout(0).setCookieSpec("netscape").build();
        CloseableHttpClient client = HttpClients.custom().setDefaultRequestConfig(requestConfig).setConnectionManager(connectionManager).build();
        return client;
    }

    private void scheduleConnectionEviction(final HttpClientConnectionManager connectionManager) {
        Runnable runnable = new Runnable(){

            @Override
            public synchronized void run() {
                try {
                    while (true) {
                        this.wait(10000L);
                        connectionManager.closeIdleConnections(30L, TimeUnit.SECONDS);
                    }
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
            }
        };
        Thread thread = new Thread(runnable);
        thread.setDaemon(true);
        thread.start();
    }

    private void initLogger() {
        File logFile;
        String logFileName;
        Enumeration<?> en = System.getProperties().propertyNames();
        boolean logEnabled = false;
        while (en.hasMoreElements()) {
            String str = (String)en.nextElement();
            if (!str.startsWith("IntegrityAPI.logging.")) continue;
            logEnabled = true;
            break;
        }
        if ((logFileName = System.getProperty("IntegrityAPI.log.filename")) == null || logFileName.trim().length() == 0) {
            logFileName = "mksapi.log";
        }
        if (!(logFile = new File(logFileName)).isAbsolute()) {
            logFile = new File(System.getProperty("java.io.tmpdir"), logFileName);
        }
        this.apiLogger = new MKSLogger(logFile.getAbsolutePath());
        if (logEnabled) {
            this.apiLogger.configure(System.getProperties());
        }
    }

    public static synchronized void enableAPILogging(File logFile) {
        String[] logCategories;
        if (instance != null) {
            throw new IllegalStateException();
        }
        System.setProperty("IntegrityAPI.log.filename", logFile.getAbsolutePath());
        for (String logCategory : logCategories = new String[]{"API", "ERROR", "GENERAL", "WARNING"}) {
            String messageProperty = "IntegrityAPI.logging.message.includeCategory." + logCategory;
            String exceptionProperty = "IntegrityAPI.logging.exception.includeCategory." + logCategory;
            if (System.getProperty(messageProperty) == null) {
                System.setProperty(messageProperty, Integer.toString(0));
            }
            if (System.getProperty(exceptionProperty) != null) continue;
            System.setProperty(exceptionProperty, Integer.toString(0));
        }
    }

    public static synchronized IntegrationPointFactory getInstance() {
        if (instance == null) {
            instance = new IntegrationPointFactory();
        }
        return instance;
    }

    public static MKSLogger getLogger() {
        return IntegrationPointFactory.getInstance().apiLogger;
    }

    public IntegrationPoint createLocalIntegrationPoint(int apiMajorVersion, int apiMinorVersion) throws APIException {
        return this.createLocalIntegrationPoint(new APIVersion(apiMajorVersion, apiMinorVersion));
    }

    public IntegrationPoint createLocalIntegrationPoint(VersionNumber apiRequestVersion) throws APIException {
        return this.createIntegrationPoint("127.0.0.1", 0, apiRequestVersion);
    }

    public IntegrationPoint createIntegrationPoint(String host, int port, int apiMajorVersion, int apiMinorVersion) throws APIException {
        return this.createIntegrationPoint(host, port, new APIVersion(apiMajorVersion, apiMinorVersion));
    }

    public IntegrationPoint createIntegrationPoint(String host, int port, VersionNumber apiRequestVersion) throws APIException {
        return this.createIntegrationPoint(host, port, false, apiRequestVersion);
    }

    public synchronized IntegrationPoint createIntegrationPoint(String host, int port, boolean secure, int apiMajorVersion, int apiMinorVersion) throws APIException {
        return this.createIntegrationPoint(host, port, secure, new APIVersion(apiMajorVersion, apiMinorVersion));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized IntegrationPoint createIntegrationPoint(String host, int port, boolean secure, VersionNumber apiRequestVersion) throws APIException {
        String msg = MessageFormat.format(CREATE_IP_MSG, host, new Integer(port), new Boolean(secure));
        this.apiLogger.message(this, "API", 10, msg);
        try {
            InetAddress.getByName(host);
        }
        catch (UnknownHostException ex) {
            msg = MessageFormat.format(INVALID_HOST_ERROR_MSG, host);
            this.apiLogger.message(this, "API", 0, msg);
            throw new InvalidHostException(msg);
        }
        if (port == 0) {
            IntegrationPoint localPoint;
            if (this.localPoints == null) {
                this.localPoints = new HashMap<VersionNumber, IntegrationPoint>();
            }
            if ((localPoint = this.localPoints.get(apiRequestVersion)) == null) {
                localPoint = new IntegrationPointImpl(this, this.getHttpClient(), host, port, secure, apiRequestVersion);
                this.localPoints.put(apiRequestVersion, localPoint);
            }
            return localPoint;
        }
        IntegrationPointImpl ip = new IntegrationPointImpl(this, this.getHttpClient(), host, port, secure, apiRequestVersion);
        Set<IntegrationPoint> set = this.points;
        synchronized (set) {
            if (!this.points.add(ip)) {
                msg = IP_ADD_ERROR_MSG;
                this.apiLogger.message(this, "API", 0, msg);
                APIExceptionFactory.createAPIException("APIInternalError", msg);
            }
            return ip;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeIntegrationPoint(IntegrationPoint ip) {
        boolean release = false;
        if (ip.isClientIntegrationPoint()) {
            release = this.localPoints.remove(ip.getAPIRequestVersion()) != null;
        } else {
            Set<IntegrationPoint> set = this.points;
            synchronized (set) {
                release = this.points.contains(ip);
                if (release) {
                    this.points.remove(ip);
                }
            }
        }
        if (release) {
            ip.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<IntegrationPoint> getIntegrationPoints() {
        HashSet<IntegrationPoint> s = null;
        Set<IntegrationPoint> set = this.points;
        synchronized (set) {
            s = new HashSet<IntegrationPoint>(this.points);
        }
        if (this.localPoints != null) {
            s.addAll(this.localPoints.values());
        }
        return s.iterator();
    }
}

