/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.mixpanelapi;

import com.mixpanel.mixpanelapi.Base64Coder;
import com.mixpanel.mixpanelapi.ClientDelivery;
import com.mixpanel.mixpanelapi.MixpanelMessageException;
import com.mixpanel.mixpanelapi.MixpanelServerException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MixpanelAPI {
    private static final int BUFFER_SIZE = 256;
    private static final int CONNECT_TIMEOUT_MILLIS = 2000;
    private static final int READ_TIMEOUT_MILLIS = 10000;
    private final String mEventsEndpoint;
    private final String mPeopleEndpoint;

    public MixpanelAPI() {
        this("https://api.mixpanel.com/track", "https://api.mixpanel.com/engage");
    }

    public MixpanelAPI(String eventsEndpoint, String peopleEndpoint) {
        this.mEventsEndpoint = eventsEndpoint;
        this.mPeopleEndpoint = peopleEndpoint;
    }

    public void sendMessage(JSONObject message) throws MixpanelMessageException, IOException {
        ClientDelivery delivery = new ClientDelivery();
        delivery.addMessage(message);
        this.deliver(delivery);
    }

    public void deliver(ClientDelivery toSend) throws IOException {
        this.deliver(toSend, false);
    }

    public void deliver(ClientDelivery toSend, boolean useIpAddress) throws IOException {
        String ipParameter = "ip=0";
        if (useIpAddress) {
            ipParameter = "ip=1";
        }
        String eventsUrl = this.mEventsEndpoint + "?" + ipParameter;
        List<JSONObject> events = toSend.getEventsMessages();
        this.sendMessages(events, eventsUrl);
        String peopleUrl = this.mPeopleEndpoint + "?" + ipParameter;
        List<JSONObject> people = toSend.getPeopleMessages();
        this.sendMessages(people, peopleUrl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean sendData(String dataString, String endpointUrl) throws IOException {
        byte[] utf8data;
        URL endpoint = new URL(endpointUrl);
        URLConnection conn = endpoint.openConnection();
        conn.setReadTimeout(10000);
        conn.setConnectTimeout(2000);
        conn.setDoOutput(true);
        conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded;charset=utf8");
        try {
            utf8data = dataString.getBytes("utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Mixpanel library requires utf-8 support", e);
        }
        String base64data = new String(Base64Coder.encode(utf8data));
        String encodedData = URLEncoder.encode(base64data, "utf8");
        String encodedQuery = "data=" + encodedData;
        OutputStream postStream = null;
        try {
            postStream = conn.getOutputStream();
            postStream.write(encodedQuery.getBytes());
        }
        finally {
            if (postStream != null) {
                try {
                    postStream.close();
                }
                catch (IOException e) {}
            }
        }
        InputStream responseStream = null;
        String response = null;
        try {
            responseStream = conn.getInputStream();
            response = this.slurp(responseStream);
        }
        finally {
            if (responseStream != null) {
                try {
                    responseStream.close();
                }
                catch (IOException e) {}
            }
        }
        return response != null && response.equals("1");
    }

    private void sendMessages(List<JSONObject> messages, String endpointUrl) throws IOException {
        for (int i = 0; i < messages.size(); i += 50) {
            String messagesString;
            boolean accepted;
            int endIndex = i + 50;
            List<JSONObject> batch = messages.subList(i, endIndex = Math.min(endIndex, messages.size()));
            if (batch.size() <= 0 || (accepted = this.sendData(messagesString = this.dataString(batch), endpointUrl))) continue;
            throw new MixpanelServerException("Server refused to accept messages, they may be malformed.", batch);
        }
    }

    private String dataString(List<JSONObject> messages) {
        JSONArray array = new JSONArray();
        for (JSONObject message : messages) {
            array.put((Object)message);
        }
        return array.toString();
    }

    private String slurp(InputStream in) throws IOException {
        StringBuilder out = new StringBuilder();
        InputStreamReader reader = new InputStreamReader(in, "utf8");
        char[] readBuffer = new char[256];
        int readCount = 0;
        do {
            if ((readCount = reader.read(readBuffer)) <= 0) continue;
            out.append(readBuffer, 0, readCount);
        } while (readCount != -1);
        return out.toString();
    }
}

