/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.aboutlibraries.plugin;

import com.android.build.gradle.AppExtension;
import com.android.build.gradle.LibraryExtension;
import com.android.build.gradle.api.ApplicationVariant;
import com.android.build.gradle.api.BaseVariant;
import com.android.build.gradle.api.LibraryVariant;
import com.android.build.gradle.tasks.MergeResources;
import com.mikepenz.aboutlibraries.plugin.AboutLibrariesCollectorTask;
import com.mikepenz.aboutlibraries.plugin.AboutLibrariesExportComplianceTask;
import com.mikepenz.aboutlibraries.plugin.AboutLibrariesExportTask;
import com.mikepenz.aboutlibraries.plugin.AboutLibrariesTask;
import java.io.File;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bJ$\u0010\r\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u00012\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000bH\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/mikepenz/aboutlibraries/plugin/AboutLibrariesPluginAndroidExtension;", "", "()V", "LOGGER", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "apply", "", "project", "Lorg/gradle/api/Project;", "collectTask", "Lorg/gradle/api/tasks/TaskProvider;", "Lcom/mikepenz/aboutlibraries/plugin/AboutLibrariesCollectorTask;", "createAboutLibrariesAndroidTasks", "v", "plugin"})
public final class AboutLibrariesPluginAndroidExtension {
    @NotNull
    public static final AboutLibrariesPluginAndroidExtension INSTANCE = new AboutLibrariesPluginAndroidExtension();
    private static final Logger LOGGER = LoggerFactory.getLogger(AboutLibrariesPluginAndroidExtension.class);

    private AboutLibrariesPluginAndroidExtension() {
    }

    public final void apply(@NotNull Project project, @NotNull TaskProvider<AboutLibrariesCollectorTask> collectTask2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(collectTask2, (String)"collectTask");
        try {
            AppExtension app = (AppExtension)project.getExtensions().findByType(AppExtension.class);
            if (app != null) {
                app.getApplicationVariants().all(arg_0 -> AboutLibrariesPluginAndroidExtension.apply$lambda$0((Function1)new Function1<ApplicationVariant, Unit>(project, collectTask2){
                    final /* synthetic */ Project $project;
                    final /* synthetic */ TaskProvider<AboutLibrariesCollectorTask> $collectTask;
                    {
                        this.$project = $project;
                        this.$collectTask = $collectTask;
                        super(1);
                    }

                    public final void invoke(ApplicationVariant it) {
                        Intrinsics.checkNotNull((Object)it);
                        AboutLibrariesPluginAndroidExtension.access$createAboutLibrariesAndroidTasks(AboutLibrariesPluginAndroidExtension.INSTANCE, this.$project, it, this.$collectTask);
                    }
                }, arg_0));
            } else {
                LibraryExtension lib = (LibraryExtension)project.getExtensions().findByType(LibraryExtension.class);
                LibraryExtension libraryExtension = lib;
                if (libraryExtension != null && (libraryExtension = libraryExtension.getLibraryVariants()) != null) {
                    libraryExtension.all(arg_0 -> AboutLibrariesPluginAndroidExtension.apply$lambda$1((Function1)new Function1<LibraryVariant, Unit>(project, collectTask2){
                        final /* synthetic */ Project $project;
                        final /* synthetic */ TaskProvider<AboutLibrariesCollectorTask> $collectTask;
                        {
                            this.$project = $project;
                            this.$collectTask = $collectTask;
                            super(1);
                        }

                        public final void invoke(LibraryVariant it) {
                            Intrinsics.checkNotNull((Object)it);
                            AboutLibrariesPluginAndroidExtension.access$createAboutLibrariesAndroidTasks(AboutLibrariesPluginAndroidExtension.INSTANCE, this.$project, it, this.$collectTask);
                        }
                    }, arg_0));
                }
            }
        }
        catch (Throwable t) {
            LOGGER.warn("Couldn't register Android related plugin tasks");
        }
    }

    private final void createAboutLibrariesAndroidTasks(Project project, Object v, TaskProvider<?> collectTask2) {
        BaseVariant baseVariant = v instanceof BaseVariant ? (BaseVariant)v : null;
        if (baseVariant == null) {
            return;
        }
        BaseVariant variant = baseVariant;
        TaskContainer taskContainer = project.getTasks();
        String string = variant.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        Locale locale = Locale.ENGLISH;
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ENGLISH");
        AboutLibrariesTask task2 = (AboutLibrariesTask)taskContainer.create("prepareLibraryDefinitions" + StringsKt.capitalize((String)string, (Locale)locale), AboutLibrariesTask.class, arg_0 -> AboutLibrariesPluginAndroidExtension.createAboutLibrariesAndroidTasks$lambda$2((Function1)new Function1<AboutLibrariesTask, Unit>(variant, project, collectTask2){
            final /* synthetic */ BaseVariant $variant;
            final /* synthetic */ Project $project;
            final /* synthetic */ TaskProvider<?> $collectTask;
            {
                this.$variant = $variant;
                this.$project = $project;
                this.$collectTask = $collectTask;
                super(1);
            }

            public final void invoke(AboutLibrariesTask it) {
                it.setDescription("Writes the relevant meta data for the AboutLibraries plugin to display dependencies");
                it.setGroup("Build");
                it.setVariant(this.$variant.getName());
                File file = this.$project.file((Object)(this.$project.getBuildDir() + "/generated/aboutLibraries/" + this.$variant.getName() + "/res/raw/"));
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"file(...)");
                it.setResultDirectory(file);
                Object[] objectArray = new Object[]{this.$collectTask};
                it.dependsOn(objectArray);
            }
        }, arg_0));
        try {
            Object[] objectArray = new Object[]{task2.getResultDirectory().getParentFile()};
            ConfigurableFileCollection configurableFileCollection = project.files(objectArray);
            objectArray = new Object[]{task2};
            variant.registerGeneratedResFolders((FileCollection)configurableFileCollection.builtBy(objectArray));
            try {
                variant.getMergeResourcesProvider().configure(arg_0 -> AboutLibrariesPluginAndroidExtension.createAboutLibrariesAndroidTasks$lambda$3((Function1)new Function1<MergeResources, Unit>(task2){
                    final /* synthetic */ AboutLibrariesTask $task;
                    {
                        this.$task = $task;
                        super(1);
                    }

                    public final void invoke(MergeResources it) {
                        Object[] objectArray = new Object[]{this.$task};
                        it.dependsOn(objectArray);
                    }
                }, arg_0));
            }
            catch (Throwable t) {
                Object[] objectArray2 = new Object[]{task2};
                variant.getMergeResources().dependsOn(objectArray2);
            }
        }
        catch (Throwable t) {
            File[] fileArray = new File[]{task2.getResultDirectory().getParentFile()};
            variant.registerResGeneratingTask((Task)task2, fileArray);
        }
        TaskContainer taskContainer2 = project.getTasks();
        String string2 = variant.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        Locale locale2 = Locale.ENGLISH;
        Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"ENGLISH");
        taskContainer2.register("generateLibraryDefinitions" + StringsKt.capitalize((String)string2, (Locale)locale2), AboutLibrariesTask.class, arg_0 -> AboutLibrariesPluginAndroidExtension.createAboutLibrariesAndroidTasks$lambda$4((Function1)new Function1<AboutLibrariesTask, Unit>(variant, project, collectTask2){
            final /* synthetic */ BaseVariant $variant;
            final /* synthetic */ Project $project;
            final /* synthetic */ TaskProvider<?> $collectTask;
            {
                this.$variant = $variant;
                this.$project = $project;
                this.$collectTask = $collectTask;
                super(1);
            }

            public final void invoke(AboutLibrariesTask it) {
                it.setDescription("Manually write meta data for the AboutLibraries plugin");
                it.setGroup("Build");
                it.setVariant(this.$variant.getName());
                File file = this.$project.file((Object)(this.$project.getBuildDir() + "/generated/aboutLibraries/" + this.$variant.getName() + "/res/raw/"));
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"file(...)");
                it.setResultDirectory(file);
                Object[] objectArray = new Object[]{this.$collectTask};
                it.dependsOn(objectArray);
            }
        }, arg_0));
        TaskContainer taskContainer3 = project.getTasks();
        String string3 = variant.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getName(...)");
        Locale locale3 = Locale.ENGLISH;
        Intrinsics.checkNotNullExpressionValue((Object)locale3, (String)"ENGLISH");
        taskContainer3.register("exportLibraries" + StringsKt.capitalize((String)string3, (Locale)locale3), AboutLibrariesExportTask.class, arg_0 -> AboutLibrariesPluginAndroidExtension.createAboutLibrariesAndroidTasks$lambda$5((Function1)new Function1<AboutLibrariesExportTask, Unit>(variant, collectTask2){
            final /* synthetic */ BaseVariant $variant;
            final /* synthetic */ TaskProvider<?> $collectTask;
            {
                this.$variant = $variant;
                this.$collectTask = $collectTask;
                super(1);
            }

            public final void invoke(AboutLibrariesExportTask it) {
                it.setDescription("Writes all libraries and their license in CSV format to the CLI");
                it.setGroup("Help");
                it.setVariant(this.$variant.getName());
                Object[] objectArray = new Object[]{this.$collectTask};
                it.dependsOn(objectArray);
            }
        }, arg_0));
        TaskContainer taskContainer4 = project.getTasks();
        String string4 = variant.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getName(...)");
        Locale locale4 = Locale.ENGLISH;
        Intrinsics.checkNotNullExpressionValue((Object)locale4, (String)"ENGLISH");
        taskContainer4.register("exportComplianceLibraries" + StringsKt.capitalize((String)string4, (Locale)locale4), AboutLibrariesExportComplianceTask.class, arg_0 -> AboutLibrariesPluginAndroidExtension.createAboutLibrariesAndroidTasks$lambda$6((Function1)new Function1<AboutLibrariesExportComplianceTask, Unit>(variant, collectTask2){
            final /* synthetic */ BaseVariant $variant;
            final /* synthetic */ TaskProvider<?> $collectTask;
            {
                this.$variant = $variant;
                this.$collectTask = $collectTask;
                super(1);
            }

            public final void invoke(AboutLibrariesExportComplianceTask it) {
                it.setDescription("Writes all libraries with their source and their license in CSV format to the configured directory");
                it.setGroup("Help");
                it.setVariant(this.$variant.getName());
                Object[] objectArray = new Object[]{this.$collectTask};
                it.dependsOn(objectArray);
            }
        }, arg_0));
    }

    private static final void apply$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void apply$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void createAboutLibrariesAndroidTasks$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void createAboutLibrariesAndroidTasks$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void createAboutLibrariesAndroidTasks$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void createAboutLibrariesAndroidTasks$lambda$5(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void createAboutLibrariesAndroidTasks$lambda$6(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ void access$createAboutLibrariesAndroidTasks(AboutLibrariesPluginAndroidExtension $this, Project project, Object v, TaskProvider collectTask2) {
        $this.createAboutLibrariesAndroidTasks(project, v, collectTask2);
    }
}

