/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.services.sharepoint.http;

import com.microsoft.services.sharepoint.Constants;
import com.microsoft.services.sharepoint.http.Response;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StreamResponse
implements Response {
    private BufferedReader mReader;
    private InputStream mStream;
    private int mStatus;
    Map<String, List<String>> mHeaders;

    public StreamResponse(InputStream stream, int status, Map<String, List<String>> headers) {
        this.mHeaders = new HashMap<String, List<String>>(headers);
        this.mReader = new BufferedReader(new InputStreamReader(stream, Constants.UTF8));
        this.mStream = stream;
        this.mStatus = status;
    }

    @Override
    public String readToEnd() throws IOException {
        String line;
        StringBuilder sb = new StringBuilder();
        while ((line = this.mReader.readLine()) != null) {
            sb.append(line);
            sb.append("\n");
        }
        return sb.toString();
    }

    @Override
    public int getStatus() {
        return this.mStatus;
    }

    @Override
    public String readLine() throws IOException {
        return this.mReader.readLine();
    }

    @Override
    public Map<String, List<String>> getHeaders() {
        return new HashMap<String, List<String>>(this.mHeaders);
    }

    @Override
    public List<String> getHeader(String headerName) {
        return this.mHeaders.get(headerName);
    }

    @Override
    public byte[] readAllBytes() throws IOException {
        int nRead;
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        byte[] data = new byte[1024];
        while ((nRead = this.mStream.read(data, 0, data.length)) != -1) {
            os.write(data, 0, nRead);
        }
        return os.toByteArray();
    }
}

