/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.services.sharepoint;

import com.microsoft.services.sharepoint.QueryOperations;
import com.microsoft.services.sharepoint.QueryOrder;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public final class Query {
    private String mQueryText = null;
    private boolean mHasInlineCount = false;
    private List<Map.Entry<String, QueryOrder>> mOrderBy = new ArrayList<Map.Entry<String, QueryOrder>>();
    private List<String> mProjection = new ArrayList<String>();
    private List<String> mExpand = new ArrayList<String>();
    private List<Map.Entry<String, String>> mUserDefinedParameters = new ArrayList<Map.Entry<String, String>>();
    private int mTop = -1;
    private int mSkip = -1;
    private List<Query> internalValues = new ArrayList<Query>();
    private List<Query> querySteps = new ArrayList<Query>();

    public void ensureIdProperty() {
        if (this.mProjection.size() > 0) {
            for (String projection : this.mProjection) {
                if (!projection.toLowerCase(Locale.getDefault()).equals("id")) continue;
                return;
            }
            this.mProjection.add("id");
        }
    }

    public String getQueryText() {
        return this.mQueryText;
    }

    public void setQueryText(String queryText) {
        this.mQueryText = queryText;
    }

    public Query() {
    }

    Query(Query query) {
        this.internalValues.add(query);
    }

    void addInternalValue(Query query) {
        this.internalValues.add(query);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.getQueryText() != null) {
            sb.append(this.getQueryText());
        }
        if (this.internalValues.size() > 0) {
            sb.append("(");
            boolean first = true;
            for (Query val : this.internalValues) {
                if (first) {
                    first = false;
                } else {
                    sb.append(",");
                }
                sb.append(val.toString());
            }
            sb.append(")");
        }
        for (Query step : this.querySteps) {
            if (!sb.toString().endsWith(" ") && sb.toString().length() > 0 || sb.toString().endsWith(")")) {
                sb.append(" ");
            }
            sb.append(step.toString());
        }
        return sb.toString();
    }

    public String getRowSetModifiers() {
        StringBuilder sb = new StringBuilder();
        try {
            boolean first;
            if (this.mHasInlineCount) {
                sb.append("&$inlinecount=allpages");
            }
            if (this.mTop > 0) {
                sb.append("&$top=");
                sb.append(this.mTop);
            }
            if (this.mSkip > 0) {
                sb.append("&$skip=");
                sb.append(this.mSkip);
            }
            if (this.mOrderBy.size() > 0) {
                sb.append("&$orderby=");
                first = true;
                for (Map.Entry<String, QueryOrder> order : this.mOrderBy) {
                    if (first) {
                        first = false;
                    } else {
                        sb.append(URLEncoder.encode(",", "UTF-8"));
                    }
                    sb.append(URLEncoder.encode(order.getKey(), "UTF-8"));
                    sb.append(URLEncoder.encode(" ", "UTF-8"));
                    sb.append(order.getValue() == QueryOrder.Ascending ? "asc" : "desc");
                }
            }
            if (!this.mUserDefinedParameters.isEmpty()) {
                for (Map.Entry<String, String> parameter : this.mUserDefinedParameters) {
                    if (parameter.getKey() == null) continue;
                    sb.append("&");
                    String key = parameter.getKey();
                    String value = parameter.getValue();
                    if (value == null) {
                        value = "null";
                    }
                    sb.append(URLEncoder.encode(key, "UTF-8"));
                    sb.append("=");
                    sb.append(URLEncoder.encode(value, "UTF-8"));
                }
            }
            if (this.mProjection != null && this.mProjection.size() > 0) {
                sb.append("&$select=");
                first = true;
                for (String field : this.mProjection) {
                    if (first) {
                        first = false;
                    } else {
                        sb.append(URLEncoder.encode(",", "UTF-8"));
                    }
                    sb.append(URLEncoder.encode(field, "UTF-8"));
                }
            }
            if (this.mExpand != null && this.mExpand.size() > 0) {
                sb.append("&$expand=");
                first = true;
                for (String field : this.mExpand) {
                    if (first) {
                        first = false;
                    } else {
                        sb.append(URLEncoder.encode(",", "UTF-8"));
                    }
                    sb.append(URLEncoder.encode(field, "UTF-8"));
                }
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return sb.toString();
    }

    public Query parameter(String parameter, String value) {
        this.mUserDefinedParameters.add(new AbstractMap.SimpleEntry<String, String>(parameter, value));
        return this;
    }

    public Query orderBy(String field, QueryOrder order) {
        this.mOrderBy.add(new AbstractMap.SimpleEntry<String, QueryOrder>(field, order));
        return this;
    }

    public Query top(int top) {
        if (top > 0) {
            this.mTop = top;
        }
        return this;
    }

    public Query skip(int skip) {
        if (skip > 0) {
            this.mSkip = skip;
        }
        return this;
    }

    public Query includeInlineCount() {
        this.mHasInlineCount = true;
        return this;
    }

    public Query select(String ... fields) {
        this.mProjection = new ArrayList<String>();
        for (String field : fields) {
            this.mProjection.add(field);
        }
        return this;
    }

    public Query expand(String ... fields) {
        this.mExpand = new ArrayList<String>();
        for (String field : fields) {
            this.mExpand.add(field);
        }
        return this;
    }

    public Query field(String fieldName) {
        this.querySteps.add(QueryOperations.field(fieldName));
        return this;
    }

    public Query val(Number number) {
        this.querySteps.add(QueryOperations.val(number));
        return this;
    }

    public Query val(boolean val) {
        this.querySteps.add(QueryOperations.val(val));
        return this;
    }

    public Query val(String s) {
        this.querySteps.add(QueryOperations.val(s));
        return this;
    }

    public Query and() {
        this.querySteps.add(QueryOperations.and());
        return this;
    }

    public Query and(Query otherQuery) {
        this.querySteps.add(QueryOperations.and(otherQuery));
        return this;
    }

    public Query or() {
        this.querySteps.add(QueryOperations.or());
        return this;
    }

    public Query or(Query otherQuery) {
        this.querySteps.add(QueryOperations.or(otherQuery));
        return this;
    }

    public Query not() {
        this.querySteps.add(QueryOperations.not());
        return this;
    }

    public Query not(Query otherQuery) {
        this.querySteps.add(QueryOperations.not(otherQuery));
        return this;
    }

    public Query not(boolean booleanValue) {
        this.querySteps.add(QueryOperations.not(QueryOperations.val(booleanValue)));
        return this;
    }

    public Query ge() {
        this.querySteps.add(QueryOperations.ge());
        return this;
    }

    public Query ge(Query otherQuery) {
        this.querySteps.add(QueryOperations.ge(otherQuery));
        return this;
    }

    public Query ge(Number numberValue) {
        this.querySteps.add(QueryOperations.ge(QueryOperations.val(numberValue)));
        return this;
    }

    public Query le() {
        this.querySteps.add(QueryOperations.le());
        return this;
    }

    public Query le(Query otherQuery) {
        this.querySteps.add(QueryOperations.le(otherQuery));
        return this;
    }

    public Query le(Number numberValue) {
        this.querySteps.add(QueryOperations.le(QueryOperations.val(numberValue)));
        return this;
    }

    public Query gt() {
        this.querySteps.add(QueryOperations.gt());
        return this;
    }

    public Query gt(Query otherQuery) {
        this.querySteps.add(QueryOperations.gt(otherQuery));
        return this;
    }

    public Query gt(Number numberValue) {
        this.querySteps.add(QueryOperations.gt(QueryOperations.val(numberValue)));
        return this;
    }

    public Query lt() {
        this.querySteps.add(QueryOperations.lt());
        return this;
    }

    public Query lt(Query otherQuery) {
        this.querySteps.add(QueryOperations.lt(otherQuery));
        return this;
    }

    public Query lt(Number numberValue) {
        this.querySteps.add(QueryOperations.lt(QueryOperations.val(numberValue)));
        return this;
    }

    public Query eq() {
        this.querySteps.add(QueryOperations.eq());
        return this;
    }

    public Query eq(Query otherQuery) {
        this.querySteps.add(QueryOperations.eq(otherQuery));
        return this;
    }

    public Query eq(Number numberValue) {
        this.querySteps.add(QueryOperations.eq(QueryOperations.val(numberValue)));
        return this;
    }

    public Query eq(boolean booleanValue) {
        this.querySteps.add(QueryOperations.eq(QueryOperations.val(booleanValue)));
        return this;
    }

    public Query eq(String stringValue) {
        this.querySteps.add(QueryOperations.eq(QueryOperations.val(stringValue)));
        return this;
    }

    public Query ne() {
        this.querySteps.add(QueryOperations.ne());
        return this;
    }

    public Query ne(Query otherQuery) {
        this.querySteps.add(QueryOperations.ne(otherQuery));
        return this;
    }

    public Query ne(Number numberValue) {
        this.querySteps.add(QueryOperations.ne(QueryOperations.val(numberValue)));
        return this;
    }

    public Query ne(boolean booleanValue) {
        this.querySteps.add(QueryOperations.ne(QueryOperations.val(booleanValue)));
        return this;
    }

    public Query ne(String stringValue) {
        this.querySteps.add(QueryOperations.ne(QueryOperations.val(stringValue)));
        return this;
    }

    public Query add() {
        this.querySteps.add(QueryOperations.add());
        return this;
    }

    public Query add(Query otherQuery) {
        this.querySteps.add(QueryOperations.add(otherQuery));
        return this;
    }

    public Query add(Number val) {
        this.querySteps.add(QueryOperations.add(val));
        return this;
    }

    public Query sub() {
        this.querySteps.add(QueryOperations.sub());
        return this;
    }

    public Query sub(Query otherQuery) {
        this.querySteps.add(QueryOperations.sub(otherQuery));
        return this;
    }

    public Query sub(Number val) {
        this.querySteps.add(QueryOperations.sub(val));
        return this;
    }

    public Query mul() {
        this.querySteps.add(QueryOperations.mul());
        return this;
    }

    public Query mul(Query otherQuery) {
        this.querySteps.add(QueryOperations.mul(otherQuery));
        return this;
    }

    public Query mul(Number val) {
        this.querySteps.add(QueryOperations.mul(val));
        return this;
    }

    public Query div() {
        this.querySteps.add(QueryOperations.div());
        return this;
    }

    public Query div(Query otherQuery) {
        this.querySteps.add(QueryOperations.div(otherQuery));
        return this;
    }

    public Query div(Number val) {
        this.querySteps.add(QueryOperations.div(val));
        return this;
    }

    public Query mod() {
        this.querySteps.add(QueryOperations.mod());
        return this;
    }

    public Query mod(Query otherQuery) {
        this.querySteps.add(QueryOperations.mod(otherQuery));
        return this;
    }

    public Query mod(Number val) {
        this.querySteps.add(QueryOperations.mod(val));
        return this;
    }

    public Query year(Query otherQuery) {
        this.querySteps.add(QueryOperations.year(otherQuery));
        return this;
    }

    public Query year(String field) {
        this.querySteps.add(QueryOperations.year(field));
        return this;
    }

    public Query month(Query otherQuery) {
        this.querySteps.add(QueryOperations.month(otherQuery));
        return this;
    }

    public Query month(String field) {
        this.querySteps.add(QueryOperations.month(field));
        return this;
    }

    public Query day(Query otherQuery) {
        this.querySteps.add(QueryOperations.day(otherQuery));
        return this;
    }

    public Query day(String field) {
        this.querySteps.add(QueryOperations.day(field));
        return this;
    }

    public Query hour(Query otherQuery) {
        this.querySteps.add(QueryOperations.hour(otherQuery));
        return this;
    }

    public Query hour(String field) {
        this.querySteps.add(QueryOperations.hour(field));
        return this;
    }

    public Query minute(Query otherQuery) {
        this.querySteps.add(QueryOperations.minute(otherQuery));
        return this;
    }

    public Query minute(String field) {
        this.querySteps.add(QueryOperations.minute(field));
        return this;
    }

    public Query second(Query otherQuery) {
        this.querySteps.add(QueryOperations.second(otherQuery));
        return this;
    }

    public Query second(String field) {
        this.querySteps.add(QueryOperations.second(field));
        return this;
    }

    public Query floor(Query otherQuery) {
        this.querySteps.add(QueryOperations.floor(otherQuery));
        return this;
    }

    public Query ceiling(Query otherQuery) {
        this.querySteps.add(QueryOperations.ceiling(otherQuery));
        return this;
    }

    public Query round(Query otherQuery) {
        this.querySteps.add(QueryOperations.round(otherQuery));
        return this;
    }

    public Query toLower(Query exp) {
        this.querySteps.add(QueryOperations.toLower(exp));
        return this;
    }

    public Query toLower(String field) {
        this.querySteps.add(QueryOperations.toLower(field));
        return this;
    }

    public Query toUpper(Query exp) {
        this.querySteps.add(QueryOperations.toUpper(exp));
        return this;
    }

    public Query toUpper(String field) {
        this.querySteps.add(QueryOperations.toUpper(field));
        return this;
    }

    public Query length(Query exp) {
        this.querySteps.add(QueryOperations.length(exp));
        return this;
    }

    public Query length(String field) {
        this.querySteps.add(QueryOperations.length(field));
        return this;
    }

    public Query trim(Query exp) {
        this.querySteps.add(QueryOperations.trim(exp));
        return this;
    }

    public Query trim(String field) {
        this.querySteps.add(QueryOperations.trim(field));
        return this;
    }

    public Query startsWith(Query field, Query start) {
        this.querySteps.add(QueryOperations.startsWith(field, start));
        return this;
    }

    public Query startsWith(String field, String start) {
        this.querySteps.add(QueryOperations.startsWith(field, start));
        return this;
    }

    public Query endsWith(Query field, Query end) {
        this.querySteps.add(QueryOperations.endsWith(field, end));
        return this;
    }

    public Query endsWith(String field, String end) {
        this.querySteps.add(QueryOperations.endsWith(field, end));
        return this;
    }

    public Query subStringOf(Query str1, Query str2) {
        this.querySteps.add(QueryOperations.subStringOf(str1, str2));
        return this;
    }

    public Query subStringOf(String str, String field) {
        this.querySteps.add(QueryOperations.subStringOf(str, field));
        return this;
    }

    public Query concat(Query str1, Query str2) {
        this.querySteps.add(QueryOperations.concat(str1, str2));
        return this;
    }

    public Query indexOf(Query haystack, Query needle) {
        this.querySteps.add(QueryOperations.indexOf(haystack, needle));
        return this;
    }

    public Query indexOf(String field, String needle) {
        this.querySteps.add(QueryOperations.indexOf(field, needle));
        return this;
    }

    public Query subString(Query str, Query pos) {
        this.querySteps.add(QueryOperations.subString(str, pos));
        return this;
    }

    public Query subString(String field, int pos) {
        this.querySteps.add(QueryOperations.subString(field, pos));
        return this;
    }

    public Query subString(Query str, Query pos, Query length) {
        this.querySteps.add(QueryOperations.subString(str, pos, length));
        return this;
    }

    public Query subString(String field, int pos, int length) {
        this.querySteps.add(QueryOperations.subString(field, pos, length));
        return this;
    }

    public Query replace(Query str, Query find, Query replace) {
        this.querySteps.add(QueryOperations.replace(str, find, replace));
        return this;
    }

    public Query replace(String field, String find, String replace) {
        this.querySteps.add(QueryOperations.replace(field, find, replace));
        return this;
    }
}

