/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.services.sharepoint;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.microsoft.services.sharepoint.Credentials;
import com.microsoft.services.sharepoint.Logger;
import com.microsoft.services.sharepoint.Query;
import com.microsoft.services.sharepoint.SPList;
import com.microsoft.services.sharepoint.SPListField;
import com.microsoft.services.sharepoint.SPListItem;
import com.microsoft.services.sharepoint.SharePointClient;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ListClient
extends SharePointClient {
    public ListClient(String serverUrl, String siteRelativeUrl, Credentials credentials) {
        super(serverUrl, siteRelativeUrl, credentials);
    }

    public ListClient(String serverUrl, String siteRelativeUrl, Credentials credentials, Logger logger) {
        super(serverUrl, siteRelativeUrl, credentials, logger);
    }

    public ListenableFuture<List<SPList>> getLists(Query query) {
        final SettableFuture result = SettableFuture.create();
        String queryOData = this.generateODataQueryString(query);
        String getListsUrl = this.getSiteUrl() + "_api/web/lists/?" + this.queryEncode(queryOData);
        ListenableFuture<JSONObject> request = this.executeRequestJson(getListsUrl, "GET");
        Futures.addCallback(request, (FutureCallback)new FutureCallback<JSONObject>(){

            public void onFailure(Throwable t) {
                result.setException(t);
            }

            public void onSuccess(JSONObject json) {
                try {
                    List<SPList> list = SPList.listFromJson(json);
                    result.set(list);
                }
                catch (JSONException e) {
                    ListClient.this.log(e);
                }
            }
        });
        return result;
    }

    public ListenableFuture<SPList> getList(String listName) {
        final SettableFuture result = SettableFuture.create();
        String getListUrl = this.getSiteUrl() + "_api/web/lists/GetByTitle('%s')";
        getListUrl = String.format(getListUrl, this.urlEncode(listName));
        ListenableFuture<JSONObject> request = this.executeRequestJson(getListUrl, "GET");
        Futures.addCallback(request, (FutureCallback)new FutureCallback<JSONObject>(){

            public void onFailure(Throwable t) {
                result.setException(t);
            }

            public void onSuccess(JSONObject json) {
                SPList list = new SPList();
                list.loadFromJson(json, true);
                result.set((Object)list);
            }
        });
        return result;
    }

    public ListenableFuture<List<SPListItem>> getListItems(String listName, Query query) {
        final SettableFuture result = SettableFuture.create();
        String listNamePart = String.format("_api/web/lists/GetByTitle('%s')/Items?", this.urlEncode(listName));
        String getListUrl = this.getSiteUrl() + listNamePart + this.generateODataQueryString(query);
        ListenableFuture<JSONObject> request = this.executeRequestJson(getListUrl, "GET");
        Futures.addCallback(request, (FutureCallback)new FutureCallback<JSONObject>(){

            public void onFailure(Throwable t) {
                result.setException(t);
            }

            public void onSuccess(JSONObject json) {
                try {
                    result.set(SPListItem.listFromJson(json));
                }
                catch (JSONException e) {
                    ListClient.this.log(e);
                }
            }
        });
        return result;
    }

    public ListenableFuture<List<SPListField>> getListFields(String listName, Query query) {
        final SettableFuture result = SettableFuture.create();
        String getListUrl = this.getSiteUrl() + "_api/web/lists/GetByTitle('%s')/Fields?" + this.generateODataQueryString(query);
        getListUrl = String.format(getListUrl, this.urlEncode(listName));
        ListenableFuture<JSONObject> request = this.executeRequestJson(getListUrl, "GET");
        Futures.addCallback(request, (FutureCallback)new FutureCallback<JSONObject>(){

            public void onFailure(Throwable t) {
                result.setException(t);
            }

            public void onSuccess(JSONObject json) {
                try {
                    result.set(SPListField.listFromJson(json));
                }
                catch (JSONException e) {
                    ListClient.this.log(e);
                }
            }
        });
        return result;
    }

    public ListenableFuture<Void> insertListItem(SPListItem listItem, SPList list) {
        final SettableFuture result = SettableFuture.create();
        String getListUrl = this.getSiteUrl() + "_api/web/lists/GetByTitle('%s')/Items";
        getListUrl = String.format(getListUrl, this.urlEncode(list.getTitle()));
        try {
            JSONObject payload = new JSONObject();
            JSONObject metadata = new JSONObject();
            metadata.put("type", (Object)list.getListItemEntityTypeFullName());
            payload.put("__metadata", (Object)metadata);
            for (String key : listItem.getValues().keySet()) {
                Object object = listItem.getValues().get(key);
                if (object instanceof JSONArray) {
                    JSONObject container = new JSONObject();
                    container.put("results", object);
                    payload.put(key + "Id", (Object)container);
                    continue;
                }
                payload.put(key, object);
            }
            ListenableFuture<JSONObject> request = this.executeRequestJsonWithDigest(getListUrl, "POST", null, this.getBytes(payload.toString()));
            Futures.addCallback(request, (FutureCallback)new FutureCallback<JSONObject>(){

                public void onFailure(Throwable t) {
                    result.setException(t);
                }

                public void onSuccess(JSONObject json) {
                    result.set(null);
                }
            });
        }
        catch (Throwable t) {
            result.setException(t);
        }
        return result;
    }

    public ListenableFuture<Void> updateListItem(SPListItem listItem, SPList list) {
        final SettableFuture result = SettableFuture.create();
        String getListUrl = this.getSiteUrl() + "_api/web/lists/GetByTitle('%s')/items(" + listItem.getId() + ")";
        getListUrl = String.format(getListUrl, this.urlEncode(list.getTitle()));
        try {
            JSONObject payload = new JSONObject();
            JSONObject metadata = new JSONObject();
            metadata.put("type", (Object)list.getListItemEntityTypeFullName());
            payload.put("__metadata", (Object)metadata);
            for (String key : listItem.getValues().keySet()) {
                Object object = listItem.getValues().get(key);
                if (object instanceof JSONArray) {
                    JSONObject container = new JSONObject();
                    container.put("results", object);
                    payload.put(key + "Id", (Object)container);
                    continue;
                }
                payload.put(key, object);
            }
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("X-HTTP-Method", "MERGE");
            headers.put("If-Match", "*");
            ListenableFuture<JSONObject> request = this.executeRequestJsonWithDigest(getListUrl, "POST", headers, this.getBytes(payload.toString()));
            Futures.addCallback(request, (FutureCallback)new FutureCallback<JSONObject>(){

                public void onFailure(Throwable t) {
                    result.setException(t);
                }

                public void onSuccess(JSONObject json) {
                    result.set(null);
                }
            });
        }
        catch (JSONException e) {
            result.setException((Throwable)e);
        }
        return result;
    }

    public ListenableFuture<Void> deleteListItem(SPListItem listItem, String listName) {
        final SettableFuture result = SettableFuture.create();
        String getListUrl = this.getSiteUrl() + "_api/web/lists/GetByTitle('%s')/items(" + listItem.getId() + ")";
        getListUrl = String.format(getListUrl, this.urlEncode(listName));
        try {
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("X-HTTP-Method", "DELETE");
            headers.put("If-Match", "*");
            ListenableFuture<JSONObject> request = this.executeRequestJsonWithDigest(getListUrl, "POST", headers, null);
            Futures.addCallback(request, (FutureCallback)new FutureCallback<JSONObject>(){

                public void onFailure(Throwable t) {
                    result.setException(t);
                }

                public void onSuccess(JSONObject json) {
                    result.set(null);
                }
            });
        }
        catch (Throwable t) {
            result.setException(t);
        }
        return result;
    }

    public ListenableFuture<List<String>> getColumnsFromDefaultView(String listName) {
        final SettableFuture result = SettableFuture.create();
        String getViewUrl = this.getSiteUrl() + String.format("_api/web/lists/GetByTitle('%s')/defaultView/viewfields", this.urlEncode(listName));
        ListenableFuture<JSONObject> request = this.executeRequestJson(getViewUrl, "GET");
        Futures.addCallback(request, (FutureCallback)new FutureCallback<JSONObject>(){

            public void onFailure(Throwable t) {
                result.setException(t);
            }

            public void onSuccess(JSONObject json) {
                try {
                    JSONObject container = json.getJSONObject("d");
                    JSONArray results = container.getJSONObject("Items").getJSONArray("results");
                    ArrayList<String> columnNames = new ArrayList<String>();
                    for (int i = 0; i < results.length(); ++i) {
                        columnNames.add(results.get(i).toString());
                    }
                    result.set(columnNames);
                }
                catch (JSONException e) {
                    ListClient.this.log(e);
                }
            }
        });
        return result;
    }

    public ListenableFuture<String> getUserProperties() {
        final SettableFuture result = SettableFuture.create();
        String url = this.getSiteUrl() + "/_api/SP.UserProfiles.PeopleManager/GetMyProperties";
        ListenableFuture<JSONObject> request = this.executeRequestJson(url, "GET");
        Futures.addCallback(request, (FutureCallback)new FutureCallback<JSONObject>(){

            public void onFailure(Throwable t) {
                result.setException(t);
            }

            public void onSuccess(JSONObject json) {
                result.set((Object)json.toString());
            }
        });
        return result;
    }

    private byte[] getBytes(String s) {
        try {
            return s.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return s.getBytes();
        }
    }
}

