/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.services.sharepoint;

import com.microsoft.services.sharepoint.OfficeEntity;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class FileSystemItem
extends OfficeEntity {
    private Map<String, Object> mValues = new HashMap<String, Object>();

    public void setData(String key, Object data) {
        this.mValues.put(key, data);
    }

    Map<String, Object> getValues() {
        return new HashMap<String, Object>(this.mValues);
    }

    public int getId() {
        return (Integer)this.getData("Id");
    }

    public String getName() {
        return this.getData("Name").toString();
    }

    public List<FileSystemItem> getSubItems(String field) {
        JSONObject subItemsJson = (JSONObject)this.getData(field);
        try {
            return OfficeEntity.listFromJson(subItemsJson, FileSystemItem.class);
        }
        catch (JSONException e) {
            throw new IllegalArgumentException("Cant get sub items from field " + field, e);
        }
    }

    public static List<FileSystemItem> listFrom(JSONObject json) throws Throwable {
        return OfficeEntity.listFromJson(json, FileSystemItem.class);
    }

    @Override
    public Object getData(String field) {
        if (this.mValues.containsKey(field)) {
            return this.mValues.get(field);
        }
        return super.getData(field);
    }
}

