/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.services.msa;

import android.os.AsyncTask;
import com.microsoft.services.msa.DefaultObservableOAuthRequest;
import com.microsoft.services.msa.LiveAuthException;
import com.microsoft.services.msa.OAuthRequestObserver;
import com.microsoft.services.msa.OAuthResponse;
import com.microsoft.services.msa.ObservableOAuthRequest;
import com.microsoft.services.msa.TokenRequest;

class TokenRequestAsync
extends AsyncTask<Void, Void, Void>
implements ObservableOAuthRequest {
    private final DefaultObservableOAuthRequest observerable;
    private LiveAuthException exception;
    private OAuthResponse response;
    private final TokenRequest request;

    public TokenRequestAsync(TokenRequest request) {
        assert (request != null);
        this.observerable = new DefaultObservableOAuthRequest();
        this.request = request;
    }

    @Override
    public void addObserver(OAuthRequestObserver observer) {
        this.observerable.addObserver(observer);
    }

    @Override
    public boolean removeObserver(OAuthRequestObserver observer) {
        return this.observerable.removeObserver(observer);
    }

    protected Void doInBackground(Void ... params) {
        try {
            this.response = this.request.execute();
        }
        catch (LiveAuthException e) {
            this.exception = e;
        }
        return null;
    }

    protected void onPostExecute(Void result) {
        super.onPostExecute((Object)result);
        if (this.response != null) {
            this.observerable.notifyObservers(this.response);
        } else if (this.exception != null) {
            this.observerable.notifyObservers(this.exception);
        } else {
            LiveAuthException exception = new LiveAuthException("An error occured on the client during the operation.");
            this.observerable.notifyObservers(exception);
        }
    }
}

