/*******************************************************************************
 Copyright (c) Microsoft Open Technologies, Inc. All Rights Reserved.
 Licensed under the MIT or Apache License; see LICENSE in the source repository
 root for authoritative license information.﻿

 **NOTE** This code was generated by a tool and will occasionally be
 overwritten. We welcome comments and issues regarding this code; they will be
 addressed in the generation tool. If you wish to submit pull requests, please
 do so for the templates in that tool.

 This code was generated by Vipr (https://github.com/microsoft/vipr) using
 the T4TemplateWriter (https://github.com/msopentech/vipr-t4templatewriter).
 ******************************************************************************/
package com.microsoft.services.files.fetchers;

import com.microsoft.services.files.*;
import com.google.common.util.concurrent.*;
import com.microsoft.services.orc.core.*;
import com.microsoft.services.orc.http.*;
import com.microsoft.services.orc.serialization.*;

import static com.microsoft.services.orc.core.Helpers.*;

/**
 * The type FileOperations.
 */
public class FileOperations extends ItemOperations {

     /**
      * Instantiates a new FileOperations.
      *
      * @param urlComponent the url component
      * @param parent the parent
      */
    public FileOperations(String urlComponent, OrcExecutable parent) {
            super(urlComponent, parent);
    }

    /**
     * Add parameter.
     *
     * @param name the name
     * @param value the value
     * @return the operations
     */
    public FileOperations addParameter(String name, Object value) {
        addCustomParameter(name, value);
        return this;
    }

     /**
     * Add header.
     *
     * @param name the name
     * @param value the value
     * @return the operations
     */
    public FileOperations addHeader(String name, String value) {
        addCustomHeader(name, value);
        return this;
    }

    
    
    /**
     * copy listenable future.
     * @param destFolderId the destFolderId @param destFolderPath the destFolderPath @param newName the newName 
     * @return the listenable future
     */         
    public ListenableFuture<File> copy(String destFolderId, String destFolderPath, String newName) { 
        JsonSerializer serializer = getResolver().getJsonSerializer();      
        String serializeddestFolderId = serializer.serialize(destFolderId);
		String serializeddestFolderPath = serializer.serialize(destFolderPath);
		String serializednewName = serializer.serialize(newName);
		  
        
        ListenableFuture<String> future = copyRaw(serializeddestFolderId, serializeddestFolderPath, serializednewName);
        return transformToEntityListenableFuture(future, File.class, getResolver());
        
    }

     /**
     * copyRaw listenable future.
     * @param destFolderId the destFolderId @param destFolderPath the destFolderPath @param newName the newName 
     * @return the listenable future
     */ 
    public ListenableFuture<String> copyRaw(String destFolderId, String destFolderPath, String newName){
        
        java.util.Map<String, String> map = new java.util.HashMap<String, String>();
        
        map.put("destFolderId", destFolderId);
		map.put("destFolderPath", destFolderPath);
		map.put("newName", newName);
		
        Request request = getResolver().createRequest();
        request.setVerb(HttpVerb.POST);
        
        request.setContent(getResolver().getJsonSerializer()
               .jsonObjectFromJsonMap(map).getBytes(Constants.UTF8));
                        
        request.getUrl().appendPathComponent("Microsoft.FileServices.copy");
        
        ListenableFuture<OrcResponse> future = oDataExecute(request);
        return transformToStringListenableFuture(future);
    }


    
    
    /**
     * uploadContent listenable future.
     * @param contentStream the contentStream 
     * @return the listenable future
     */         
    public ListenableFuture<Integer> uploadContent(byte[] contentStream) { 
        JsonSerializer serializer = getResolver().getJsonSerializer();      
        String serializedcontentStream = serializer.serialize(contentStream);
		  
        
        ListenableFuture<String> future = uploadContentRaw(serializedcontentStream);
        return transformToEntityListenableFuture(future, Integer.class, getResolver());
        
    }

     /**
     * uploadContentRaw listenable future.
     * @param contentStream the contentStream 
     * @return the listenable future
     */ 
    public ListenableFuture<String> uploadContentRaw(String contentStream){
        
        java.util.Map<String, String> map = new java.util.HashMap<String, String>();
        
        map.put("contentStream", contentStream);
		
        Request request = getResolver().createRequest();
        request.setVerb(HttpVerb.GET);
        
        request.setContent(getResolver().getJsonSerializer()
               .jsonObjectFromJsonMap(map).getBytes(Constants.UTF8));
                        
        request.getUrl().appendPathComponent("Microsoft.FileServices.uploadContent");
        
        ListenableFuture<OrcResponse> future = oDataExecute(request);
        return transformToStringListenableFuture(future);
    }


    
    
     /**
     * content listenable future.
     * 
     * @return the listenable future
     */         
    public ListenableFuture<byte[]> content() { 

    final SettableFuture<byte[]> result = SettableFuture.create();
        java.util.Map<String, Object> map = new java.util.HashMap<String, Object>();
        
        Request request = getResolver().createRequest();
        request.setVerb(HttpVerb.POST);
        request.setContent(serializeToJsonByteArray(map, getResolver()));
        String parameters = getFunctionParameters(map);
                 request.getUrl().appendPathComponent("Microsoft.FileServices.content(" + parameters + ")");   
                request.getUrl().appendPathComponent("content(" + parameters + ")");   
        ListenableFuture<OrcResponse> future = oDataExecute(request);   
        
        return transformToByteArrayListenableFuture(future);

        
   }
    
}
