/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.fileservices.orc;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.microsoft.fileservices.File;
import com.microsoft.fileservices.orc.ItemOperations;
import com.microsoft.services.orc.Constants;
import com.microsoft.services.orc.Helpers;
import com.microsoft.services.orc.OrcExecutable;
import com.microsoft.services.orc.interfaces.DependencyResolver;
import com.microsoft.services.orc.interfaces.HttpVerb;
import com.microsoft.services.orc.interfaces.JsonSerializer;
import com.microsoft.services.orc.interfaces.Request;
import java.util.HashMap;

public class FileOperations
extends ItemOperations {
    public FileOperations(String urlComponent, OrcExecutable parent) {
        super(urlComponent, parent);
    }

    @Override
    public FileOperations addParameter(String name, Object value) {
        this.addCustomParameter(name, value);
        return this;
    }

    @Override
    public FileOperations addHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ListenableFuture<File> copy(String destFolderId, String destFolderPath, String newName) {
        JsonSerializer serializer = this.getResolver().getJsonSerializer();
        String serializeddestFolderId = serializer.serialize((Object)destFolderId);
        String serializeddestFolderPath = serializer.serialize((Object)destFolderPath);
        String serializednewName = serializer.serialize((Object)newName);
        ListenableFuture<String> future = this.copyRaw(serializeddestFolderId, serializeddestFolderPath, serializednewName);
        return Helpers.transformToEntityListenableFuture(future, File.class, (DependencyResolver)this.getResolver());
    }

    public ListenableFuture<String> copyRaw(String destFolderId, String destFolderPath, String newName) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("destFolderId", destFolderId);
        map.put("destFolderPath", destFolderPath);
        map.put("newName", newName);
        Request request = this.getResolver().createRequest();
        request.setVerb(HttpVerb.POST);
        request.setContent(this.getResolver().getJsonSerializer().jsonObjectFromJsonMap(map).getBytes(Constants.UTF8));
        request.getUrl().appendPathComponent("Microsoft.FileServices.copy");
        ListenableFuture future = this.oDataExecute(request);
        return Helpers.transformToStringListenableFuture((ListenableFuture)future);
    }

    public ListenableFuture<Integer> uploadContent(byte[] contentStream) {
        JsonSerializer serializer = this.getResolver().getJsonSerializer();
        String serializedcontentStream = serializer.serialize((Object)contentStream);
        ListenableFuture<String> future = this.uploadContentRaw(serializedcontentStream);
        return Helpers.transformToEntityListenableFuture(future, Integer.class, (DependencyResolver)this.getResolver());
    }

    public ListenableFuture<String> uploadContentRaw(String contentStream) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("contentStream", contentStream);
        Request request = this.getResolver().createRequest();
        request.setVerb(HttpVerb.POST);
        request.setContent(this.getResolver().getJsonSerializer().jsonObjectFromJsonMap(map).getBytes(Constants.UTF8));
        request.getUrl().appendPathComponent("Microsoft.FileServices.uploadContent");
        ListenableFuture future = this.oDataExecute(request);
        return Helpers.transformToStringListenableFuture((ListenableFuture)future);
    }

    public ListenableFuture<byte[]> content() {
        SettableFuture result = SettableFuture.create();
        HashMap map = new HashMap();
        Request request = this.getResolver().createRequest();
        request.setVerb(HttpVerb.POST);
        request.setContent(Helpers.serializeToJsonByteArray(map, (DependencyResolver)this.getResolver()));
        String parameters = Helpers.getFunctionParameters(map);
        request.getUrl().appendPathComponent("Microsoft.FileServices.content(" + parameters + ")");
        request.getUrl().appendPathComponent("content(" + parameters + ")");
        ListenableFuture future = this.oDataExecute(request);
        return Helpers.transformToByteArrayListenableFuture((ListenableFuture)future);
    }
}

