/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.rest.v2.policy;

import com.microsoft.rest.v2.http.HttpRequest;
import com.microsoft.rest.v2.http.HttpResponse;
import com.microsoft.rest.v2.policy.RequestPolicy;
import com.microsoft.rest.v2.policy.RequestPolicyFactory;
import com.microsoft.rest.v2.policy.RequestPolicyOptions;
import io.reactivex.Single;

public final class UserAgentPolicyFactory
implements RequestPolicyFactory {
    private static final String DEFAULT_USER_AGENT_HEADER = "AutoRest-Java";
    private final String userAgent;

    public UserAgentPolicyFactory(String userAgent) {
        this.userAgent = userAgent != null ? userAgent : DEFAULT_USER_AGENT_HEADER;
    }

    public UserAgentPolicyFactory() {
        this.userAgent = DEFAULT_USER_AGENT_HEADER;
    }

    @Override
    public RequestPolicy create(RequestPolicy next, RequestPolicyOptions options) {
        return new UserAgentPolicy(next);
    }

    private final class UserAgentPolicy
    implements RequestPolicy {
        private final RequestPolicy next;

        private UserAgentPolicy(RequestPolicy next) {
            this.next = next;
        }

        @Override
        public Single<HttpResponse> sendAsync(HttpRequest request) {
            String header = request.headers().value("User-Agent");
            header = header == null || UserAgentPolicyFactory.DEFAULT_USER_AGENT_HEADER.equals(header) ? UserAgentPolicyFactory.this.userAgent : UserAgentPolicyFactory.this.userAgent + " " + header;
            request.headers().set("User-Agent", header);
            return this.next.sendAsync(request);
        }
    }
}

