/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.rest.v2;

import com.microsoft.rest.v2.ServiceCallback;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.reactivex.Single;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Action;
import io.reactivex.functions.Consumer;
import java.util.concurrent.CompletableFuture;

public class ServiceFuture<T>
extends CompletableFuture<T> {
    private Disposable subscription;

    protected ServiceFuture() {
    }

    public static <T> ServiceFuture<T> fromBody(Single<T> single, final ServiceCallback<T> callback) {
        final ServiceFuture<T> serviceFuture = new ServiceFuture<T>();
        serviceFuture.subscription = single.subscribe(new Consumer<T>(){

            public void accept(T t) {
                if (callback != null) {
                    callback.success(t);
                }
                serviceFuture.complete(t);
            }
        }, (Consumer)new Consumer<Throwable>(){

            public void accept(Throwable throwable) {
                if (callback != null) {
                    callback.failure(throwable);
                }
                serviceFuture.completeExceptionally(throwable);
            }
        });
        return serviceFuture;
    }

    public static <T> ServiceFuture<T> fromBody(Maybe<T> maybe, final ServiceCallback<T> callback) {
        final ServiceFuture<T> serviceFuture = new ServiceFuture<T>();
        serviceFuture.subscription = maybe.subscribe(new Consumer<T>(){

            public void accept(T t) {
                if (callback != null) {
                    callback.success(t);
                }
                serviceFuture.complete(t);
            }
        }, (Consumer)new Consumer<Throwable>(){

            public void accept(Throwable throwable) {
                if (callback != null) {
                    callback.failure(throwable);
                }
                serviceFuture.completeExceptionally(throwable);
            }
        }, new Action(){

            public void run() throws Exception {
                if (callback != null) {
                    callback.success(null);
                }
                serviceFuture.complete(null);
            }
        });
        return serviceFuture;
    }

    public static ServiceFuture<Void> fromBody(Completable completable, final ServiceCallback<Void> callback) {
        final ServiceFuture<Void> serviceFuture = new ServiceFuture<Void>();
        completable.subscribe(new Action(){
            Void value = null;

            public void run() {
                if (callback != null) {
                    callback.success(this.value);
                }
                serviceFuture.complete(this.value);
            }
        }, (Consumer)new Consumer<Throwable>(){

            public void accept(Throwable throwable) {
                if (callback != null) {
                    callback.failure(throwable);
                }
                serviceFuture.completeExceptionally(throwable);
            }
        });
        return serviceFuture;
    }

    public Disposable getSubscription() {
        return this.subscription;
    }

    protected void setSubscription(Disposable subscription) {
        this.subscription = subscription;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        this.subscription.dispose();
        return super.cancel(mayInterruptIfRunning);
    }

    @Override
    public boolean isCancelled() {
        return this.subscription.isDisposed();
    }
}

