/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.connecteddevices.remotesystems.commanding.pal;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Build;
import android.os.PowerManager;
import android.support.annotation.Keep;
import android.support.annotation.RequiresApi;
import com.microsoft.connecteddevices.EventSource;
import com.microsoft.connecteddevices.remotesystems.commanding.pal.NetworkRestrictionState;
import com.microsoft.connecteddevices.remotesystems.commanding.pal.NetworkRestrictionStateChangedEventArgs;
import java.lang.ref.WeakReference;

@Keep
public class NetworkRestrictionWatcher
extends EventSource<NetworkRestrictionWatcher, NetworkRestrictionStateChangedEventArgs> {
    private DeviceIdleModeBroadcastReceiver mDeviceIdleModeReceiver;
    private Context mContext;

    public NetworkRestrictionWatcher(Context context) {
        if (context == null) {
            throw new IllegalArgumentException();
        }
        if (Build.VERSION.SDK_INT < 23) {
            return;
        }
        this.mContext = context;
        this.mDeviceIdleModeReceiver = new DeviceIdleModeBroadcastReceiver(new WeakReference<NetworkRestrictionWatcher>(this));
        IntentFilter idleModeFilter = new IntentFilter("android.os.action.DEVICE_IDLE_MODE_CHANGED");
        this.mContext.registerReceiver((BroadcastReceiver)this.mDeviceIdleModeReceiver, idleModeFilter);
    }

    protected void finalize() throws Throwable {
        try {
            if (this.mContext != null && this.mDeviceIdleModeReceiver != null) {
                this.mContext.unregisterReceiver((BroadcastReceiver)this.mDeviceIdleModeReceiver);
            }
        }
        finally {
            super.finalize();
        }
    }

    public NetworkRestrictionState getNetworkRestrictionState() {
        if (Build.VERSION.SDK_INT < 23) {
            return NetworkRestrictionState.NONE;
        }
        PowerManager powerManager = (PowerManager)this.mContext.getSystemService("power");
        if (powerManager == null) {
            return NetworkRestrictionState.NONE;
        }
        return powerManager.isDeviceIdleMode() ? NetworkRestrictionState.RESTRICTED : NetworkRestrictionState.NONE;
    }

    private static class DeviceIdleModeBroadcastReceiver
    extends BroadcastReceiver {
        private WeakReference<NetworkRestrictionWatcher> mWeakParent;

        DeviceIdleModeBroadcastReceiver(WeakReference<NetworkRestrictionWatcher> weakParent) {
            this.mWeakParent = weakParent;
        }

        @RequiresApi(api=23)
        public void onReceive(Context context, Intent intent) {
            NetworkRestrictionWatcher strongParent = (NetworkRestrictionWatcher)this.mWeakParent.get();
            if (strongParent != null) {
                NetworkRestrictionState currentState = strongParent.getNetworkRestrictionState();
                strongParent.notifyListeners(strongParent, () -> currentState);
            }
        }
    }
}

