/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.connecteddevices;

import android.content.Context;
import android.support.annotation.Keep;
import android.util.ArrayMap;
import com.microsoft.cll.android.AndroidCll;
import com.microsoft.cll.android.EventEnums;
import com.microsoft.cll.android.ITicketCallback;
import com.microsoft.cll.android.SettingsStore;
import com.microsoft.cll.android.TicketObject;
import com.microsoft.cll.android.Verbosity;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;

@Keep
class CLLWrapper {
    private static final String ENDPOINT_URL = "https://vortex.data.microsoft.com/collect/v1";
    private static final EventEnums.Latency LATENCY = EventEnums.Latency.LatencyNormal;
    private static final EventEnums.Persistence PERSISTENCE = EventEnums.Persistence.PersistenceNormal;
    private static final EnumSet<EventEnums.Sensitivity> SENSITIVITY = EnumSet.noneOf(EventEnums.Sensitivity.class);
    private static final Double SAMPLE_RATE = 100.0;
    private Context mContext;
    private ArrayMap<String, String> mTicketCache;
    private AndroidCll mCll;
    private boolean mAdministerCllEnabled;

    public CLLWrapper(Context context) {
        this.mContext = context;
    }

    private void setXuidCallback() {
        this.mCll.setXuidCallback(new ITicketCallback(){

            public String getMsaDeviceTicket(boolean forceRefresh) {
                return "";
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public String getAuthXToken(boolean forceRefresh) {
                if (forceRefresh) {
                    ArrayMap arrayMap = CLLWrapper.this.mTicketCache;
                    synchronized (arrayMap) {
                        for (Map.Entry cachedTicket : CLLWrapper.this.mTicketCache.entrySet()) {
                            String ticket = CLLWrapper.this.getUserTicketNative((String)cachedTicket.getKey());
                            if (ticket == null) continue;
                            cachedTicket.setValue(ticket);
                        }
                    }
                }
                return "";
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public TicketObject getXTicketForXuid(String xuid) {
                ArrayMap arrayMap = CLLWrapper.this.mTicketCache;
                synchronized (arrayMap) {
                    if (!CLLWrapper.this.mTicketCache.containsKey((Object)xuid)) {
                        CLLWrapper.this.mTicketCache.put((Object)xuid, (Object)CLLWrapper.this.getUserTicketNative(xuid));
                    }
                    return new TicketObject("d:" + (String)CLLWrapper.this.mTicketCache.get((Object)xuid), false);
                }
            }
        });
    }

    private static void stopCllAsync(final AndroidCll cll) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                cll.stop();
            }
        }).start();
    }

    private native String getUserTicketNative(String var1);

    public void initialize(String iKey, boolean administerCllEnabled) {
        this.mTicketCache = new ArrayMap();
        this.mCll = new AndroidCll(iKey, this.mContext);
        this.mAdministerCllEnabled = administerCllEnabled;
        if (this.mAdministerCllEnabled) {
            this.mCll.setEndpointUrl(ENDPOINT_URL);
            this.mCll.setDebugVerbosity(Verbosity.ERROR);
            this.setXuidCallback();
        }
    }

    public void log(String stableUserId, String eventName, String metricsData) {
        this.logInternal(stableUserId, eventName, metricsData, LATENCY, PERSISTENCE, SENSITIVITY, SAMPLE_RATE);
    }

    public void logHighPriority(String stableUserId, String eventName, String metricsData) {
        this.logInternal(stableUserId, eventName, metricsData, LATENCY, EventEnums.Persistence.PersistenceCritical, SENSITIVITY, SAMPLE_RATE);
    }

    public void setUploadInterval(String seconds) {
        if (this.mAdministerCllEnabled) {
            this.mCll.OnCllSettingUpdate(SettingsStore.Settings.QUEUEDRAININTERVAL.name(), seconds);
        }
    }

    public void setUploadEventLimit(String events) {
        if (this.mAdministerCllEnabled) {
            this.mCll.OnCllSettingUpdate(SettingsStore.Settings.MAXEVENTSPERPOST.name(), events);
        }
    }

    public void start() {
        if (this.mAdministerCllEnabled) {
            this.mCll.start();
        }
    }

    public void stop() {
        if (this.mAdministerCllEnabled) {
            this.mCll.stop();
        }
    }

    public void pause() {
        if (this.mAdministerCllEnabled) {
            this.mCll.pause();
        }
    }

    public void resume() {
        if (this.mAdministerCllEnabled) {
            this.mCll.resume();
        }
    }

    public void send() {
        this.mCll.send();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logInternal(String stableUserId, String eventName, String metricsData, EventEnums.Latency latency, EventEnums.Persistence persistence, EnumSet<EventEnums.Sensitivity> sensitivity, double sampleRate) {
        if (!stableUserId.isEmpty()) {
            if (this.mAdministerCllEnabled) {
                ArrayMap<String, String> arrayMap = this.mTicketCache;
                synchronized (arrayMap) {
                    if (!this.mTicketCache.containsKey((Object)stableUserId)) {
                        this.mTicketCache.put((Object)stableUserId, (Object)this.getUserTicketNative(stableUserId));
                    }
                }
            }
            List<String> ids = Collections.singletonList(stableUserId);
            this.mCll.log(eventName, metricsData, latency, persistence, sensitivity, sampleRate, ids);
        }
    }
}

