/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cll.android;

import com.microsoft.cll.android.ClientTelemetry;
import com.microsoft.cll.android.CorrelationVector;
import com.microsoft.cll.android.EventEnums;
import com.microsoft.cll.android.EventHandler;
import com.microsoft.cll.android.EventSender;
import com.microsoft.cll.android.ICllEvents;
import com.microsoft.cll.android.ILogger;
import com.microsoft.cll.android.ISingletonCll;
import com.microsoft.cll.android.ITicketCallback;
import com.microsoft.cll.android.PartA;
import com.microsoft.cll.android.SerializedEvent;
import com.microsoft.cll.android.SettingsStore;
import com.microsoft.cll.android.SettingsSync;
import com.microsoft.cll.android.SnapshotScheduler;
import com.microsoft.cll.android.Verbosity;
import com.microsoft.telemetry.Base;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;

public class SingletonCll
implements ISingletonCll {
    public CorrelationVector correlationVector;
    protected final ClientTelemetry clientTelemetry;
    protected final String TAG = "AndroidCll-SingletonCll";
    protected final List<ICllEvents> cllEvents;
    protected EventHandler eventHandler;
    protected ILogger logger;
    protected PartA partA;
    protected SettingsSync settingsSync;
    protected SnapshotScheduler snapshotScheduler;
    private final AtomicBoolean isChanging;
    private final AtomicBoolean isPaused;
    private final AtomicBoolean isStarted;
    private ScheduledExecutorService executor;
    private static SingletonCll Instance;
    private static Object InstanceLock;
    private ITicketCallback ticketCallback;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ISingletonCll getInstance(String iKey, ILogger logger, String eventDir, PartA partA, CorrelationVector correlationVector) {
        if (Instance == null) {
            Object object = InstanceLock;
            synchronized (object) {
                if (Instance == null) {
                    Instance = new SingletonCll(iKey, logger, eventDir, partA, correlationVector);
                }
            }
        }
        return Instance;
    }

    private SingletonCll(String iKey, ILogger logger, String eventDir, PartA partA, CorrelationVector correlationVector) {
        if (iKey == null || iKey.equals("")) {
            throw new IllegalArgumentException("iKey cannot be null or \"\"");
        }
        logger.setVerbosity(Verbosity.NONE);
        this.correlationVector = correlationVector;
        this.logger = logger;
        this.partA = partA;
        this.clientTelemetry = new ClientTelemetry();
        this.cllEvents = new ArrayList<ICllEvents>();
        this.eventHandler = new EventHandler(this.clientTelemetry, this.cllEvents, logger, eventDir);
        this.isChanging = new AtomicBoolean(false);
        this.isStarted = new AtomicBoolean(false);
        this.isPaused = new AtomicBoolean(false);
        this.settingsSync = new SettingsSync(this.clientTelemetry, logger, iKey, partA);
        this.snapshotScheduler = new SnapshotScheduler(this.clientTelemetry, logger, this);
        this.setEndpointUrl(SettingsStore.getCllSettingsAsString(SettingsStore.Settings.VORTEXPRODURL));
    }

    @Override
    public void start() {
        if (this.isChanging.compareAndSet(false, true)) {
            if (!this.isStarted.get()) {
                this.executor = Executors.newScheduledThreadPool(3);
                this.snapshotScheduler.start(this.executor);
                this.eventHandler.start(this.executor);
                this.settingsSync.start(this.executor);
                this.isStarted.set(true);
            }
            this.isChanging.set(false);
        }
    }

    @Override
    public void stop() {
        if (this.isChanging.compareAndSet(false, true)) {
            if (this.isStarted.get()) {
                this.eventHandler.stop();
                this.settingsSync.stop();
                this.snapshotScheduler.stop();
                this.executor.shutdown();
                this.isStarted.set(false);
            }
            for (ICllEvents event : this.cllEvents) {
                event.stopped();
            }
            this.isChanging.set(false);
        }
    }

    @Override
    public void pause() {
        if (this.isChanging.compareAndSet(false, true)) {
            if (this.isStarted.get() && !this.isPaused.get()) {
                this.eventHandler.pause();
                this.settingsSync.pause();
                this.snapshotScheduler.pause();
                this.executor.shutdown();
                this.isPaused.set(true);
            }
            this.isChanging.set(false);
        }
    }

    @Override
    public void resume() {
        if (this.isChanging.compareAndSet(false, true)) {
            if (this.isStarted.get() && this.isPaused.get()) {
                this.executor = Executors.newScheduledThreadPool(SettingsStore.getCllSettingsAsInt(SettingsStore.Settings.THREADSTOUSEWITHEXECUTOR));
                this.snapshotScheduler.resume(this.executor);
                this.eventHandler.resume(this.executor);
                this.settingsSync.resume(this.executor);
                this.isPaused.set(false);
            }
            this.isChanging.set(false);
        }
    }

    @Override
    public void setDebugVerbosity(Verbosity verbosity) {
        this.logger.setVerbosity(verbosity);
    }

    @Override
    public void log(Base event, EventEnums.Latency latency, EventEnums.Persistence persistence, EnumSet<EventEnums.Sensitivity> sensitivity, double sampleRate, List<String> ids) {
        if (!this.isStarted.get()) {
            this.logger.error("AndroidCll-SingletonCll", "Cll must be started before logging events");
            return;
        }
        if (ids != null && this.ticketCallback == null) {
            this.logger.error("AndroidCll-SingletonCll", "You must set the ticket callback if you want to log ids with your events");
            return;
        }
        SerializedEvent serializedEvent = this.partA.populate(event, latency, persistence, sensitivity, sampleRate, ids);
        this.eventHandler.log(serializedEvent, ids);
    }

    @Override
    public void send() {
        if (this.isStarted.get()) {
            this.eventHandler.send();
        } else {
            this.logger.info("AndroidCll-SingletonCll", "Cannot send while the CLL is stopped.");
        }
    }

    @Override
    public void setEndpointUrl(String url) {
        this.eventHandler.setEndpointUrl(url);
    }

    @Override
    public void useLegacyCS(boolean value) {
        this.partA.useLegacyCS(value);
    }

    @Override
    public void setExperimentId(String id) {
        this.partA.setExpId(id);
    }

    @Override
    public void synchronize() {
        this.eventHandler.synchronize();
    }

    @Override
    public void SubscribeCllEvents(ICllEvents cllEvents) {
    }

    protected void setEventSender(EventSender sender) {
        this.eventHandler.setSender(sender);
    }

    @Override
    public void setAppUserId(String userId) {
        this.partA.setAppUserId(userId);
    }

    @Override
    public String getAppUserId() {
        return this.partA.getAppUserId();
    }

    @Override
    public void setXuidCallback(ITicketCallback callback) {
        this.ticketCallback = callback;
        if (this.isStarted.get() || this.isPaused.get()) {
            this.logger.warn("AndroidCll-SingletonCll", "Xuid callback must be set before start.");
            return;
        }
        this.eventHandler.setXuidCallback(callback);
    }

    static {
        InstanceLock = new Object();
    }
}

