/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cll.android;

import Microsoft.Telemetry.Base;
import Microsoft.Telemetry.Domain;
import com.microsoft.bond.SchemaDef;
import com.microsoft.bond.StructDef;
import com.microsoft.cll.android.BondJsonSerializer;
import com.microsoft.cll.android.ILogger;
import com.microsoft.telemetry.Data;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class PreSerializedEvent
extends Data {
    public String serializedData;
    private static final String TAG = "AndroidCll-PreSerializedEvent";

    public PreSerializedEvent(String eventName, String eventData, String partBName, Map<String, String> attributes) {
        this.serializedData = eventData;
        Data baseData = this;
        baseData.setBaseData(new com.microsoft.telemetry.Domain());
        ((com.microsoft.telemetry.Domain)baseData.getBaseData()).QualifiedName = partBName;
        this.QualifiedName = eventName;
        if (attributes != null) {
            this.Attributes.putAll(attributes);
        }
    }

    @Override
    public void serialize(Writer writer) throws IOException {
        writer.write(this.serializedData);
    }

    public static PreSerializedEvent createFromDynamicEvent(String eventName, String eventData) {
        return new PreSerializedEvent(eventName, eventData, "", null);
    }

    public static PreSerializedEvent createFromStaticEvent(ILogger logger, Base event) {
        String eventName = PreSerializedEvent.getPartCName(event);
        String partBName = PreSerializedEvent.getPartBName(event);
        Map<String, String> attributes = PreSerializedEvent.getAttributes(event);
        if (!partBName.isEmpty()) {
            event.setBaseType(partBName);
        }
        String eventData = PreSerializedEvent.serializeEvent(logger, event);
        return new PreSerializedEvent(eventName, eventData, partBName, attributes);
    }

    public static String getPartCName(Base event) {
        SchemaDef schemaDef = event.getSchema();
        ArrayList structs = schemaDef.getStructs();
        String partCName = ((StructDef)structs.get(0)).getMetadata().getQualified_name();
        return partCName;
    }

    public static String getPartBName(Base event) {
        String partBName = "";
        try {
            if (event instanceof Microsoft.Telemetry.Data) {
                Microsoft.Telemetry.Data data = (Microsoft.Telemetry.Data)event;
                Object baseTemplate = data.getBaseData();
                if (baseTemplate != null && baseTemplate instanceof Domain) {
                    Domain baseDomain = (Domain)baseTemplate;
                    partBName = ((StructDef)baseDomain.getSchema().getStructs().get(0)).getMetadata().getQualified_name();
                } else {
                    partBName = data.generic_type_TDomain.getName();
                }
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return partBName;
    }

    public static Map<String, String> getAttributes(Base event) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        SchemaDef schemaDef = event.getSchema();
        ArrayList structs = schemaDef.getStructs();
        attributes.putAll(((StructDef)schemaDef.getStructs().get(0)).getMetadata().getAttributes());
        return attributes;
    }

    public static String serializeEvent(ILogger logger, Base event) {
        BondJsonSerializer bondJsonSerializer = new BondJsonSerializer(logger);
        return bondJsonSerializer.serialize(event);
    }
}

