/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cll.android;

import Microsoft.Telemetry.Base;
import android.content.Context;
import android.content.SharedPreferences;
import com.microsoft.cll.android.AndroidLogger;
import com.microsoft.cll.android.AndroidPartA;
import com.microsoft.cll.android.CorrelationVector;
import com.microsoft.cll.android.EventEnums;
import com.microsoft.cll.android.ICll;
import com.microsoft.cll.android.ICllEvents;
import com.microsoft.cll.android.ILogger;
import com.microsoft.cll.android.ISingletonCll;
import com.microsoft.cll.android.ITicketCallback;
import com.microsoft.cll.android.PreSerializedEvent;
import com.microsoft.cll.android.SettingsStore;
import com.microsoft.cll.android.SingletonCll;
import com.microsoft.cll.android.Verbosity;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;

public class AndroidCll
implements ICll,
SettingsStore.UpdateListener {
    private final String TAG = "AndroidCll-AndroidCll";
    private final ILogger logger = AndroidLogger.getInstance();
    private final String sharedCllPreferencesName = "AndroidCllSettingsSharedPreferences";
    private final String sharedHostPreferencesName = "AndroidHostSettingsSharedPreferences";
    private final SharedPreferences cllPreferences;
    private final SharedPreferences hostPreferences;
    protected ISingletonCll cll;

    public AndroidCll(String iKey, Context context) {
        CorrelationVector correlationVector = new CorrelationVector();
        String dataPath = context.getFilesDir().getPath();
        AndroidPartA partA = new AndroidPartA(AndroidLogger.getInstance(), iKey, context, correlationVector);
        this.cll = SingletonCll.getInstance(iKey, AndroidLogger.getInstance(), dataPath, partA, correlationVector);
        this.cllPreferences = context.getSharedPreferences("AndroidCllSettingsSharedPreferences", 0);
        this.hostPreferences = context.getSharedPreferences("AndroidHostSettingsSharedPreferences", 0);
        SettingsStore.setUpdateListener(this);
        this.setSettingsStoreValues();
    }

    protected AndroidCll() {
        this.cllPreferences = null;
        this.hostPreferences = null;
    }

    @Override
    public void start() {
        this.cll.start();
    }

    @Override
    public void stop() {
        this.cll.stop();
    }

    @Override
    public void pause() {
        this.cll.pause();
    }

    @Override
    public void resume() {
        this.cll.resume();
    }

    @Override
    public void log(Base event) {
        this.log(event, null);
    }

    @Override
    public void log(Base event, List<String> ids) {
        this.log(event, EventEnums.Latency.LatencyUnspecified, EventEnums.Persistence.PersistenceUnspecified, EnumSet.of(EventEnums.Sensitivity.SensitivityUnspecified), -1.0, ids);
    }

    @Override
    public void log(Base event, EventEnums.Latency latency, EventEnums.Persistence persistence, EnumSet<EventEnums.Sensitivity> sensitivity, double sampleRate, List<String> ids) {
        PreSerializedEvent preSerializedEvent = PreSerializedEvent.createFromStaticEvent(this.logger, event);
        this.cll.log(preSerializedEvent, latency, persistence, sensitivity, sampleRate, ids);
    }

    @Override
    public void log(String eventName, String eventData, EventEnums.Latency latency, EventEnums.Persistence persistence, EnumSet<EventEnums.Sensitivity> sensitivity, double sampleRate, List<String> ids) {
        if (!eventName.contains(".")) {
            this.logger.error("AndroidCll-AndroidCll", "Event Name does not follow a valid format. Your event must have at least one . between two words. E.g. Microsoft.MyEvent");
            return;
        }
        PreSerializedEvent preSerializedEvent = PreSerializedEvent.createFromDynamicEvent(eventName, eventData);
        this.cll.log(preSerializedEvent, latency, persistence, sensitivity, sampleRate, ids);
    }

    public void logInternal(com.microsoft.telemetry.Base testEvent) {
        this.cll.log(testEvent, null, null, null, -1.0, null);
    }

    @Override
    public void setDebugVerbosity(Verbosity verbosity) {
        this.cll.setDebugVerbosity(verbosity);
    }

    @Override
    public void send() {
        this.cll.send();
    }

    @Override
    public void setEndpointUrl(String url) {
        this.cll.setEndpointUrl(url);
    }

    @Override
    public void useLegacyCS(boolean value) {
        this.cll.useLegacyCS(value);
    }

    @Override
    public void setExperimentId(String id) {
        this.cll.setExperimentId(id);
    }

    @Override
    public void synchronize() {
        this.cll.synchronize();
    }

    @Override
    public void SubscribeCllEvents(ICllEvents cllEvents) {
        this.cll.SubscribeCllEvents(cllEvents);
    }

    @Override
    public void setAppUserId(String userId) {
        this.cll.setAppUserId(userId);
    }

    @Override
    public String getAppUserId() {
        return this.cll.getAppUserId();
    }

    public CorrelationVector getCorrelationVector() {
        return ((SingletonCll)this.cll).correlationVector;
    }

    @Override
    public void setXuidCallback(ITicketCallback callback) {
        this.cll.setXuidCallback(callback);
    }

    @Override
    public void OnHostSettingUpdate(String settingName, String settingValue) {
        SharedPreferences.Editor editor = this.hostPreferences.edit();
        editor.putString(settingName, settingValue);
        editor.apply();
    }

    @Override
    public void OnCllSettingUpdate(String settingName, String settingValue) {
        SharedPreferences.Editor editor = this.cllPreferences.edit();
        editor.putString(settingName, settingValue);
        editor.apply();
    }

    private void setSettingsStoreValues() {
        Map settings = this.cllPreferences.getAll();
        for (Map.Entry setting : settings.entrySet()) {
            SettingsStore.Settings settingKey;
            try {
                settingKey = SettingsStore.Settings.valueOf((String)setting.getKey());
            }
            catch (Exception e) {
                SharedPreferences.Editor editor = this.cllPreferences.edit();
                editor.remove((String)setting.getKey());
                editor.apply();
                continue;
            }
            SettingsStore.updateCllSetting(settingKey, (String)setting.getValue());
        }
        settings = this.hostPreferences.getAll();
        for (Map.Entry setting : settings.entrySet()) {
            SettingsStore.updateHostSetting((String)setting.getKey(), (String)setting.getValue());
        }
    }
}

