/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.connecteddevices;

import android.os.Bundle;
import android.support.annotation.Keep;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Keep
final class ConversionHelpers {
    private static final Map<String, FieldType> sKnownFields = new HashMap<String, FieldType>();

    ConversionHelpers() {
    }

    static String mapToJSONString(Map map) throws JSONException {
        MapWrapper mapWrapper = new MapWrapper(map);
        return ConversionHelpers.GetJsonString(mapWrapper);
    }

    static String bundleToJSONString(Bundle bundle) throws JSONException {
        BundleWrapper bundleWrapper = new BundleWrapper(bundle);
        return ConversionHelpers.GetJsonString(bundleWrapper);
    }

    private static String GetJsonString(KeyValueAccessible mapOrBundle) throws JSONException {
        JSONObject jsonObject = new JSONObject();
        Set<String> keys = mapOrBundle.keySet();
        for (String key : keys) {
            Object value = mapOrBundle.get(key);
            FieldType fieldType = sKnownFields.get(key);
            if (fieldType == null) {
                fieldType = FieldType.DEFAULT;
            }
            try {
                switch (fieldType) {
                    case INTEGER: {
                        jsonObject.put(key, Integer.parseInt((String)value));
                        break;
                    }
                    case BOOLEAN: {
                        jsonObject.put(key, Boolean.parseBoolean((String)value));
                        break;
                    }
                    case ARRAY: {
                        jsonObject.put(key, (Object)new JSONArray((String)value));
                        break;
                    }
                    case DEFAULT: {
                        jsonObject.put(key, JSONObject.wrap((Object)value));
                    }
                }
            }
            catch (ClassCastException | NumberFormatException e) {
                throw new JSONException("Field " + key + " has unexpected value: " + value);
            }
        }
        return jsonObject.toString();
    }

    static {
        sKnownFields.put("cdpNotificationTypeId", FieldType.INTEGER);
        sKnownFields.put("notificationTypeId", FieldType.INTEGER);
        sKnownFields.put("commandsWithheld", FieldType.BOOLEAN);
        sKnownFields.put("commands", FieldType.ARRAY);
        sKnownFields.put("commandTypeId", FieldType.INTEGER);
        sKnownFields.put("activities", FieldType.ARRAY);
        sKnownFields.put("settings", FieldType.ARRAY);
        sKnownFields.put("fastPathDelivery", FieldType.BOOLEAN);
    }

    private static class BundleWrapper
    implements KeyValueAccessible {
        Bundle bundle;

        public BundleWrapper(Bundle bundle) {
            this.bundle = bundle;
        }

        @Override
        public Object get(String key) {
            Object value = null;
            if (this.bundle != null) {
                value = this.bundle.get(key);
            }
            return value;
        }

        @Override
        public Set<String> keySet() {
            Set keys = null;
            if (this.bundle != null) {
                keys = this.bundle.keySet();
            }
            return keys;
        }
    }

    private static class MapWrapper
    implements KeyValueAccessible {
        Map map;

        public MapWrapper(Map map) {
            this.map = map;
        }

        @Override
        public Object get(String key) {
            Object value = null;
            if (this.map != null) {
                value = this.map.get(key);
            }
            return value;
        }

        @Override
        public Set<String> keySet() {
            Set keys = null;
            if (this.map != null) {
                keys = this.map.keySet();
            }
            return keys;
        }
    }

    private static interface KeyValueAccessible {
        public Object get(String var1);

        public Set<String> keySet();
    }

    private static enum FieldType {
        DEFAULT,
        INTEGER,
        BOOLEAN,
        ARRAY;

    }
}

