/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.connecteddevices;

import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import com.microsoft.connecteddevices.AsyncOperation;
import com.microsoft.connecteddevices.ConnectedDevicesAccessTokenInvalidatedEventArgs;
import com.microsoft.connecteddevices.ConnectedDevicesAccessTokenRequestedEventArgs;
import com.microsoft.connecteddevices.ConnectedDevicesAccount;
import com.microsoft.connecteddevices.ConnectedDevicesAddAccountResult;
import com.microsoft.connecteddevices.ConnectedDevicesRemoveAccountResult;
import com.microsoft.connecteddevices.Event;
import com.microsoft.connecteddevices.NativeBase;
import com.microsoft.connecteddevices.NativeEvent;
import com.microsoft.connecteddevices.NativeObject;
import com.microsoft.connecteddevices.NativeObjectAsyncOperation;
import com.microsoft.connecteddevices.NativeObjectEventListener;
import com.microsoft.connecteddevices.NativeUtils;
import java.util.List;

@Keep
public final class ConnectedDevicesAccountManager
extends NativeBase {
    private Event<ConnectedDevicesAccountManager, ConnectedDevicesAccessTokenRequestedEventArgs> mAccessTokenRequested = new NativeEvent<ConnectedDevicesAccountManager, ConnectedDevicesAccessTokenRequestedEventArgs>(this, this::addAccessTokenRequestedNative, this::removeAccessTokenRequestedNative, ConnectedDevicesAccountManager::new, ConnectedDevicesAccessTokenRequestedEventArgs::new);
    private Event<ConnectedDevicesAccountManager, ConnectedDevicesAccessTokenInvalidatedEventArgs> mAccessTokenInvalidated = new NativeEvent<ConnectedDevicesAccountManager, ConnectedDevicesAccessTokenInvalidatedEventArgs>(this, this::addAccessTokenInvalidatedNative, this::removeAccessTokenInvalidatedNative, ConnectedDevicesAccountManager::new, ConnectedDevicesAccessTokenInvalidatedEventArgs::new);

    ConnectedDevicesAccountManager(NativeObject nativeObject) {
        super(nativeObject);
    }

    @NonNull
    public AsyncOperation<ConnectedDevicesAddAccountResult> addAccountAsync(@NonNull ConnectedDevicesAccount account) {
        NativeObjectAsyncOperation<ConnectedDevicesAddAccountResult> operation = new NativeObjectAsyncOperation<ConnectedDevicesAddAccountResult>(ConnectedDevicesAddAccountResult::new);
        this.addAccountAsyncNative(NativeUtils.getNativePointer(this), NativeUtils.getNativePointer(account), operation);
        return operation;
    }

    @NonNull
    public AsyncOperation<ConnectedDevicesRemoveAccountResult> removeAccountAsync(@NonNull ConnectedDevicesAccount account) {
        NativeObjectAsyncOperation<ConnectedDevicesRemoveAccountResult> operation = new NativeObjectAsyncOperation<ConnectedDevicesRemoveAccountResult>(ConnectedDevicesRemoveAccountResult::new);
        this.removeAccountAsyncNative(NativeUtils.getNativePointer(this), NativeUtils.getNativePointer(account), operation);
        return operation;
    }

    @NonNull
    public List<ConnectedDevicesAccount> getAccounts() {
        return NativeObject.toSpecificList(this.getAccountsNative(NativeUtils.getNativePointer(this)), ConnectedDevicesAccount::new);
    }

    @NonNull
    public Event<ConnectedDevicesAccountManager, ConnectedDevicesAccessTokenRequestedEventArgs> accessTokenRequested() {
        return this.mAccessTokenRequested;
    }

    @NonNull
    public Event<ConnectedDevicesAccountManager, ConnectedDevicesAccessTokenInvalidatedEventArgs> accessTokenInvalidated() {
        return this.mAccessTokenInvalidated;
    }

    private native void addAccountAsyncNative(long var1, long var3, AsyncOperation<ConnectedDevicesAddAccountResult> var5);

    private native void removeAccountAsyncNative(long var1, long var3, AsyncOperation<ConnectedDevicesRemoveAccountResult> var5);

    private native NativeObject[] getAccountsNative(long var1);

    private native long addAccessTokenRequestedNative(long var1, NativeObjectEventListener<ConnectedDevicesAccountManager, ConnectedDevicesAccessTokenRequestedEventArgs> var3);

    private native void removeAccessTokenRequestedNative(long var1, long var3);

    private native long addAccessTokenInvalidatedNative(long var1, NativeObjectEventListener<ConnectedDevicesAccountManager, ConnectedDevicesAccessTokenInvalidatedEventArgs> var3);

    private native void removeAccessTokenInvalidatedNative(long var1, long var3);
}

