/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.connecteddevices;

import android.annotation.SuppressLint;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.Keep;
import android.support.annotation.RequiresPermission;
import com.microsoft.connecteddevices.BluetoothWrapper;
import com.microsoft.connecteddevices.BluetoothWrapperImplLegacy;
import com.microsoft.connecteddevices.BluetoothWrapperImplModern;
import com.microsoft.connecteddevices.RfcommSocket;
import java.io.IOException;
import java.util.Locale;
import java.util.Vector;

@Keep
abstract class BluetoothWrapperImpl
implements BluetoothWrapper.IApiWrapper {
    static final int MANUFACTURER_SPECIFIC_DATA_TYPE = 255;
    static final int MICROSOFT_COMPANY_ID = 6;
    private final Vector<RfcommSocket> _rfcommSockets = new Vector();
    private Context _appContext;
    private BluetoothStateBroadcastReceiver _bluetoothStateReceiver;
    private boolean _initialized = false;
    private boolean _scanStarted = false;

    BluetoothWrapperImpl() {
    }

    static BluetoothWrapperImpl createInstance() {
        if (Build.VERSION.SDK_INT >= 21) {
            return new BluetoothWrapperImplModern();
        }
        return new BluetoothWrapperImplLegacy();
    }

    protected void finalize() throws Throwable {
        try {
            if (this.wasScanStarted()) {
                BluetoothWrapper.traceWarning("Finalizing without stopping BLE scan. Scan will continue until stopped by the system.");
                this.setScanStarted(false);
            }
            this.uninitialize();
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public boolean initializeBLE(Context context) {
        boolean shouldRegisterReceiver;
        boolean bl = shouldRegisterReceiver = this._appContext == null || this._bluetoothStateReceiver == null;
        if (this.wasScanStarted()) {
            BluetoothWrapper.traceWarning("Attempting to stop previously started BLE scan...");
            shouldRegisterReceiver &= this.stopScanInternal();
        }
        if (shouldRegisterReceiver) {
            this._appContext = context;
            if (this._bluetoothStateReceiver == null) {
                this._bluetoothStateReceiver = new BluetoothStateBroadcastReceiver();
            }
            IntentFilter filter = new IntentFilter("android.bluetooth.adapter.action.STATE_CHANGED");
            context.registerReceiver((BroadcastReceiver)this._bluetoothStateReceiver, filter);
        }
        this._initialized = true;
        return true;
    }

    void uninitialize() {
        boolean shouldUnregisterReceiver;
        BluetoothWrapper.traceWarning("Uninitializing BluetoothWrapper...");
        for (int socketIndex = 0; socketIndex < this._rfcommSockets.size(); ++socketIndex) {
            this.closeSocketInternal(socketIndex);
        }
        boolean bl = shouldUnregisterReceiver = this._appContext != null && this._bluetoothStateReceiver != null;
        if (this.wasScanStarted()) {
            BluetoothWrapper.traceWarning("Attempting to stop ongoing BLE scan...");
            shouldUnregisterReceiver &= this.stopScanInternal();
        }
        if (shouldUnregisterReceiver) {
            try {
                this._appContext.unregisterReceiver((BroadcastReceiver)this._bluetoothStateReceiver);
            }
            catch (IllegalStateException e) {
                BluetoothWrapper.traceWarning("Failed to unregister receiver: BluetoothStateBroadcastReceiver is not registered. message: " + e.getMessage());
            }
            this._bluetoothStateReceiver = null;
            this._appContext = null;
        }
        this._initialized = false;
    }

    boolean isInitialized() {
        return this._initialized;
    }

    boolean setScanStarted(boolean started) {
        this._scanStarted = started;
        return this._scanStarted;
    }

    boolean wasScanStarted() {
        return this._scanStarted;
    }

    @Override
    public abstract void startScan(Context var1);

    @Override
    public abstract void stopScan(Context var1);

    abstract boolean stopScanInternal();

    @Override
    @SuppressLint(value={"HardwareIds"})
    @RequiresPermission(value="android.permission.BLUETOOTH")
    public String getBluetoothMacAddress() {
        try {
            BluetoothAdapter adapter = BluetoothAdapter.getDefaultAdapter();
            if (adapter != null) {
                return adapter.getAddress();
            }
        }
        catch (SecurityException e) {
            BluetoothWrapper.traceWarning("Exception getting bluetooth mac address. message: " + e.getMessage());
        }
        if (Build.VERSION.SDK_INT >= 23) {
            BluetoothWrapper.traceWarning("Bluetooth MAC requested on API 23+. As of API 23, hardware addresses are no long publicly available.");
        }
        return "";
    }

    @Override
    @RequiresPermission(value="android.permission.BLUETOOTH", conditional=true)
    public boolean hasBluetoothCapability(Context context) {
        return this.hasRequiredFeatures(context) && this.hasRequiredPermissions(context) && this.hasBluetoothAdapterEnabled();
    }

    @Override
    @RequiresPermission(value="android.permission.BLUETOOTH")
    public boolean hasBluetoothAdapterEnabled() {
        try {
            BluetoothAdapter adapter = BluetoothAdapter.getDefaultAdapter();
            if (adapter == null) {
                BluetoothWrapper.traceWarning("Could not get default BT Adapter");
                return false;
            }
            if (adapter.isEnabled()) {
                return true;
            }
            BluetoothWrapper.traceWarning("BT Adapter is disabled");
            return false;
        }
        catch (SecurityException e) {
            BluetoothWrapper.traceWarning("Exception checking if device has bluetooth adapter enabled. message: " + e.getMessage());
            return false;
        }
    }

    @Override
    public boolean hasRequiredFeatures(Context context) {
        boolean hasBluetoothFeature = context.getPackageManager().hasSystemFeature("android.hardware.bluetooth");
        boolean hasBluetoothLeFeature = context.getPackageManager().hasSystemFeature("android.hardware.bluetooth_le");
        if (!hasBluetoothFeature) {
            BluetoothWrapper.traceWarning("Device is not Bluetooth capable");
        } else if (!hasBluetoothLeFeature) {
            BluetoothWrapper.traceWarning("Device is not Bluetooth LE capable");
        }
        return hasBluetoothFeature && hasBluetoothLeFeature;
    }

    @Override
    public boolean hasRequiredPermissions(Context context) {
        boolean hasBluetoothPermission;
        boolean bl = hasBluetoothPermission = context.checkCallingOrSelfPermission("android.permission.BLUETOOTH") == 0;
        if (!hasBluetoothPermission) {
            BluetoothWrapper.traceWarning("Required permission BLUETOOTH has not been granted");
        }
        return hasBluetoothPermission;
    }

    @Override
    @RequiresPermission(value="android.permission.BLUETOOTH")
    public int getRfcommSocket(String address, String service, Context context) {
        if (!this.ensureInitialized(context, "connectRfcommSocket")) {
            return -1;
        }
        String[] split = address.split(":");
        StringBuilder addressBuilder = new StringBuilder();
        boolean prependSeparator = false;
        for (String bit : split) {
            if (prependSeparator) {
                addressBuilder.append(":");
            } else {
                prependSeparator = true;
            }
            if (bit.length() == 1) {
                addressBuilder.append("0");
            }
            addressBuilder.append(bit.toUpperCase(Locale.ROOT));
        }
        String fixedAddress = addressBuilder.toString();
        int socketIndex = this.nextFreeSocket();
        try {
            BluetoothDevice device = BluetoothAdapter.getDefaultAdapter().getRemoteDevice(fixedAddress);
            RfcommSocket socket = new RfcommSocket(device, service);
            if (!this.setSockeAtIndex(socketIndex, socket)) {
                BluetoothWrapper.traceWarning("Failed to add new socket to active socket list");
                socketIndex = -1;
            }
        }
        catch (IOException e) {
            socketIndex = -1;
            BluetoothWrapper.traceWarning("Exception getting RFCOMM socket. message: " + e.getMessage());
        }
        catch (IllegalArgumentException e) {
            socketIndex = -1;
            BluetoothWrapper.traceWarning(String.format("Failed to get remote device, invalid address provided: %s. message: %s", fixedAddress, e.getMessage()));
        }
        return socketIndex;
    }

    @Override
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_ADMIN", "android.permission.BLUETOOTH"})
    public int connectRfcommSocket(int socketIndex, Context context) {
        if (!this.ensureInitialized(context, "connectRfcommSocket")) {
            return -1;
        }
        RfcommSocket socket = this.getSocketAtIndex(socketIndex);
        if (socket == null) {
            return -1;
        }
        return socket.connect();
    }

    @Override
    public int sendRfcommData(int socketIndex, byte[] data, Context context) {
        if (!this.ensureInitialized(context, "sendRfcommData")) {
            return -1;
        }
        RfcommSocket socket = this.getSocketAtIndex(socketIndex);
        if (socket == null) {
            return -1;
        }
        return socket.sendData(data);
    }

    @Override
    public int receiveRfcommData(int socketIndex, byte[] buff, Context context) {
        if (!this.ensureInitialized(context, "receiveRfcommData")) {
            return -1;
        }
        RfcommSocket socket = this.getSocketAtIndex(socketIndex);
        if (socket == null) {
            return -1;
        }
        return socket.receiveData(buff);
    }

    @Override
    public int closeRfcommSocket(int socketIndex, Context context) {
        if (!this.ensureInitialized(context, "receiveRfcommData")) {
            return -1;
        }
        return this.closeSocketInternal(socketIndex);
    }

    @Override
    public boolean hasErtmCapability() {
        return Build.VERSION.SDK_INT > 25;
    }

    private int closeSocketInternal(int socketIndex) {
        RfcommSocket socket = this.getSocketAtIndex(socketIndex);
        if (socket == null) {
            return -1;
        }
        socket.close();
        if (!this.setSockeAtIndex(socketIndex, null)) {
            BluetoothWrapper.traceWarning("Failed to clear socket after closing. Index: " + socketIndex);
            return -1;
        }
        return 0;
    }

    private RfcommSocket getSocketAtIndex(int socketIndex) {
        RfcommSocket socket = null;
        try {
            socket = this._rfcommSockets.get(socketIndex);
            if (socket == null) {
                BluetoothWrapper.traceWarning("No socket exists at provided index: " + socketIndex);
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            BluetoothWrapper.traceWarning("Invalid socket index provided: " + socketIndex);
        }
        return socket;
    }

    private boolean setSockeAtIndex(int socketIndex, RfcommSocket socket) {
        try {
            RfcommSocket oldSocket = this._rfcommSockets.set(socketIndex, socket);
            if (oldSocket != null && socket != null) {
                BluetoothWrapper.traceWarning("Replaced existing socket at index: " + socketIndex);
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            BluetoothWrapper.traceWarning("Invalid socket index provided: " + socketIndex);
            return false;
        }
        return true;
    }

    private int nextFreeSocket() {
        int free = this._rfcommSockets.indexOf(null);
        if (free == -1) {
            this._rfcommSockets.add(null);
            free = this._rfcommSockets.size() - 1;
        }
        return free;
    }

    void handleScanResult(BluetoothDevice device, byte[] manufacturerData, int rawRssi) {
        if (!this.isInitialized()) {
            BluetoothWrapper.traceWarning("Scan result received while in an uninitialized state! Ignoring scan result.");
            return;
        }
        if (manufacturerData == null) {
            BluetoothWrapper.traceWarning("Manufacturer specific data is null, ignoring scan result");
            return;
        }
        String address = device.getAddress();
        BluetoothWrapper.onBTLEDiscovered(address, manufacturerData, rawRssi);
    }

    boolean shouldInitialize(Context context) {
        if (!this.isCapable(context, "initialize")) {
            return false;
        }
        if (this.isInitialized()) {
            BluetoothWrapper.traceWarning("Already initialized. Ignoring subsequent initialize calls.");
            return false;
        }
        return true;
    }

    boolean ensureInitialized(Context context, String callingMethodName) {
        if (!this.isCapable(context, callingMethodName)) {
            return false;
        }
        if (!this.isInitialized()) {
            BluetoothWrapper.traceWarning(String.format("'%s' was called before initialize. Attempting to initialize now...", callingMethodName));
            if (!this.initializeBLE(context)) {
                BluetoothWrapper.traceWarning(String.format("Unable to '%s': Initialization failed", callingMethodName));
                return false;
            }
        }
        return true;
    }

    private boolean isCapable(Context context, String callingMethodName) {
        if (!this.hasBluetoothCapability(context)) {
            BluetoothWrapper.traceWarning(String.format("Unable to '%s': Device is not Bluetooth capable", callingMethodName));
            if (this.isInitialized()) {
                BluetoothWrapper.traceWarning("No longer Bluetooth capable after previous initialization. Unintializing...");
                this.uninitialize();
            }
            return false;
        }
        return true;
    }

    private class BluetoothStateBroadcastReceiver
    extends BroadcastReceiver {
        private BluetoothStateBroadcastReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            Bundle extras = intent.getExtras();
            if (extras != null) {
                boolean shouldStopScan;
                int state = extras.getInt("android.bluetooth.adapter.extra.STATE");
                boolean shouldUninitialize = state == 10 || state == 13;
                boolean bl = shouldStopScan = BluetoothWrapperImpl.this.wasScanStarted() && (state == 12 || state == 11);
                if (shouldUninitialize) {
                    BluetoothWrapper.traceWarning("Detected Bluetooth adapter state changed to off. Uninitializing...");
                    BluetoothWrapperImpl.this.uninitialize();
                } else if (shouldStopScan) {
                    BluetoothWrapper.traceWarning("Detected Bluetooth adapter state changed to on with existing BLE scan. Attempting to stop...");
                    BluetoothWrapperImpl.this.stopScanInternal();
                }
            }
        }
    }
}

