/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.connecteddevices;

import android.content.Context;
import android.support.annotation.Keep;
import com.microsoft.connecteddevices.BluetoothWrapperImpl;

@Keep
final class BluetoothWrapper {
    private static IApiWrapper _wrapperImpl;

    BluetoothWrapper() {
    }

    static void checkAndCreateImpl() {
        if (_wrapperImpl != null) {
            return;
        }
        _wrapperImpl = BluetoothWrapperImpl.createInstance();
    }

    @Keep
    static String getBluetoothMacAddress() {
        BluetoothWrapper.checkAndCreateImpl();
        return _wrapperImpl.getBluetoothMacAddress();
    }

    @Keep
    static boolean hasBluetoothCapability(Context context) {
        BluetoothWrapper.checkAndCreateImpl();
        return _wrapperImpl.hasBluetoothCapability(context);
    }

    @Keep
    static boolean hasBluetoothAdapterEnabled() {
        BluetoothWrapper.checkAndCreateImpl();
        return _wrapperImpl.hasBluetoothAdapterEnabled();
    }

    @Keep
    static boolean hasRequiredFeatures(Context context) {
        BluetoothWrapper.checkAndCreateImpl();
        return _wrapperImpl.hasRequiredFeatures(context);
    }

    @Keep
    static boolean hasRequiredPermissions(Context context) {
        BluetoothWrapper.checkAndCreateImpl();
        return _wrapperImpl.hasRequiredPermissions(context);
    }

    @Keep
    static boolean initializeBLE(Context context) {
        BluetoothWrapper.checkAndCreateImpl();
        return _wrapperImpl.initializeBLE(context);
    }

    @Keep
    static void startScan(Context context) {
        BluetoothWrapper.checkAndCreateImpl();
        _wrapperImpl.startScan(context);
    }

    @Keep
    static void stopScan(Context context) {
        BluetoothWrapper.checkAndCreateImpl();
        _wrapperImpl.stopScan(context);
    }

    @Keep
    static int getRfcommSocket(String address, String service, Context context) {
        BluetoothWrapper.checkAndCreateImpl();
        return _wrapperImpl.getRfcommSocket(address, service, context);
    }

    @Keep
    static int connectRfcommSocket(int socketIndex, Context context) {
        BluetoothWrapper.checkAndCreateImpl();
        return _wrapperImpl.connectRfcommSocket(socketIndex, context);
    }

    @Keep
    static int sendRfcommData(int socketIndex, byte[] data, Context context) {
        BluetoothWrapper.checkAndCreateImpl();
        return _wrapperImpl.sendRfcommData(socketIndex, data, context);
    }

    @Keep
    static int receiveRfcommData(int socketIndex, byte[] buff, Context context) {
        BluetoothWrapper.checkAndCreateImpl();
        return _wrapperImpl.receiveRfcommData(socketIndex, buff, context);
    }

    @Keep
    static int closeRfcommSocket(int socketIndex, Context context) {
        BluetoothWrapper.checkAndCreateImpl();
        return _wrapperImpl.closeRfcommSocket(socketIndex, context);
    }

    @Keep
    static boolean hasErtmCapability() {
        BluetoothWrapper.checkAndCreateImpl();
        return _wrapperImpl.hasErtmCapability();
    }

    static native void onBTLEDiscovered(String var0, byte[] var1, int var2);

    static native void traceWarning(String var0);

    static interface IApiWrapper {
        public String getBluetoothMacAddress();

        public boolean hasBluetoothCapability(Context var1);

        public boolean hasBluetoothAdapterEnabled();

        public boolean hasRequiredFeatures(Context var1);

        public boolean hasRequiredPermissions(Context var1);

        public boolean initializeBLE(Context var1);

        public void startScan(Context var1);

        public void stopScan(Context var1);

        public int getRfcommSocket(String var1, String var2, Context var3);

        public int connectRfcommSocket(int var1, Context var2);

        public int sendRfcommData(int var1, byte[] var2, Context var3);

        public int receiveRfcommData(int var1, byte[] var2, Context var3);

        public int closeRfcommSocket(int var1, Context var2);

        public boolean hasErtmCapability();
    }
}

